/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.lote;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AjusteEstoqueItemLote;
import br.intelidata.commons.domain.pojo.Lote;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.LoteCommonRN;
import br.intelidata.commons.modulo.produto.regranegocio.LoteRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lotes"})
public class LoteCrudController
extends CrudController<Lote, LoteRN> {
    private final ResponseEntityService responseEntityService;
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public LoteCrudController(ResponseEntityService responseEntityService, FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)LoteRN.getInstance(), Lote::new);
        this.responseEntityService = responseEntityService;
        this.funcionalidadeService = funcionalidadeService;
        this.dependsOn("idProduto");
    }

    @RequestMapping(value={"/generate-code"})
    @DBAutoCommit
    public String generateCode(@RequestParam(name="idProduto") Long idProduto, @RequestParam(name="lotes", required=false) List<String> lotesJaUtilizados) {
        Long maiorCodigoLote;
        long maiorCodigoAtual = 0L;
        if (!ListMapUtil.listNullOrEmpty(lotesJaUtilizados)) {
            maiorCodigoAtual = Long.parseLong(String.valueOf(lotesJaUtilizados.stream().map(Util::string2int).max(Integer::compareTo).orElse(0)));
        }
        String code = (maiorCodigoLote = LoteCommonRN.getInstance().buscarProximoCodigo(idProduto, null)).compareTo(maiorCodigoAtual) > 0 ? StringUtil.all2Atring((Object)maiorCodigoLote) : StringUtil.all2Atring((Object)(++maiorCodigoAtual));
        return code;
    }

    @RequestMapping(value={"/filtrar-saida-por-produto"})
    @DBAutoCommit
    public ResponseEntity<String> filtrarLotesProdutoSaida(@RequestParam Long idProduto, @RequestParam boolean permiteLoteVencido, @RequestParam boolean validarSaldoZero, @RequestParam(required=false) Long idFilial, @RequestParam(required=false) Long idLocalEstoque) {
        Unidademedida unidadeMedida;
        Sessao sessao = SessaoUtil.getSessao();
        if (idLocalEstoque == null && this.funcionalidadeService.isAtiva(Funcionalidade.LOCAL_ESTOQUE)) {
            idLocalEstoque = sessao.getUsuario().getIdLocalEstoqueTrabalho();
        }
        List lotes = LoteRN.getInstance().filtrarLotesSaidaAsyncWeb(sessao, idProduto, !NumberUtil.longNullOuZero((Long)idFilial) ? idFilial : sessao.getIdFilial(), idLocalEstoque, !permiteLoteVencido, validarSaldoZero);
        int casasDecimais = 0;
        Map mapProduto = ProdutoRN.getInstance().buscarValoresPorID(idProduto, new String[]{"idunidademedida"});
        if (!Util.mapNullOrEmpty((Map)mapProduto) && (unidadeMedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId((Long)mapProduto.get("idunidademedida"))) != null) {
            casasDecimais = unidadeMedida.getCasasdecimais();
        }
        String mascara = StringUtil.getMascaraQuantidade((int)casasDecimais);
        String json = lotes.stream().map(lote -> new StringBuilder("{\"id\":").append(lote.getId()).append(", \"codigo\":").append(JsonUtil.escapeQuote((String)lote.getCodigo())).append(", \"descricao\":").append(JsonUtil.escapeQuote((String)"Lote: ".concat(lote.getCodigo()).concat(" Fab: ").concat(StringUtil.formataDataHora((Temporal)lote.getFabricacao(), (String)"dd/MM/yy")).concat(" Venc: ").concat(StringUtil.formataDataHora((Temporal)lote.getVencimento(), (String)"dd/MM/yy")).concat(" Saldo: ").concat(StringUtil.bigDecimal2String((BigDecimal)lote.getSaldo(), (String)mascara)).concat(" Saldo previsto: ").concat(StringUtil.bigDecimal2String((BigDecimal)lote.getSaldoPrevisto(), (String)mascara)))).append("}")).collect(Collectors.joining(","));
        return this.responseEntityService.createJSONResponse("[" + json + "]");
    }

    @RequestMapping(value={"/lote-saida-saldo-por-produto"})
    @DBAutoCommit
    public List<Lote> saldoLotesPorProduto(@RequestParam Long idProduto, @RequestParam boolean permiteLoteVencido, @RequestParam boolean validarSaldoZero, @RequestParam(required=false) Long idFilial) {
        return LoteRN.getInstance().filtrarLotesSaidaAsyncWeb(SessaoUtil.getSessao(), idProduto, !NumberUtil.longNullOuZero((Long)idFilial) ? idFilial : SessaoUtil.getSessao().getIdFilial(), SessaoUtil.getSessao().getUsuario().getIdLocalEstoqueTrabalho(), !permiteLoteVencido, validarSaldoZero);
    }

    @RequestMapping(value={"/filtrar-por-produto"})
    @DBAutoCommit
    public ResponseEntity<String> filtrarPorProduto(@RequestParam Long idProduto) {
        List lotes = LoteRN.getInstance().getPorProdutoFilial(idProduto, SessaoUtil.getSessao().getIdFilial());
        String json = lotes.stream().map(lote -> new StringBuilder("{\"id\":").append(lote.getId()).append(", \"codigo\":").append(JsonUtil.escapeQuote((String)lote.getCodigo())).append("}")).collect(Collectors.joining(","));
        return this.responseEntityService.createJSONResponse("[" + json + "]");
    }

    @RequestMapping(value={"/distribuicao"})
    @DBAutoCommit
    public List<AjusteEstoqueItemLote> getLotesDistribuicao(@RequestParam Long idProduto) {
        List lotes = LoteRN.getInstance().getPorProdutoFilial(idProduto, SessaoUtil.getSessao().getFilial().getId());
        return lotes.stream().map(lote -> {
            AjusteEstoqueItemLote itemLote = new AjusteEstoqueItemLote();
            itemLote.setIdLote(lote.getId());
            itemLote.setCodigoLote(lote.getCodigo());
            itemLote.setQuantidade(BigDecimal.ZERO);
            itemLote.setVencimento(lote.getVencimento());
            itemLote.setEmissao(lote.getFabricacao());
            return itemLote;
        }).collect(Collectors.toList());
    }

    protected void beforeUpdate(Lote lote, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        LoteRN.getInstance().validarLoteDuplicado(SessaoUtil.getSessao().getFilial().getId(), lote.getId(), lote.getCodigo(), lote.getIdProduto());
    }

    protected GridBuilder<LoteRN> getGridBuilder() {
        return new GridBuilder(LoteRN.getInstance().getTabela(), Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("codigo", "C\u00f3digo", 100, true), new ColunaSQL("entrada", "Primeira entrada", 120, true), new ColunaSQL("fabricacao", "Fabrica\u00e7\u00e3o", 100, true), new ColunaSQL("vencimento", "Vencimento", 100, true), new ColunaSQL("quantidadeentrada", "Primeira qtd. entrada", 150, true), new ColunaSQL("saldo", "Saldo", 100, true)));
    }

    protected String getCacheId() {
        return "lotes";
    }
}

