/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.promocao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.integracaocrescevendas.EnvioDescontoCresceVendas;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ListagemProdutoPromocao;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.PromocaoProduto;
import br.intelidata.commons.domain.pojo.vendas.PromocaoEntidade;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PromocaoCommonRN;
import br.intelidata.commons.domain.regranegocio.PromocaoFilialCommonRN;
import br.intelidata.commons.domain.regranegocio.PromocaoProdutoCommonRN;
import br.intelidata.commons.modulo.cadastros.relatorio.PromocaoRelatorio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.vendas.regranegocio.ColunaFiliaisPromocao;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoVariacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.FiltroGridPromocaoFilial;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoRelatorioWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/promocoes"})
@SubMenuMapping(NOME="Promo\u00e7\u00f5es", ICONE="icon-promocao-produto", PROGRAMA=10, MENU="SubMenuVendasGeral", ROTA="/vendas/promocoes")
public class PromocaoCrudController
extends CrudController<Promocao, PromocaoRN> {
    public PromocaoCrudController() {
        super((AbstractRegraNegocio)PromocaoRN.getInstance(), Promocao::new, true, true);
    }

    @DBTransaction
    public Long create(@RequestBody Promocao promocao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)promocao.getId())) {
            return super.create((AbstractPojo)promocao, parentId);
        }
        return super.update((AbstractPojo)promocao, parentId);
    }

    @RequestMapping(value={"/carregar-produtos"})
    @DBTransaction
    public List<ListagemProdutoPromocao> carregarPromocoesDetalheProduto(@RequestParam Long idProduto) {
        return PromocaoCommonRN.getInstance().montaListaPromocaoPorProduto(idProduto, true);
    }

    protected void afterCreate(Promocao promocao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        PromocaoFilialCommonRN.getInstance().incluirLista(SessaoUtil.getSessao(), promocao, promocao.getFiliaisCadastroPromocao());
    }

    protected void afterUpdate(Promocao promocao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        PromocaoFilialCommonRN.getInstance().excluirPorIdPromocao(sessao, promocao.getId());
        PromocaoFilialCommonRN.getInstance().incluirLista(sessao, promocao, promocao.getFiliaisCadastroPromocao());
    }

    protected void beforeSave(Promocao promocao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (promocao.isContinua()) {
            promocao.setDataInicial(DataHoraFactory.getData());
            promocao.setDataFinal(DataHoraFactory.of((int)3000, (int)12, (int)31));
        }
    }

    protected void afterSave(Promocao promocao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.listNullOrEmpty((List)promocao.getProdutosPromocao())) {
            for (PromocaoProduto pp : promocao.getProdutosPromocao()) {
                PromocaoProdutoCommonRN.getInstance().gravarEmbalagens(pp, SessaoUtil.getSessao());
            }
        }
    }

    protected GridBuilder<PromocaoRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("codigo", "C\u00f3digo", 90, true), new ColunaSQL("nome", "Nome", 0, true), new ColunaSQL("dataInicial", "Data inicial", 150, true), new ColunaSQL("dataFinal", "Data final", 150, true));
        GridBuilder grid = new GridBuilder(PromocaoRN.getInstance().getTabela(), colunas);
        if (LicencaManager.getInstance().isEnterprise()) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaFiliaisPromocao(SessaoUtil.getSessao()));
        }
        return grid;
    }

    public List<Coluna> getColunasCustomizaveis() {
        return ((PromocaoRN)this.rn).getColunaGridCustomizavelPromocaoWW();
    }

    protected void beforeRead(Promocao promocao, int modo, Optional<Long> parentId) {
        promocao.setPromocaoPor(PromocaoCommonRN.getInstance().promocaoPorWeb(promocao.getId()));
        if (!ListMapUtil.listNullOrEmpty((List)promocao.getProdutosPromocao())) {
            promocao.getProdutosPromocao().forEach(promocaoProduto -> promocaoProduto.setVariacoes(PromocaoVariacaoRN.getInstance().buscarListPorPromocaoProduto(promocaoProduto.getIdPromocao(), promocaoProduto.getIdProduto())));
        }
    }

    @RequestMapping(value={"/imprimir"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimir(@RequestBody PromocaoRelatorioWrapper wrapper) throws UnicoMensagemUsuarioException {
        Remessa remessa = new PromocaoRelatorio(wrapper.getPromocao()).imprimir(wrapper.getSaidaRelatorio().getSaida(), wrapper.getDelimitador(), wrapper.getExtensao());
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)wrapper.getSaidaRelatorio(), (String)("promocao_" + wrapper.getPromocao().getCodigo()));
    }

    @RequestMapping(value={"/enviar-cresce-vendas"}, method={RequestMethod.POST})
    @DBAutoCommit
    public String enviarPromocoesVigentesFuturas() throws UnicoMensagemUsuarioException {
        int qtd = new EnvioDescontoCresceVendas(SessaoUtil.getSessao().getFilial()).enviarPromocoesVigentesFuturas();
        return "Envio conclu\u00eddo. Quantidade de promo\u00e7\u00f5es enviadas: " + qtd;
    }

    @RequestMapping(value={"/promocao-por-produto"})
    @DBAutoCommit
    public Promocao buscarPromocaoProduto(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        List promocoes = PromocaoRN.getInstance().montaListaPromocaoPorProduto(idProduto, true);
        if (promocoes.isEmpty()) {
            throw new UnicoMensagemUsuarioException("WPRD444", "O produto selecionado n\u00e3o est\u00e1 em nenhuma promo\u00e7\u00e3o vigente");
        }
        return PromocaoRN.getInstance().buscarPorId(Long.valueOf(Util.string2long((String)((ListagemProdutoPromocao)promocoes.get(0)).getIdPromocao())));
    }

    protected String getCacheId() {
        return "promocoes";
    }

    @RequestMapping(value={"/promocoes-clientes-kit"})
    @DBTransaction
    public List<PromocaoEntidade> carregarPromocoesEntidade(@RequestParam Long idPromocao) {
        return EntidadeRN.getInstance().buscarListaPorIdPromocaoScanntech(idPromocao);
    }

    protected void prepareGrid() throws UnicoMensagemUsuarioException {
        super.prepareGrid();
        this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridPromocaoFilial());
    }
}

