/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.promocao.hierarquia;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.PromocaoHierarquia;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PromocaoCommonRN;
import br.intelidata.commons.domain.regranegocio.PromocaoHierarquiaCommonRN;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoHierarquiaRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.BuscarDadosWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoReturnWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/promocoes-hierarquia"})
public class PromocaoHierarquiaCrudController
extends CrudController<PromocaoHierarquia, PromocaoHierarquiaRN> {
    @Autowired
    public PromocaoHierarquiaCrudController() {
        super((AbstractRegraNegocio)PromocaoHierarquiaRN.getInstance(), PromocaoHierarquia::new);
        this.dependsOn("idPromocao");
    }

    @RequestMapping(value={"/validar-promocao"})
    @DBAutoCommit
    public boolean validarGrupoPromocao(@RequestParam(value="idPromocao") Long idPromocao, @RequestParam(required=false, value="id") Long idPromocaoGrupo, @RequestParam(value="value") Long idGrupo) {
        boolean isValidar = idPromocaoGrupo == null || !((PromocaoHierarquia)PromocaoHierarquiaRN.getInstance().buscarPorId(idPromocaoGrupo)).getIdHierarquia().equals(idGrupo);
        return !isValidar || idPromocao == null || idGrupo == null || PromocaoHierarquiaRN.getInstance().buscaPorHierarquiaPromocao(idPromocao, idGrupo) == null;
    }

    @RequestMapping(value={"/incluir"}, method={RequestMethod.POST})
    @DBTransaction
    public PromocaoReturnWrapper gravarDados(@RequestBody PromocaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Promocao promocao = wrapper.getPromocao();
        PromocaoHierarquia promocaoHierarquia = wrapper.getPromocaoGrupo();
        Long idPai = PromocaoCommonRN.getInstance().incluir(promocao, SessaoUtil.getSessao());
        promocaoHierarquia.setIdPromocao(idPai);
        Long idFilho = PromocaoHierarquiaCommonRN.getInstance().incluir((AbstractPojo)promocaoHierarquia, SessaoUtil.getSessao());
        return new PromocaoReturnWrapper(idPai, idFilho);
    }

    @RequestMapping(value={"/buscar-produtos"})
    @DBAutoCommit
    public List<BuscarDadosWrapper> buscarProdutos(@RequestParam Long id) {
        return ProdutoRN.getInstance().getlistaProdutosNaPromocaoHierarquia(id).stream().map(map -> new BuscarDadosWrapper((String)map.get("nome"), (String)map.get("codigo"))).collect(Collectors.toList());
    }

    protected GridBuilder<PromocaoHierarquiaRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("idPromocao", "idPromocao", 0, false), new ColunaSQL("idHierarquia", "idHierarquia", 0, false), new ColunaSQL("nome", "nomeHierarquia", "Grupo", 40, true, new String[]{"fk_promocaohierarquia_hie"}), new ColunaSQL("valor", "Valor", 40, true), new ColunaSQL("percentual", "Percentual", 50, true));
        return new GridBuilder(PromocaoHierarquiaRN.getInstance().getTabela(), colunas);
    }

    protected void beforeCreate(PromocaoHierarquia promocaoHierarquia, Optional<Long> parentId) {
        promocaoHierarquia.setCodigo(PromocaoRN.getInstance().buscarPorId(promocaoHierarquia.getIdPromocao()).getCodigo());
        promocaoHierarquia.setHierarquia(((HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(promocaoHierarquia.getIdHierarquia())).getCodigo());
    }

    protected void beforeUpdate(PromocaoHierarquia promocaoHierarquia, Optional<Long> parentId) {
        promocaoHierarquia.setHierarquia(((HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(promocaoHierarquia.getIdHierarquia())).getCodigo());
    }

    protected String getCacheId() {
        return "promocoes-hierarquia";
    }
}

