/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.reajustespreco;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.FormacaoPreco;
import br.intelidata.commons.domain.pojo.ProgramacaoAlteracaoPrecoItem;
import br.intelidata.commons.domain.pojo.ProgramacaoAlteracaoPrecoItemPautaPreco;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocioSimplificada;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoItemRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Optional;

public class ReajustePrecoRN
extends AbstractRegraNegocioSimplificada {
    private static ReajustePrecoRN instance;

    private ReajustePrecoRN() {
    }

    public static ReajustePrecoRN getInstance() {
        if (instance == null) {
            instance = new ReajustePrecoRN();
        }
        return instance;
    }

    public String reajustarPrecos(Sessao sessao, Long idPauta, List<ProgramacaoAlteracaoPrecoItem> itens, LocalDate dataProgramacao) throws UnicoMensagemUsuarioException {
        if (PropriedadeRN.getInstance().isProgramacaoReajustePreco(sessao.getFilial())) {
            if (!Util.longNullOuZero((Long)idPauta)) {
                itens.forEach(item -> {
                    FormacaoPreco formacaoPreco = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRECO_POR_FILIAL) ? FormacaoPrecoRN.getInstance().getFormacaoPrecoPorFilialProduto(sessao.getFilial(), sessao.getFilial().getId(), item.getIdProduto()) : FormacaoPrecoRN.getInstance().getFormacaoPrecoPorProduto(sessao, item.getIdProduto());
                    if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
                        Optional<ProgramacaoAlteracaoPrecoItemPautaPreco> optionalPautaPreco;
                        ProgramacaoAlteracaoPrecoItemPautaPreco pautaPreco = null;
                        if (!Util.listNullOrEmpty((List)item.getPautasPreco()) && (optionalPautaPreco = item.getPautasPreco().stream().filter(programacaoAlteracaoPrecoItemPautaPreco -> programacaoAlteracaoPrecoItemPautaPreco.getIdPauta().equals(idPauta)).findFirst()).isPresent()) {
                            pautaPreco = optionalPautaPreco.get();
                        }
                        if (pautaPreco == null) {
                            pautaPreco = new ProgramacaoAlteracaoPrecoItemPautaPreco();
                            pautaPreco.setIdPauta(idPauta);
                            pautaPreco.setPrecoVendaAjustado(item.getNovoPrecoProduto());
                            item.addPautaPreco(pautaPreco);
                        } else {
                            pautaPreco.setPrecoVendaAjustado(item.getNovoPrecoProduto());
                        }
                    } else {
                        BeanUtil.set((Object)item, (String)("precoVendaAjustadoPauta" + idPauta), (Object)item.getNovoPrecoProduto());
                    }
                    item.setNovoPrecoProduto(formacaoPreco.getPrecoVendaAjustado());
                    item.setPrecoAnterior(formacaoPreco.getPrecoVendaAjustado());
                });
            }
            boolean isPrecoKitAlterado = ProgramacaoAlteracaoPrecoRN.getInstance().programarReajustePreco(sessao, dataProgramacao, itens);
            String mensagem = "";
            if (ProgramacaoAlteracaoPrecoItemRN.getInstance().isPossuiPrecoZerado(itens)) {
                mensagem = mensagem + "Produtos com pre\u00e7o ajustado menor ou igual a zero foram desconsiderados durante a atualiza\u00e7\u00e3o.<br>";
            }
            if (isPrecoKitAlterado && (PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 243) || PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 244))) {
                mensagem = mensagem + "Um ou mais produtos pertencem a kits. Como o pre\u00e7o/custo foi alterado, tamb\u00e9m ser\u00e1 alterado o pre\u00e7o dos kits \u00e0 que eles pertencem.<br>";
            }
            return mensagem + "Os novos pre\u00e7os dos produtos foram programados para " + Util.formataDataHora((Temporal)dataProgramacao, (String)"dd/MM/yyyy");
        }
        boolean existemPrecosZerados = ProdutoRN.getInstance().ajustarPrecos(sessao, idPauta, itens);
        String mesangemKitAlterado = ProdutoRN.getInstance().alterarPrecoKitPaiPorProdutoComponente(sessao, itens);
        String mensagem = "";
        if (existemPrecosZerados) {
            mensagem = mensagem + "Produtos com pre\u00e7o ajustado menor ou igual a zero foram desconsiderados durante a atualiza\u00e7\u00e3o.<br>";
        }
        if (!Util.stringNullOrEmpty((String)mesangemKitAlterado) && PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 243)) {
            mensagem = mensagem + "Os seguintes kit(s) ter\u00e3o pre\u00e7o alterado, devido iten(s) que pertencem ao(s) mesmo(s) que tiveram pre\u00e7o reajustado." + mesangemKitAlterado + "<br>";
        }
        return mensagem + "Reajuste de pre\u00e7o gravado com sucesso";
    }
}

