/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.regrasfiscais;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.enuns.TipoEnquadramentoFilial;
import br.intelidata.commons.domain.pojo.notafiscal.RegraFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.RegraFiscalCestRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.RegraFiscalCfopXmlRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.RegraFiscalGrupoProdutoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.RegraFiscalNcmRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.RegraFiscalProdutoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.RegraFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.regrasfiscais.EnquadramentoFilialWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/regra-fiscal"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Regras fiscais", ROTA="/notas-fiscais/regra-fiscal", PROGRAMA=1000086)
public class RegraFiscalCrudController
extends CrudController<RegraFiscal, RegraFiscalRN> {
    public RegraFiscalCrudController() {
        super((AbstractRegraNegocio)RegraFiscalRN.getInstance(), RegraFiscal::new);
    }

    protected String getCacheId() {
        return "regra-fiscal";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("descricao", "desctipo", "Tipo", 0, true, new String[]{"fk_regrafiscal_tipo"}));
        return new GridBuilder(((RegraFiscalRN)this.rn).getTabela(), colunas);
    }

    protected void read(RegraFiscal regraFiscal, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        regraFiscal.setProdutos(RegraFiscalProdutoRN.getInstance().buscarPorIdRegra(regraFiscal.getId()));
        regraFiscal.setCests(RegraFiscalCestRN.getInstance().buscarPorIdRegra(regraFiscal.getId()));
        regraFiscal.setGrupos(RegraFiscalGrupoProdutoRN.getInstance().buscarPorIdRegra(regraFiscal.getId()));
        regraFiscal.setNcms(RegraFiscalNcmRN.getInstance().buscarPorIdRegra(regraFiscal.getId()));
        regraFiscal.setCfops(RegraFiscalCfopXmlRN.getInstance().buscarPorIdRegra(regraFiscal.getId()));
    }

    @RequestMapping(value={"/verificar-enquadramento"})
    @DBAutoCommit
    public EnquadramentoFilialWrapper enquadramentoFilial() {
        EnquadramentoFilialWrapper enquadramento = new EnquadramentoFilialWrapper();
        List enquadramentos = FilialRN.getInstance().buscarListaEnquadramento();
        enquadramento.setPossuiFilialLucro(enquadramentos.stream().anyMatch(e -> !TipoEnquadramentoFilial.SIMPLESNACIONAL.equals(e)));
        enquadramento.setPossuiFilialSN(enquadramentos.stream().anyMatch(arg_0 -> TipoEnquadramentoFilial.SIMPLESNACIONAL.equals(arg_0)));
        return enquadramento;
    }
}

