/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.relatorio;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.enuns.LocalizacaoRelatorioWeb;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoWeb;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.ferramentas.regranegocio.RelatorioConfiguradoWebRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class RelatorioCrudController
extends CrudController<RelatorioConfiguradoWeb, RelatorioConfiguradoWebRN> {
    public RelatorioCrudController(boolean carregarAposLogout, boolean permiteConfigurarGrid) {
        super((AbstractRegraNegocio)RelatorioConfiguradoWebRN.getInstance(), RelatorioConfiguradoWeb::new, carregarAposLogout, true, permiteConfigurarGrid);
    }

    @RequestMapping(value={"/buscar-filtros"})
    @DBAutoCommit
    public RelatorioConfiguradoWeb buscarParametrosFiltros(@RequestParam Long idRelatorio) throws UnicoMensagemUsuarioException {
        RelatorioConfiguradoWeb relatorio = (RelatorioConfiguradoWeb)RelatorioConfiguradoWebRN.getInstance().buscarPorId(idRelatorio);
        if (relatorio != null) {
            return relatorio;
        }
        throw new UnicoMensagemUsuarioException("WWW423", "Relat\u00f3rio n\u00e3o encontrado.");
    }

    protected void afterSave(RelatorioConfiguradoWeb relatorioConfiguradoWeb, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.cacheService.clear();
    }

    protected void beforeDelete(RelatorioConfiguradoWeb relatorioConfiguradoWeb) {
        this.cacheService.clear();
    }

    protected List<ColunaSQL> getColunas() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idRelatorioPai", "idrelatoriopai", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("localizacao", "Localiza\u00e7\u00e3o", 0, true, LocalizacaoRelatorioWeb.class));
        return colunas;
    }
}

