/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.servico.comboservico;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.ComboServico;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.ComboServicoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/combos-servico"})
public class ComboServicoCrudController
extends CrudController<ComboServico, ComboServicoRN> {
    public ComboServicoCrudController() {
        super((AbstractRegraNegocio)ComboServicoRN.getInstance(), ComboServico::new);
    }

    protected GridBuilder<ComboServicoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idServicoCombo", "idServicoCombo", 0, false));
        colunas.add(new ColunaSQL("idServicoLicenca", "idServicoLicenca", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigo", "C\u00f3digo", 80, true, new String[]{"fk_comboservico_licenca"}));
        colunas.add(new ColunaSQL("nome", "nome", "Nome", 150, true, new String[]{"fk_comboservico_licenca"}));
        return new GridBuilder(ComboServicoRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(ComboServico comboServico, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)comboServico.getIdServicoCombo()) || NumberUtil.longNullOuZero((Long)comboServico.getIdServicoLicenca())) {
            throw new UnicoMensagemUsuarioException("WWW683", "Combo n\u00e3o informado.");
        }
        if (comboServico.getIdServicoCombo().equals(comboServico.getIdServicoLicenca())) {
            throw new UnicoMensagemUsuarioException("WPRD410", "N\u00e3o \u00e9 poss\u00edvel relacionar um combo \u00e0 ele mesmo.");
        }
        List combos = ComboServicoRN.getInstance().buscarListaPorProduto(comboServico.getIdServicoCombo());
        boolean produtoExistente = combos.stream().anyMatch(p -> p.getIdServicoLicenca().equals(comboServico.getIdServicoLicenca()) && (NumberUtil.longNullOuZero((Long)comboServico.getId()) || !comboServico.getId().equals(p.getId())));
        if (produtoExistente) {
            throw new UnicoMensagemUsuarioException("WPRD411", "Licen\u00e7a j\u00e1 inclu\u00edda.");
        }
    }

    protected String getCacheId() {
        return "combos-servico";
    }
}

