/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tipocomissao.hierarquia;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.financeiro.TipoComissaoHierarquia;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.comissao.regranegocio.TipoComissaoHierarquiaRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-comissao-hierarquia"})
public class TipoComissaoHierarquiaCrudController
extends CrudController<TipoComissaoHierarquia, TipoComissaoHierarquiaRN> {
    public TipoComissaoHierarquiaCrudController() {
        super((AbstractRegraNegocio)TipoComissaoHierarquiaRN.getInstance(), TipoComissaoHierarquia::new);
        this.dependsOn("idTipoComissao");
    }

    protected GridBuilder<TipoComissaoHierarquiaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idTipoComissao", "idTipoComissao", 0, false));
        colunas.add(new ColunaSQL("idHierarquia", "idHierarquia", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoHierarquia", "Grupo", 30, true, new String[]{"fk_tipcomhier_hier"}));
        colunas.add(new ColunaSQL("nome", "nomeHierarquia", "Grupo", 30, true, new String[]{"fk_tipcomhier_hier"}));
        colunas.add(new ColunaSQL("comissao", "% Comiss\u00e3o", 50, true));
        colunas.add(new ColunaSQL("comissaoAVista", "% Comiss\u00e3o \u00e0 vista", 50, true));
        colunas.add(new ColunaSQL("comissaoAPrazo", "% Comiss\u00e3o a prazo", 50, true));
        colunas.add(new ColunaSQL("comissaoQuitacao", "% Comiss\u00e3o na quita\u00e7\u00e3o", 50, true));
        return new GridBuilder(TipoComissaoHierarquiaRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(TipoComissaoHierarquia tipoComissaoHierarquia, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)tipoComissaoHierarquia.getIdTipoComissao())) {
            throw new UnicoMensagemUsuarioException("WWW86", "Comiss\u00e3o n\u00e3o informada.");
        }
        if (NumberUtil.longNullOuZero((Long)tipoComissaoHierarquia.getIdHierarquia())) {
            throw new UnicoMensagemUsuarioException("WCMS29", "Grupo de produto n\u00e3o informado! Verifique.");
        }
        if (this.hierarquiaExiste(tipoComissaoHierarquia.getIdTipoComissao(), tipoComissaoHierarquia.getId(), tipoComissaoHierarquia.getIdHierarquia())) {
            throw new UnicoMensagemUsuarioException("WCMS31", "Grupo de produto j\u00e1 existe na lista! Verifique.");
        }
    }

    protected String getCacheId() {
        return "tipos-comissao-hierarquia";
    }

    private boolean hierarquiaExiste(Long idTipoComissao, Long id, Long idHierarquia) {
        return TipoComissaoHierarquiaRN.getInstance().buscarComissaoPorTipoComissaoHierarquia(idTipoComissao, idHierarquia) != null && (NumberUtil.longNullOuZero((Long)id) || !((TipoComissaoHierarquia)TipoComissaoHierarquiaRN.getInstance().buscarPorId(id)).getIdHierarquia().equals(idHierarquia));
    }
}

