/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.configuracao;

import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.b2c.ConfiguracaoShop;
import br.intelidata.commons.domain.pojo.b2c.Pagina;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocioSimplificada;
import br.intelidata.commons.domain.regranegocio.b2c.PaginaRN;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguracaoArquivosShopRN
extends AbstractRegraNegocioSimplificada {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PATH_DEFAULT = File.separator + "var" + File.separator + "app" + File.separator + "uniplusshop" + File.separator + "config";

    public void salvarConfiguracoes(ConfiguracaoShop configuracaoShop) {
        String pastaSite = configuracaoShop.getDominio().replaceAll("https://", "").replaceAll("www.", "");
        this.verificarDiretorio(pastaSite);
        this.gerarJsonConfiguracao(configuracaoShop, pastaSite);
        this.gerarRobots(configuracaoShop, pastaSite);
        this.gerarSiteMap(configuracaoShop, pastaSite);
    }

    private void verificarDiretorio(String pastaSite) {
        Path path = Paths.get(PATH_DEFAULT + File.separator + pastaSite, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.error("N\u00e3o foi poss\u00edvel criar o diret\u00f3rio do site.", (Throwable)e);
            }
        }
    }

    private void gerarJsonConfiguracao(ConfiguracaoShop configuracaoShop, String pastaSite) {
        try {
            String pathJason = PATH_DEFAULT + File.separator + pastaSite + File.separator + "settings.json";
            Files.deleteIfExists(Paths.get(pathJason, new String[0]));
            try (FileOutputStream stream = new FileOutputStream(pathJason);
                 OutputStreamWriter json = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
                json.write(JSONUtil.getJSONObject((Object)configuracaoShop).toString());
            }
            catch (IOException e) {
                this.logger.error("N\u00e3o foi poss\u00edvel salvar o arquivo de configura\u00e7\u00e3o do Uniplus Shop em disco.", (Throwable)e);
            }
        }
        catch (IOException e) {
            this.logger.error("N\u00e3o foi poss\u00edvel excluir o arquivo 'robots.txt' do Uniplus Shop em disco.", (Throwable)e);
        }
    }

    private void gerarRobots(ConfiguracaoShop configuracaoShop, String pastaSite) {
        try {
            String pathRobots = PATH_DEFAULT + File.separator + pastaSite + File.separator + "robots.txt";
            Files.deleteIfExists(Paths.get(pathRobots, new String[0]));
            try (FileOutputStream stream = new FileOutputStream(pathRobots);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
                writer.write("user-agent: Googlebot\n");
                writer.write("Disallow: \n");
                writer.write("\n");
                writer.write("user-agent: Googlebot-image\n");
                writer.write("Disallow: \n");
                writer.write("\n");
                writer.write("user-agent: *\n");
                writer.write("Allow: /$\n");
                writer.write("Disallow: /\n");
                writer.write("\n");
                writer.write("Sitemap: " + configuracaoShop.getDominio() + "/sitemap.xml");
            }
            catch (IOException e) {
                this.logger.error("N\u00e3o foi poss\u00edvel salvar o arquivo 'robots.txt' do Uniplus Shop em disco.", (Throwable)e);
            }
        }
        catch (IOException e) {
            this.logger.error("N\u00e3o foi poss\u00edvel excluir o arquivo 'robots.txt' do Uniplus Shop em disco.", (Throwable)e);
        }
    }

    private void gerarSiteMap(ConfiguracaoShop configuracaoShop, String pastaSite) {
        List paginas = PaginaRN.getInstance().buscarListaSEO();
        LocalDateTime dataHora = DataHoraFactory.getDataHora();
        String dominio = configuracaoShop.getDominio();
        String pathSitemap = PATH_DEFAULT + File.separator + pastaSite + File.separator + "sitemap.xml";
        try {
            Files.deleteIfExists(Paths.get(pathSitemap, new String[0]));
            try (FileOutputStream stream = new FileOutputStream(pathSitemap);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
                writer.write(this.getInicioXml());
                writer.write(Util.newLine());
                writer.write(this.getMapHome(dominio, dataHora));
                writer.write(Util.newLine());
                writer.write(this.getMapAccount(dominio, dataHora));
                writer.write(Util.newLine());
                writer.write(this.getMapContact(dominio, dataHora));
                writer.write(Util.newLine());
                writer.write(this.getMapPolicy(dominio, dataHora));
                for (Pagina pagina : paginas) {
                    writer.write(Util.newLine());
                    writer.write(this.getMapOthersPage(dominio, pagina.getLink().trim(), dataHora));
                }
                writer.write(Util.newLine());
                writer.write("</urlset>");
            }
            catch (IOException e) {
                this.logger.error("N\u00e3o foi poss\u00edvel salvar o arquivo 'robots.txt' do Uniplus Shop em disco.", (Throwable)e);
            }
        }
        catch (IOException e) {
            this.logger.error("N\u00e3o foi poss\u00edvel excluir o arquivo 'robots.txt' do Uniplus Shop em disco.", (Throwable)e);
        }
    }

    private String getMapHome(String dominio, LocalDateTime dataHora) {
        return "    <url>\n        <loc>" + dominio + "</loc>\n        <lastmod>" + Util.formataDataHora((Temporal)dataHora, (String)"yyyy-MM-dd'T'HH:mm:ss.SSSz") + "</lastmod>\n        <changefreq>weekly</changefreq>\n        <priority>1.00</priority>\n    </url>";
    }

    private String getMapAccount(String dominio, LocalDateTime dataHora) {
        return "    <url>\n        <loc>" + dominio + "/account</loc>\n        <lastmod>" + Util.formataDataHora((Temporal)dataHora, (String)"yyyy-MM-dd'T'HH:mm:ss.SSSz") + "</lastmod>\n        <changefreq>weekly</changefreq>\n        <priority>0.80</priority>\n    </url>";
    }

    private String getMapContact(String dominio, LocalDateTime dataHora) {
        return "    <url>\n        <loc>" + dominio + "/contact</loc>\n        <lastmod>" + Util.formataDataHora((Temporal)dataHora, (String)"yyyy-MM-dd'T'HH:mm:ss.SSSz") + "</lastmod>\n        <changefreq>weekly</changefreq>\n        <priority>0.80</priority>\n    </url>";
    }

    private String getMapPolicy(String dominio, LocalDateTime dataHora) {
        return "    <url>\n        <loc>" + dominio + "/policy</loc>\n        <lastmod>" + Util.formataDataHora((Temporal)dataHora, (String)"yyyy-MM-dd'T'HH:mm:ss.SSSz") + "</lastmod>\n        <changefreq>weekly</changefreq>\n        <priority>0.80</priority>\n    </url>";
    }

    private String getMapOthersPage(String dominio, String link, LocalDateTime dataHora) {
        return "    <url>\n        <loc>" + dominio + "/pages/" + link + "</loc>\n        <lastmod>" + Util.formataDataHora((Temporal)dataHora, (String)"yyyy-MM-dd'T'HH:mm:ss.SSSz") + "</lastmod>\n        <changefreq>weekly</changefreq>\n        <priority>0.80</priority>\n    </url>";
    }

    private String getInicioXml() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset   xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"\n          xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n          xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9\n            http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\">";
    }
}

