/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.placeholder;

import br.intelidata.api.b2c.service.placeholder.PlaceHolderCDNService;
import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.placeholder.ParamsJobWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.uniplusshop.placeholder.PlaceHolderJob;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/jobs/place-holder"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-back-ofice-servidor", NOME="Imagens Uniplus Shop", ROTA="/intelidata/place-holder", PROGRAMA=9000029)
public class PlaceHolderController
extends SimpleController
implements ICreateTask {
    private final PlaceHolderCDNService placeHolderCDNService;
    private final TaskManager taskManager;

    public PlaceHolderController(PlaceHolderCDNService placeHolderCDNService, TaskManager taskManager) {
        this.placeHolderCDNService = placeHolderCDNService;
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return TipoJob.UPLOAD_IMAGENS;
    }

    public Class<? extends AbstractJob> job() {
        return PlaceHolderJob.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @PostMapping(value={"/processar"})
    @DBTransaction
    public void processarArquivosCdn(@RequestPart(value="file") MultipartFile[] files) throws UnicoMensagemUsuarioException {
        Path diretorioTemporario = Paths.get(this.placeHolderCDNService.getDiretorioBase() + File.separator + "imagens_" + System.currentTimeMillis(), new String[0]);
        try {
            if (!Files.exists(diretorioTemporario, new LinkOption[0])) {
                Files.createDirectory(diretorioTemporario, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW603", "N\u00e3o foi poss\u00edvel criar o diret\u00f3rio tempor\u00e1rio.");
        }
        for (MultipartFile file : files) {
            String nomeArquivo = file.getOriginalFilename() != null ? file.getOriginalFilename() : file.getName();
            try {
                Files.copy(file.getInputStream(), diretorioTemporario.resolve(nomeArquivo), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("WWW604", "N\u00e3o foi poss\u00edvel processar o upload do arquivo.", (Throwable)e);
            }
        }
        ParamsJobWrapper paramsJobWrapper = new ParamsJobWrapper(diretorioTemporario.toString(), ParamsJobWrapper.Servico.PlaceHolderCDN);
        this.createTask((Object)paramsJobWrapper, "Envio de imagens ao CDN do Uniplus Shop");
    }

    @Async
    @GetMapping(value={"/reprocessar"})
    public void processarDiretorioCdn() {
        this.placeHolderCDNService.verificarArquivosDiretorioBase();
    }
}

