/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.estoque.inventarioEstoque;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.contabil.MesFiscal;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioMensalRN;
import br.intelidata.commons.modulo.inventarioestoque.relatorio.InventarioEstoqueRelatorio;
import br.intelidata.commons.sped.fiscal.TipoCalculoCusto;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.estoque.inventarioEstoque.InventarioEstoque;
import java.time.LocalDate;

public class InventarioEstoqueReportExecuter
extends AbstractReporteExecute<InventarioEstoque> {
    public InventarioEstoqueReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        InventarioEstoque inventarioEstoque = (InventarioEstoque)this.fromJson(parametrosObj, InventarioEstoque.class);
        return this.executa(sessao, inventarioEstoque);
    }

    public Remessa executa(Sessao sessao, InventarioEstoque parametros) throws UnicoMensagemUsuarioException {
        if (parametros.getTipoCalculoCusto().equals((Object)TipoCalculoCusto.CUSTO_MEDIO_DATA) || parametros.getTipoCalculoCusto().equals((Object)TipoCalculoCusto.CUSTO_MEDIO_ATUAL)) {
            LocalDate dataBase = parametros.getDataEstoque() == null ? DataHoraFactory.getData() : parametros.getDataEstoque();
            String ano = String.valueOf(dataBase.getYear());
            MesFiscal mes = (MesFiscal)EnumUtils.getPorId(MesFiscal.class, (Object)dataBase.getMonthValue());
            if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CUSTO_MEDIO_MENSAL)) {
                if (CustoMedioMensalRN.getInstance().isExisteRegistrosPendentesDeCalculo(Contexto.getInstance().getFilial().getIdEmpresa(), ano, mes)) {
                    throw new UnicoMensagemUsuarioException("WEST41", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
                }
            } else if (CustoMedioDiarioRN.getInstance().isExisteRegistrosPendentesDeCalculo(((Filial)parametros.getFiliais().get(0)).getId(), ano, mes)) {
                throw new UnicoMensagemUsuarioException("WEST42", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
            }
        }
        return new InventarioEstoqueRelatorio().getRelatorio(Contexto.getInstance().getSessao(), parametros.getSaida(), parametros.getFiliais(), parametros.getDataEstoque(), parametros.getModeloImpressao().getId().intValue(), parametros.getTipoCalculoCusto().getIdInt(), parametros.getNumeroLivro(), parametros.getPaginaInicial(), null, true, parametros.isListarTotaisPorIcmsPisCofins(), parametros.getTiposProduto(), parametros.getIdListaProdutos());
    }
}

