/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.versao;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.batch.serices.TaskService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.versao.JobDownloadVersao;
import br.intelidata.uniplusweb.web.rest.app.wrapper.BuildWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.VersaoWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VersaoController
implements ICreateTask {
    private static final String URL_BASE = "https://builds.unipluscdn.com/uniplusweb/";
    private static final String DIRETORIO = SystemUtil.getDiretorioAplicacao();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionOAuth2Service connectionOAuth2Service;
    private final TaskManager taskManager;
    private final TaskService taskService;

    public VersaoController(ConnectionOAuth2Service connectionOAuth2Service, TaskManager taskManager, TaskService taskService) {
        this.connectionOAuth2Service = connectionOAuth2Service;
        this.taskManager = taskManager;
        this.taskService = taskService;
    }

    public TipoJob getTipoJob() {
        return TipoJob.DOWNLOAD_VERSAO;
    }

    public Class<? extends AbstractJob> job() {
        return JobDownloadVersao.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"/versao-atual"})
    public String getVersao() {
        return UnicoSistema.getVersao();
    }

    @RequestMapping(value={"/api/versoes/versoes-disponiveis"})
    @DBAutoCommit
    public BuildWrapper versoesDisponiveis() throws UnicoMensagemUsuarioException {
        List dados;
        try {
            ResponseEntity response = this.connectionOAuth2Service.get("/versoes-disponiveis", List.class, new Object[0]);
            if (response == null || response.getStatusCode() != HttpStatus.OK || response.getBody() == null) {
                throw new UnicoMensagemUsuarioException("WWW381", "N\u00e3o foi poss\u00edvel obter as vers\u00f5es dispon\u00edveis.");
            }
            List dadosRetorno = (List)response.getBody();
            dados = dadosRetorno != null ? dadosRetorno : Collections.emptyList();
        }
        catch (Exception ex) {
            this.log.error("N\u00e3o foi poss\u00edvel buscar as vers\u00f5es dispon\u00edveis do sistema.", (Throwable)ex);
            dados = Collections.emptyList();
        }
        List versoes = dados.stream().map(map -> {
            VersaoWrapper versao = new VersaoWrapper();
            versao.setVersao((String)map.get("nome"));
            versao.setBuild(NumberUtil.converteVersao((String)((String)map.get("build"))));
            versao.setMd5((String)map.get("md5"));
            versao.setLink("https://builds.unipluscdn.com/uniplusweb/uniplusweb-" + versao.getVersao() + "-" + (String)map.get("build") + ".zip");
            versao.setDescricao("uniplusweb-" + versao.getVersao() + "-" + (String)map.get("build"));
            return versao;
        }).sorted(Comparator.comparing(VersaoWrapper::getBuild).reversed()).collect(Collectors.toList());
        BuildWrapper build = new BuildWrapper(versoes, UnicoSistema.getVersao());
        this.carregarVersoesBaixadas(build);
        if (!ListMapUtil.listNullOrEmpty((List)build.getBuildsBaixadas())) {
            String[] partes = ((VersaoWrapper)build.getBuildsBaixadas().get(0)).getDescricao().split("-");
            build.setBuildRecente(partes[1] + "-" + partes[2]);
        } else {
            build.setBuildRecente("");
        }
        return build;
    }

    @RequestMapping(value={"/api/versoes/download"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void downloadFile(@RequestBody VersaoWrapper versao) throws UnicoMensagemUsuarioException {
        String detalhes = "Download vers\u00e3o " + versao.getDescricao();
        if (this.taskService.existeJobVersaoAgendado(detalhes)) {
            throw new UnicoMensagemUsuarioException("WWW382", "J\u00e1 foi agendado um download para essa vers\u00e3o. Por favor aguarde a conclus\u00e3o!");
        }
        this.createTask((Object)versao, detalhes);
    }

    @RequestMapping(value={"/api/versoes/update"}, method={RequestMethod.POST})
    public void atualizarVersao(@RequestBody VersaoWrapper versao) throws UnicoMensagemUsuarioException {
        String nomeArquivoMD5 = versao.getLink().replace(".zip", ".md5");
        File arquivoMD5 = new File(nomeArquivoMD5);
        if (arquivoMD5.exists()) {
            String md5Arquivo;
            String md5 = FileUtil.file2String((File)arquivoMD5);
            if (!md5.equalsIgnoreCase(md5Arquivo = FileUtil.getMd5String((String)versao.getLink()))) {
                throw new UnicoMensagemUsuarioException("WWW386", "O arquivo de atualiza\u00e7\u00e3o esta inconsistente.");
            }
        } else {
            throw new UnicoMensagemUsuarioException("WWW387", "N\u00e3o foi poss\u00edvel localizar o arquivo MD5 do arquivo de atualiza\u00e7\u00e3o.");
        }
        if (this.unzipWebUpdaterJar(versao.getLink())) {
            this.executarComandoUpdateJar(versao);
        }
    }

    @RequestMapping(value={"/api/versoes/delete"}, method={RequestMethod.POST})
    public void excluirVersao(@RequestBody VersaoWrapper versao) throws UnicoMensagemUsuarioException {
        FileUtil.excluirArquivo((File)new File(versao.getLink()));
        String nomeArquivoMD5 = versao.getLink().replace(".zip", ".md5");
        FileUtil.excluirArquivo((File)new File(nomeArquivoMD5));
    }

    private void executarComandoUpdateJar(VersaoWrapper versaoWrapper) {
        try {
            String comando = SystemUtil.isLinux() ? "java -jar web-updater.jar " + versaoWrapper.getLink() + " " + DIRETORIO : "\"" + DIRETORIO + "\\jre\\bin\\javaw.exe\" -jar \"" + DIRETORIO + "\\web-updater.jar\" \"" + versaoWrapper.getLink() + "\" \"" + DIRETORIO + "\" \"";
            this.log.info("COMANDO: {}", (Object)comando);
            if (SystemUtil.isLinux()) {
                ProcessBuilder p = new ProcessBuilder("/bin/sh", "-c", comando);
                p.directory(new File(DIRETORIO));
                p.redirectErrorStream(true);
                p.redirectOutput(new File(DIRETORIO + File.separator + "log_atualizacao.txt"));
                p.inheritIO().start();
            } else {
                new ProcessBuilder(comando).inheritIO().start();
            }
        }
        catch (Throwable ex) {
            this.log.error("N\u00e3o foi poss\u00edvel executar o updater", ex);
        }
    }

    private void carregarVersoesBaixadas(BuildWrapper build) throws UnicoMensagemUsuarioException {
        File diretorio = new File(DIRETORIO + File.separator + "builds_web");
        if (!diretorio.exists() && !diretorio.mkdirs()) {
            throw new UnicoMensagemUsuarioException("WWW384", "N\u00e3o foi poss\u00edvel criar o diret\u00f3rio base.");
        }
        try (Stream<Path> paths = Files.list(Paths.get(DIRETORIO + File.separator + "builds_web", new String[0]));){
            List buildsBaixadas = paths.filter(path -> {
                String descricao = "Download vers\u00e3o " + path.getFileName().toString().substring(0, path.getFileName().toString().lastIndexOf("."));
                boolean jobEmExecucao = this.taskService.existeJobVersaoAgendado(descricao);
                return path.toString().endsWith(".zip") && !jobEmExecucao;
            }).map(arg_0 -> this.getVersao(arg_0)).sorted(Comparator.comparing(VersaoWrapper::getBuild).reversed()).collect(Collectors.toList());
            build.setBuildsBaixadas(buildsBaixadas);
        }
        catch (IOException ex) {
            throw new UnicoMensagemUsuarioException("WWW385", "N\u00e3o foi poss\u00edvel carregar as vers\u00f5es baixadas.");
        }
    }

    private VersaoWrapper getVersao(Path path) {
        String descricao = path.getFileName().toString().substring(0, path.getFileName().toString().lastIndexOf("."));
        String[] split = descricao.split("-");
        long build = NumberUtil.converteVersao((String)split[2]);
        String versao = split[1];
        VersaoWrapper versaoWrapper = new VersaoWrapper();
        versaoWrapper.setVersao(versao);
        versaoWrapper.setBuild(build);
        versaoWrapper.setLink(path.toString());
        versaoWrapper.setDescricao(descricao);
        return versaoWrapper;
    }

    /*
     * Exception decompiling
     */
    private boolean unzipWebUpdaterJar(String zipFilePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 30[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void atualizarPermissoesJar() {
        File file = new File(DIRETORIO + File.separator + "web-updater.jar");
        if (!(!file.exists() || file.setWritable(true) && file.setExecutable(true) && file.setReadable(true))) {
            this.log.error("N\u00e3o foi poss\u00edvel setar as permiss\u00f5es corretas para o 'web-updater.jar'");
        }
    }
}

