/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.webhook;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.b2c.WebHookTipoIntegracao;
import br.intelidata.commons.domain.regranegocio.b2c.WebHookNotificacaoRN;
import br.intelidata.commons.modulo.financeiro.bancoonline.asaas.EventoPagamentoAsaas;
import br.intelidata.commons.modulo.financeiro.bancoonline.asaas.pojo.NotificacaoAsaas;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.service.MDCConfigService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/web-hook/"})
public class WebHookController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TenantService tenantService;
    private final MDCConfigService mdcConfigService;
    private final IConnectionHandler connectionHandler;

    public WebHookController(TenantService tenantService, MDCConfigService mdcConfigService, IConnectionHandler connectionHandler) {
        this.tenantService = tenantService;
        this.mdcConfigService = mdcConfigService;
        this.connectionHandler = connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"notification"})
    public ResponseEntity<Optional<String>> notification(@RequestBody String request, @RequestParam String tenant, @RequestParam Integer integration, @RequestParam(required=false) MultiValueMap<String, String> parameters) {
        Tenant tenantConf = this.tenantService.getTenant(tenant, false);
        if (tenantConf == null) {
            return new ResponseEntity(Optional.of("Conta n\u00e3o definida."), HttpStatus.UNPROCESSABLE_ENTITY);
        }
        this.mdcConfigService.confiMDC(tenantConf.getCodigo());
        this.log.debug("Notifica\u00e7\u00e3o de pagamento do tenant " + tenantConf.getCodigo());
        ContextoHolder.setTenant((String)tenantConf.getCodigo(), (String)this.tenantService.getDatabase(tenantConf.getCodigo()));
        try {
            this.connectionHandler.createConnection(false);
            WebHookTipoIntegracao integracao = (WebHookTipoIntegracao)EnumUtils.getPorId(WebHookTipoIntegracao.class, (Object)integration);
            if (integracao == null) {
                ResponseEntity responseEntity = new ResponseEntity(Optional.of("Integra\u00e7\u00e3o n\u00e3o definida."), HttpStatus.UNPROCESSABLE_ENTITY);
                return responseEntity;
            }
            if (WebHookNotificacaoRN.getInstance().possuiIntegracao() || integracao.in(new AbstractEnum[]{WebHookTipoIntegracao.BANCO_ONLINE, WebHookTipoIntegracao.PINBANK})) {
                NotificacaoAsaas notificacao;
                if (!JsonUtil.isJSONValid((String)request)) {
                    request = JsonUtil.toJson(parameters);
                }
                if (integracao.equals((Object)WebHookTipoIntegracao.BANCO_ONLINE) && ((notificacao = (NotificacaoAsaas)JsonUtil.fromJson((String)request, NotificacaoAsaas.class)) == null || !notificacao.event.equals((Object)EventoPagamentoAsaas.PAYMENT_RECEIVED))) {
                    ResponseEntity responseEntity = new ResponseEntity(Optional.of("Evento n\u00e3o tratado."), HttpStatus.OK);
                    return responseEntity;
                }
                WebHookNotificacaoRN.getInstance().gravarNotificacao(SessaoUtil.getSessao(), integracao, request);
            }
        }
        catch (UnicoMensagemUsuarioException ex) {
            this.connectionHandler.rollback();
            this.log.error("N\u00e3o foi poss\u00edvel gravar a notifica\u00e7\u00e3o de pagamento: " + request, (Throwable)ex);
        }
        finally {
            if (this.connectionHandler.isConnected()) {
                this.connectionHandler.releaseConnection();
            }
        }
        return ResponseEntity.ok(Optional.empty());
    }
}

