/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.webhook;

import br.intelidata.api.b2c.payment.PaymentInterface;
import br.intelidata.api.b2c.payment.service.PaymentService;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.bancoonline.IntegracaoBancoOnline;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.b2c.WebHookNotificacao;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.b2c.WebHookTipoIntegracao;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.regranegocio.b2c.WebHookNotificacaoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHookScheduler
extends AbstractPrepareScheduler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PaymentService<?> paymentService = (PaymentService)BeanUtil.getBean((String)"paymentService");
    private final FuncionalidadeService funcionalidadeService = (FuncionalidadeService)BeanUtil.getBean((String)"funcionalidadeService");

    public WebHookScheduler() {
        super("Monitor de Webhooks", Cron.every15minutes(), TipoJob.WEBHOOK);
    }

    public void execute() throws Exception {
        Sessao sessao = SessaoUtil.getSessaoSistema();
        try {
            List webHookNotificacaos;
            if (this.funcionalidadeService.isAtiva(Funcionalidade.BANCO_ONLINE) && !(webHookNotificacaos = WebHookNotificacaoRN.getInstance().buscarPendentes(new Integer[]{WebHookTipoIntegracao.BANCO_ONLINE.getId()})).isEmpty()) {
                List contas = ContaCorrenteRN.getInstance().buscarContas(sessao, true);
                for (ContaCorrente contaCorrente : contas) {
                    new IntegracaoBancoOnline(sessao, contaCorrente).processarNotificacao(webHookNotificacaos);
                }
            }
            if (!WebHookNotificacaoRN.getInstance().possuiIntegracao()) {
                return;
            }
            PaymentInterface payment = this.paymentService.getPayment();
            List webHookNotificacaos2 = WebHookNotificacaoRN.getInstance().buscarPendentes(new Integer[]{WebHookTipoIntegracao.MERCADO_PAGO.getId(), WebHookTipoIntegracao.PAG_SEGURO.getId()});
            for (WebHookNotificacao webHookNotificacao : webHookNotificacaos2) {
                payment.processarNotificacao(sessao, webHookNotificacao);
            }
        }
        catch (Throwable e) {
            this.log.error("Ocorreu um erro ao processar as notifica\u00e7\u00f5es", e);
        }
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return true;
    }
}

