/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.util;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.UnicoByteArrayDataSource;
import br.intelidata.commons.core.util.Util;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    public static final String DIRETORIO_BACKUP = SystemUtil.getDiretorioAplicacao() + File.separator + "backup";
    private static final String CARACTERES_VALIDOS_CODIGO_NOTA = "0123456789";

    public static byte[] file2ByteArrayNormalizerXML(File file) {
        String arquivo = FileUtil.file2String((File)file);
        String caracteres = arquivo.substring(0, arquivo.indexOf(">") + 1);
        String caracteresNormalizados = StringUtil.normalizar((String)caracteres);
        String xmlMontado = caracteresNormalizados + arquivo.substring(arquivo.indexOf(">") + 1);
        byte[] xml = xmlMontado.getBytes(StandardCharsets.UTF_8);
        return xml;
    }

    public static void excluirArquivo(File arquivo) {
        if (arquivo.exists() && !arquivo.delete()) {
            throw new UnicoException("COM236557", "Erro ao excluir arquivo " + arquivo);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String file2String(File file) {
        try (Stream<String> lines = Files.lines(file.toPath());){
            String string = lines.collect(Collectors.joining());
            return string;
        }
        catch (IOException e) {
            throw new UnicoException("COM236558", (Throwable)e);
        }
    }

    public static byte[] string2ByteArrayNormalizerXML(String arquivo) {
        String caracteres = arquivo.substring(0, arquivo.indexOf(">") + 1);
        String caracteresNormalizados = StringUtil.normalizar((String)caracteres);
        String xmlMontado = caracteresNormalizados + arquivo.substring(arquivo.indexOf(">") + 1);
        byte[] xml = xmlMontado.getBytes(StandardCharsets.UTF_8);
        return xml;
    }

    public static String byteArrayToString(byte[] byteArray) {
        String valor = new String(byteArray, StandardCharsets.UTF_8);
        return valor;
    }

    public static byte[] file2ByteArray(File file) throws UnicoMensagemUsuarioException {
        return FileUtil.file2ByteArray((File)file, (boolean)true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] file2ByteArray(File file, boolean validaExistenciaArquivo) throws UnicoMensagemUsuarioException {
        if (file == null) {
            return null;
        }
        try (RandomAccessFile f = new RandomAccessFile(file.getPath(), "r");){
            byte[] b = new byte[(int)f.length()];
            if (f.read(b) == -1) {
                throw new UnicoException("COM236559", "Falhou ao ler o arquivo");
            }
            byte[] byArray = b;
            return byArray;
        }
        catch (IOException e) {
            if (!validaExistenciaArquivo) return null;
            throw new UnicoMensagemUsuarioException("COM236560", "Arquivo n\u00e3o encontrado: " + file.getPath());
        }
    }

    public static void comprimirArquivoEmDisco(ZipOutputStream zipOutputStream, File arquivo, String nomeArquivo) {
        byte[] buffer = new byte[1024];
        try (FileInputStream fileInputStream = new FileInputStream(arquivo);){
            int bytes_read;
            ZipEntry entry = new ZipEntry(nomeArquivo);
            zipOutputStream.putNextEntry(entry);
            while ((bytes_read = fileInputStream.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, bytes_read);
            }
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            throw new UnicoException("COM236561", (Throwable)e);
        }
    }

    public static void comprimirArquivoEmMemoria(ZipOutputStream zipOut, byte[] arquivo, String nomeArquivo) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(arquivo);){
            ZipEntry zipEntry = new ZipEntry(nomeArquivo);
            zipOut.putNextEntry(zipEntry);
            IOUtils.copy((InputStream)is, (OutputStream)zipOut);
            zipOut.flush();
            zipOut.closeEntry();
        }
        catch (IOException e) {
            throw new UnicoException("WWW300", (Throwable)e);
        }
    }

    public static boolean verificaNumeroCampo(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if ("0123456789".contains(string.substring(i, i + 1))) continue;
            return false;
        }
        return true;
    }

    public static byte[] montaZipFile(DataSource[] dataSources) throws UnicoMensagemUsuarioException {
        byte[] arquivo;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try (ZipOutputStream zipOut = new ZipOutputStream(bos);){
                for (DataSource source : dataSources) {
                    ZipEntry zipEntry = new ZipEntry(source.getName());
                    zipOut.putNextEntry(zipEntry);
                    IOUtils.copy((InputStream)source.getInputStream(), (OutputStream)zipOut);
                    zipOut.flush();
                    zipOut.closeEntry();
                }
                zipOut.closeEntry();
            }
            arquivo = bos.toByteArray();
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW345", e.getMessage());
        }
        return arquivo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<DataSource> extrairArquivos(InputStream is) throws UnicoMensagemUsuarioException {
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry zipEntry;
            ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
            while ((zipEntry = zis.getNextEntry()) != null) {
                byte[] buffer = new byte[2048];
                ByteArrayOutputStream bos = new ByteArrayOutputStream(buffer.length);
                Throwable throwable = null;
                try {
                    int size;
                    while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                        bos.write(buffer, 0, size);
                    }
                    String name = zipEntry.getName();
                    String type = URLConnection.guessContentTypeFromName(name);
                    dataSources.add((DataSource)new UnicoByteArrayDataSource(bos.toByteArray(), name, type));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bos == null) continue;
                    if (throwable != null) {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bos.close();
                }
            }
            is.close();
            ArrayList<DataSource> arrayList = dataSources;
            return arrayList;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW344", e.getMessage());
        }
    }

    public static File montaZipFile(List<File> arquivos, String prefixo) throws UnicoMensagemUsuarioException {
        try {
            File scratchFile = File.createTempFile(prefixo, ".zip");
            scratchFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(scratchFile);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (File file : arquivos) {
                    FileUtil.comprimirArquivoEmDisco((ZipOutputStream)zipOut, (File)file, (String)file.getName());
                }
                zipOut.closeEntry();
            }
            return scratchFile;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW343", e.getMessage());
        }
    }

    public static File montaZipFilePorRemessa(Map<String, Remessa> remessas, String tipo) throws UnicoMensagemUsuarioException {
        try {
            File scratchFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".zip");
            scratchFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(scratchFile);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (Map.Entry<String, Remessa> entry : remessas.entrySet()) {
                    FileUtil.comprimirArquivoEmDisco((ZipOutputStream)zipOut, (File)((File)entry.getValue().getMalote().getMapArquivos().get(tipo)), (String)entry.getKey());
                }
                zipOut.closeEntry();
            }
            return scratchFile;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW259", e.getMessage());
        }
    }

    public static File montaZipFilePorByte(Map<String, byte[]> arquivos, String nomeArquivo) throws UnicoMensagemUsuarioException {
        try {
            File scratchFile = File.createTempFile(nomeArquivo, ".zip");
            scratchFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(scratchFile);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (Map.Entry<String, byte[]> entry : arquivos.entrySet()) {
                    FileUtil.comprimirArquivoEmMemoria((ZipOutputStream)zipOut, (byte[])entry.getValue(), (String)entry.getKey());
                }
                zipOut.closeEntry();
            }
            return scratchFile;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW260", e.getMessage());
        }
    }

    private void compressGZIP(File input, File output) throws IOException {
        try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(output));
             FileInputStream in = new FileInputStream(input);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void decompressGzipFile(File fileIn, File fileOut) throws UnicoMensagemUsuarioException {
        try (FileInputStream fis = new FileInputStream(fileIn);
             GZIPInputStream gis = new GZIPInputStream(fis);
             FileOutputStream fos = new FileOutputStream(fileOut);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = gis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW353", e.getMessage());
        }
    }

    public static boolean isGZipped(File f) {
        int magic;
        try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
            magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
        }
        catch (Throwable e) {
            return false;
        }
        return magic == 35615;
    }

    public static byte[] concatPDFs(List<byte[]> pdfs, boolean paginate) throws UnicoMensagemUsuarioException {
        Document document = new Document();
        FileOutputStream outputStream = null;
        try {
            byte[] bytes;
            File fileTemp = File.createTempFile("danfe-unidas", ".pdf");
            outputStream = new FileOutputStream(fileTemp);
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            int totalPages = 0;
            for (byte[] pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                totalPages += pdfReader.getNumberOfPages();
            }
            int currentPageNumber = 0;
            int pageOfCurrentReaderPDF = 0;
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            PdfContentByte cb = writer.getDirectContent();
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    ++currentPageNumber;
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                    if (!paginate) continue;
                    cb.beginText();
                    cb.setFontAndSize(bf, 9.0f);
                    cb.showTextAligned(1, "" + currentPageNumber + " of " + totalPages, 520.0f, 5.0f, 0.0f);
                    cb.endText();
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            ((OutputStream)outputStream).close();
            try (FileInputStream inputStream = new FileInputStream(fileTemp);){
                bytes = IOUtils.toByteArray((InputStream)inputStream);
            }
            if (!fileTemp.delete()) {
                fileTemp.deleteOnExit();
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (DocumentException | IOException e) {
            throw new UnicoMensagemUsuarioException("COM236562", "Erro ao unir os arquivos pdf!");
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException ioe) {
                LOG.error("Erro no m\u00e9todo concatPDFs", (Throwable)ioe);
            }
        }
    }

    public static String getMd5String(String arquivo) {
        return FileUtil.getMd5String((File)new File(arquivo));
    }

    public static String getMd5String(File arquivo) {
        BigInteger bigInteger = new BigInteger(1, FileUtil.getMd5Arquivo((File)arquivo));
        return StringUtil.zeroEsquerda((String)bigInteger.toString(16), (int)32);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getMd5Arquivo(File arquivo) {
        try (FileInputStream is = new FileInputStream(arquivo);){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new UnicoException(null, (Throwable)e);
        }
    }

    public static String getMd5(byte[] binario) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(binario);
            BigInteger bigInteger = new BigInteger(1, digest.digest());
            return StringUtil.zeroEsquerda((String)bigInteger.toString(16), (int)32);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnicoException(null, (Throwable)e);
        }
    }

    public static void salvarStringEmArquivo(String conteudo, String nomeArquivo) throws UnicoMensagemUsuarioException {
        try (FileWriterWithEncoding fw = new FileWriterWithEncoding(nomeArquivo, StandardCharsets.UTF_8);){
            fw.write(conteudo);
            fw.flush();
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("COM236563", "Erro ao salvar arquivo em disco");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File validarArquivoBackup(MultipartFile multipartFile) throws UnicoMensagemUsuarioException {
        try (DataInputStream data = new DataInputStream(new BufferedInputStream(multipartFile.getInputStream()));){
            int bt = data.readInt();
            if (bt != 1347093252) {
                throw new UnicoMensagemUsuarioException("WWW394", "Arquivo inv\u00e1lido.");
            }
            File backupZip = File.createTempFile("backup", ".zip");
            multipartFile.transferTo(backupZip);
            File backupTemp = null;
            try (ZipFile zipFile = new ZipFile(backupZip);){
                Enumeration<? extends ZipEntry> enu = zipFile.entries();
                while (enu.hasMoreElements()) {
                    ZipEntry zipEntry = enu.nextElement();
                    String name = zipEntry.getName();
                    if (name == null || !name.endsWith(".backup")) continue;
                    try (InputStream is = zipFile.getInputStream(zipEntry);){
                        backupTemp = File.createTempFile("backup", ".backup");
                        Files.copy(is, backupTemp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        break;
                    }
                    catch (Throwable ex) {
                        throw new UnicoMensagemUsuarioException("WWW395", "N\u00e3o foi poss\u00edvel extrair o arquivo.", ex);
                    }
                }
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("WWW396", "N\u00e3o foi poss\u00edvel extrair o arquivo.", (Throwable)e);
            }
            FileUtils.forceDelete((File)backupZip);
            if (backupTemp == null) throw new UnicoMensagemUsuarioException("WWW408", "Arquivo inv\u00e1lido, por favor verifique o conte\u00fado do arquivo compactado.");
            if (backupTemp.length() == 0L) {
                throw new UnicoMensagemUsuarioException("WWW408", "Arquivo inv\u00e1lido, por favor verifique o conte\u00fado do arquivo compactado.");
            }
            File file = backupTemp;
            return file;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW397", "Arquivo inv\u00e1lido.", (Throwable)e);
        }
    }

    public static void validarImagem(String extensao, MultipartFile multipartFile) throws UnicoMensagemUsuarioException {
        try {
            if (StringUtil.stringNullOrEmpty((String)extensao) || ImageIO.read(multipartFile.getInputStream()) == null) {
                throw new UnicoMensagemUsuarioException("WWW411", "Imagem inv\u00e1lida. O tipo da imagem deve ser jpg ou png");
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new UnicoMensagemUsuarioException("WWW412", "Imagem inv\u00e1lida. O tipo da imagem deve ser jpg ou png.");
        }
    }

    public static Integer getPercentualDisponivelDisco() {
        File dir = Paths.get(Util.getDiretorioUsuario(), new String[0]).toFile();
        return NumberUtil.percentual((BigDecimal)new BigDecimal(dir.getUsableSpace()), (BigDecimal)new BigDecimal(dir.getTotalSpace())).intValue();
    }

    public static List<Path> buscarListaBackup(String diretorio, String tenant) throws IOException {
        try (Stream<Path> files = Files.list(Paths.get(diretorio, new String[0])).filter(p -> {
            String nomeArquivo = p.getFileName().toString();
            return nomeArquivo.endsWith("backup") && nomeArquivo.startsWith(tenant + "_") || nomeArquivo.equalsIgnoreCase(tenant + ".backup");
        });){
            List<Path> list = files.collect(Collectors.toList());
            return list;
        }
    }

    public static List<Path> buscarTodosArquivos(String diretorio) throws IOException {
        try (Stream<Path> files = Files.list(Paths.get(diretorio, new String[0]));){
            List<Path> list = files.collect(Collectors.toList());
            return list;
        }
    }

    public static List<Path> buscarListaLog(String diretorio) throws IOException {
        try (Stream<Path> files = Files.list(Paths.get(diretorio, new String[0])).filter(p -> {
            String nomeArquivo = p.getFileName().toString();
            return nomeArquivo.startsWith("uniplusweb") && nomeArquivo.endsWith("log");
        });){
            List<Path> list = files.collect(Collectors.toList());
            return list;
        }
    }

    public static boolean isExtensaoImagem(String nomeArquivo) {
        return FilenameUtils.isExtension((String)nomeArquivo, (String[])new String[]{"jpg", "jpeg", "png", "gif", "bmp"});
    }

    public static File baixarImagem(String imageUrl) throws UnicoMensagemUsuarioException {
        try {
            URL url = new URL(imageUrl);
            InputStream inputStream = url.openStream();
            File tempFile = File.createTempFile("imagem_baixada", ".jpg");
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            inputStream.close();
            return tempFile;
        }
        catch (Exception e) {
            throw new UnicoMensagemUsuarioException("WWW743", "Ocorreu um problema ao baixar o arquivo", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> convertToLines(MultipartFile file) throws UnicoMensagemUsuarioException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            throw new UnicoMensagemUsuarioException("WWW744", "Erro ao processar o arquivo: " + file.getOriginalFilename(), (Throwable)e);
        }
    }

    public static Double toGB(Long number) {
        return Math.floor((double)number.longValue() / 1.073741824E9 * 100.0) / 100.0;
    }

    public static Double toMB(Long number) {
        return Math.floor((double)number.longValue() / 1048576.0 * 100.0) / 100.0;
    }
}

