/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.util;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.GridConfigurada;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.regranegocio.PautaPreco;
import br.intelidata.commons.domain.regranegocio.PautaPrecoRN;
import br.intelidata.commons.domain.regranegocio.ProdutoSimilarCommonRN;
import br.intelidata.uniplusweb.core.spring.JSR310DateSerializer;
import br.intelidata.uniplusweb.core.spring.JSR310DateTimeSerializer;
import br.intelidata.uniplusweb.core.spring.JSR310LocalDateDeserializer;
import br.intelidata.uniplusweb.core.spring.JSR310LocalDateTimeDeserializer;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ObjetoAuxiliar;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TabelaConfigurada;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ProdutoAuxiliarPromptWapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtil.class);

    public static boolean isJSONValid(String jsonInString) {
        try {
            JsonUtil.getObjectMapper().readTree(jsonInString);
            return true;
        }
        catch (JsonProcessingException e) {
            return false;
        }
    }

    public static String toJson(Object obj) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JavaTimeModule module = new JavaTimeModule();
            module.addSerializer(LocalDate.class, (JsonSerializer)JSR310DateSerializer.INSTANCE);
            module.addSerializer(LocalDateTime.class, (JsonSerializer)JSR310DateTimeSerializer.INSTANCE);
            mapper.registerModule((Module)module);
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel converter o objeto", e);
        }
    }

    public static <T> T fromJson(String json, Class<T> classz) {
        try {
            ObjectMapper mapper = JsonUtil.getObjectMapper();
            return (T)mapper.readValue(json, classz);
        }
        catch (Exception e) {
            LOG.error("Erro no m\u00e9todo fromJson", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> fromJsonList(String json, Class<T> classz) {
        ObjectMapper mapper = JsonUtil.getObjectMapper();
        try {
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, classz));
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JavaTimeModule module = new JavaTimeModule();
        module.addDeserializer(LocalDate.class, (JsonDeserializer)JSR310LocalDateDeserializer.INSTANCE);
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)JSR310LocalDateTimeDeserializer.INSTANCE);
        mapper.registerModule((Module)module);
        return mapper;
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.findAndRegisterModules();
            return (T)mapper.readValue(json, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toJson(List lista, String ... campos) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        int numeroDeLinhas = 0;
        int numeroTotalColunas = campos.length;
        for (Object obj : lista) {
            if (numeroDeLinhas > 0) {
                json.append(',');
            }
            json.append('{');
            for (int i = 0; i < numeroTotalColunas; ++i) {
                String nomeDaColuna = campos[i];
                json.append('\"');
                json.append(nomeDaColuna);
                json.append("\":");
                Object objValor = BeanUtil.get(obj, (String)nomeDaColuna, (Object[])new Object[0]);
                json.append(JsonUtil.normalizaValor((Object)objValor));
                if (i >= numeroTotalColunas - 1) continue;
                json.append(',');
            }
            ++numeroDeLinhas;
            json.append('}');
        }
        json.append(']');
        return json.toString();
    }

    public static String toJson(List<Object[]> lista, List<ColunaSQL> colunasSQL) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        int numeroDeLinhas = 0;
        int numeroTotalColunas = colunasSQL.size();
        for (Object[] linha : lista) {
            if (numeroDeLinhas > 0) {
                json.append(',');
            }
            json.append('{');
            for (int i = 0; i < numeroTotalColunas; ++i) {
                String nomeDaColuna = colunasSQL.get(i).getAlias();
                json.append('\"');
                json.append(nomeDaColuna);
                json.append("\":");
                json.append(JsonUtil.normalizaValor((Object)(linha.length >= i ? linha[i] : "")));
                if (i >= numeroTotalColunas - 1) continue;
                json.append(',');
            }
            ++numeroDeLinhas;
            json.append('}');
        }
        json.append(']');
        return json.toString();
    }

    public static String getJsonh(List<Object[]> lista, List<ColunaSQL> colunasSQL, int numeroTotalRegistros, int tamanhoPagina, Map<String, BigDecimal> valoresTotalizados, Extras extras, List<TabelaConfigurada> tabelas, List<GridConfigurada> gridsConfiguradas, ObjetoAuxiliar objetoAuxiliar) {
        StringBuilder jsonh = new StringBuilder();
        String totais = null;
        if (valoresTotalizados != null) {
            totais = new Gson().toJson(valoresTotalizados);
        }
        jsonh.append("{\"totalRegistro\":").append(numeroTotalRegistros).append(",").append("\"totais\":").append(totais).append(",").append("\"extras\": ").append(JsonUtil.toJson((Object)extras)).append(",").append("\"tabelasRelatorio\": ").append(JsonUtil.toJson(tabelas)).append(",").append("\"visoes\": ").append(JsonUtil.toJson(gridsConfiguradas)).append(",").append("\"objetoAuxiliar\": ").append(JsonUtil.toJson((Object)objetoAuxiliar)).append(",").append("\"produtoAuxiliar\": ").append(JsonUtil.toJson((Object)JsonUtil.produtoAuxiliar())).append(",");
        int lin = 0;
        int numeroColunas = colunasSQL.size();
        jsonh.append("\"dados\": [");
        for (Object[] linha : lista) {
            if (lin > tamanhoPagina) continue;
            if (lin > 0) {
                jsonh.append(',');
            }
            jsonh.append('{');
            for (int i = 0; i < numeroColunas; ++i) {
                String coluna = colunasSQL.get(i).getAlias();
                jsonh.append('\"');
                jsonh.append(coluna);
                jsonh.append("\":");
                jsonh.append(JsonUtil.normalizaValor((Object)linha[i]));
                if (i >= numeroColunas - 1) continue;
                jsonh.append(',');
            }
            ++lin;
            jsonh.append('}');
        }
        jsonh.append("]}");
        return jsonh.toString();
    }

    private static String normalizaValor(Object valor) {
        if (valor == null) {
            return "\"\"";
        }
        if (valor instanceof Timestamp) {
            return "\"" + JsonUtil.temporalNormalized((Instant)((Timestamp)valor).toInstant()) + "\"";
        }
        if (valor instanceof Time) {
            return "\"" + JsonUtil.temporalNormalized((Instant)Instant.ofEpochMilli(((Time)valor).getTime())) + "\"";
        }
        return JsonUtil.escapeQuote((String)valor.toString());
    }

    private static String temporalNormalized(Instant instant) {
        LocalDateTime dateTime = DataHoraFactory.ofInstant((Instant)instant);
        return DateUtil.JSR310DateTimeSerializer((TemporalAccessor)dateTime);
    }

    public static String escapeQuote(String string) {
        return "\"" + StringEscapeUtils.escapeJson((String)string) + "\"";
    }

    public static String enumConstantsToJson(Class clazz, boolean constante) {
        return "[".concat(Arrays.stream(clazz.getEnumConstants()).filter(object -> object instanceof AbstractEnum).map(object -> {
            AbstractEnum enumClazz = (AbstractEnum)object;
            return "{\"id\":" + JsonUtil.escapeQuote((String)(constante ? ((Enum)object).name() : enumClazz.getId().toString())) + ",\"display\":" + JsonUtil.escapeQuote((String)enumClazz.getDescricao()) + "}";
        }).collect(Collectors.joining(","))).concat("]");
    }

    public static ProdutoAuxiliarPromptWapper produtoAuxiliar() {
        boolean isPautasAtivas = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO) ? PautaPrecoRN.getInstance().isPautaPrecoAtiva(SessaoUtil.getSessao()) : PautaPreco.getInstance().isPautasPrecoAtivas(SessaoUtil.getSessao().getFilial());
        boolean existeSimilar = ProdutoSimilarCommonRN.getInstance().existeProdutoSimilar() && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRODUTO_SIMILAR);
        ProdutoAuxiliarPromptWapper aux = new ProdutoAuxiliarPromptWapper();
        aux.setPautaPreco(isPautasAtivas);
        aux.setProdutoSimilar(existeSimilar);
        return aux;
    }
}

