/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.security.oauth2;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.regranegocio.b2c.SessaoWebRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.security.oauth2.CustomInvalidTokenException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.util.JsonParser;
import org.springframework.security.oauth2.common.util.JsonParserFactory;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;

public class CustomJwtTokenStore
extends JwtTokenStore {
    private static final List<String> NO_SESSION_SCOPE = Collections.singletonList("shop");
    private JsonParser objectMapper = JsonParserFactory.create();
    private IConnectionHandler connectionHandler;

    public CustomJwtTokenStore(JwtAccessTokenConverter jwtTokenEnhancer, IConnectionHandler connectionHandler) {
        super(jwtTokenEnhancer);
        this.connectionHandler = connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        Map info = token.getAdditionalInformation();
        String jti = info.get("jti").toString();
        if (authentication.getUserAuthentication() != null && authentication.getUserAuthentication().getPrincipal() instanceof User) {
            User user = (User)authentication.getUserAuthentication().getPrincipal();
            Long idUsuario = Long.valueOf(user.getUsername());
            String userAgent = "";
            boolean mobile = false;
            if (authentication.getUserAuthentication().getDetails() != null) {
                userAgent = (String)((Map)authentication.getUserAuthentication().getDetails()).get("userAgent");
                mobile = Boolean.parseBoolean((String)((Map)authentication.getUserAuthentication().getDetails()).get("mobile"));
            }
            if (Util.stringNullOrEmpty((String)userAgent)) {
                userAgent = "Uniplus WEB";
            }
            try {
                this.connectionHandler.createConnection(true);
                this.connectionHandler.beginTransaction();
                SessaoWebRN.getInstance().incluiSessaoWeb(jti, idUsuario, userAgent, mobile);
                this.connectionHandler.commit();
            }
            finally {
                this.connectionHandler.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2AccessToken readAccessToken(String tokenValue) {
        OAuth2AccessToken oAuth2AccessToken = super.readAccessToken(tokenValue);
        Map info = oAuth2AccessToken.getAdditionalInformation();
        if (info.get("tenant") != null && this.isScopeSession(oAuth2AccessToken)) {
            String tenant = info.get("tenant").toString();
            ContextoHolder.setTenant((String)tenant);
            String jti = info.get("jti").toString();
            try {
                this.connectionHandler.createConnection(true);
                Sessao sessao = SessaoWebRN.getInstance().buscaSessao(jti);
                if (sessao == null) {
                    throw new CustomInvalidTokenException("Token n\u00e3o encontrado");
                }
                ContextoHolder.setTenant((String)tenant);
                ContextoHolder.setSessao((Sessao)sessao);
                ContextoHolder.setJti((String)jti);
            }
            finally {
                this.connectionHandler.releaseConnection();
            }
        }
        return oAuth2AccessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2RefreshToken readRefreshToken(String tokenValue) {
        Jwt jwt;
        String claimsStr;
        Map claims;
        if (!StringUtil.stringNullOrEmpty((String)tokenValue) && (claims = this.objectMapper.parseMap(claimsStr = (jwt = JwtHelper.decode((String)tokenValue)).getClaims())).get("tenant") != null) {
            String jti = claims.get("ati").toString();
            String tenant = claims.get("tenant").toString();
            ContextoHolder.setTenant((String)tenant);
            try {
                this.connectionHandler.createConnection(true);
                this.connectionHandler.beginTransaction();
                SessaoWebRN.getInstance().apagaSessaoWeb(jti);
                this.connectionHandler.commit();
            }
            finally {
                this.connectionHandler.releaseConnection();
            }
        }
        return super.readRefreshToken(tokenValue);
    }

    private boolean isScopeSession(OAuth2AccessToken oAuth2AccessToken) {
        return NO_SESSION_SCOPE.stream().noneMatch(oAuth2AccessToken.getScope()::contains);
    }
}

