/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.wrapper.UsuarioSiteResponse;
import java.util.HashMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import unico.pojo.Licenca;

@Service
public class UsuarioRemotoService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionOAuth2Service connectionOAuth2Service;

    @Autowired
    public UsuarioRemotoService(ConnectionOAuth2Service connectionOAuth2Service) {
        this.connectionOAuth2Service = connectionOAuth2Service;
    }

    public Usuario buscarUsuarioRemoto(String email, String passwd) {
        Usuario usuario;
        Licenca licencaPrincipal = LicencaManager.getInstance().getLicencaPrincipal();
        if (licencaPrincipal == null) {
            return null;
        }
        HashMap<String, String> me = new HashMap<String, String>();
        me.put("email", email);
        me.put("password", passwd);
        me.put("tenant", ContextoHolder.getTenant());
        me.put("cnpjClienteFinal", licencaPrincipal.getCnpj());
        JSONObject elem = JSONUtil.getJSONObject(me);
        try {
            ResponseEntity response = this.connectionOAuth2Service.post("/usuario/login-web", elem, UsuarioSiteResponse.class);
            UsuarioSiteResponse usuarioSite = (UsuarioSiteResponse)response.getBody();
            usuario = usuarioSite != null ? UsuarioRN.getInstance().buscarCadastrarUsuarioRemotoWeb(email, passwd, usuarioSite.getNome(), usuarioSite.getTipoAcesso()) : null;
        }
        catch (Exception ex) {
            this.log.error("N\u00e3o foi poss\u00edvel obter o usu\u00e1rio no portal canal", (Throwable)ex);
            usuario = null;
        }
        return usuario;
    }
}

