/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service.socket;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.modulo.cadastros.regranegocio.NotificacaoUsuarioRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.base.NotificationInterface;
import br.intelidata.uniplusweb.service.socket.Notification;
import br.intelidata.uniplusweb.service.socket.NotificationReport;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import com.google.gson.Gson;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class NotificationService
implements NotificationInterface {
    private static final String DESTINATION = "/topic/tenant_";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SimpMessagingTemplate messagingTemplate;

    public void notifyTenantNow(NotificationType notificationType, String message) {
        try {
            Notification notification = new Notification(notificationType, "*", (Object)message);
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + ContextoHolder.getTenant()), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void simpleNotifyTenantAll(TipoNotificacaoSimples type, String message) {
        try {
            Notification notification = new Notification(NotificationType.SIMPLE_NOTIFICATION, "*", (Object)message);
            notification.setNotificacaoSimples(type);
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + ContextoHolder.getTenant()), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void simpleNotifyUserTenantNow(String tenant, Long idUsuario, TipoNotificacaoSimples type, String message) {
        try {
            Notification notification = new Notification(NotificationType.SIMPLE_NOTIFICATION, tenant.concat(".").concat(idUsuario.toString()), (Object)message);
            notification.setNotificacaoSimples(type);
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + tenant), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyUser(Long idUsuario, String message, TipoNotificacaoSimples tipoNotificacao) {
        this.notifyUser(idUsuario, message, tipoNotificacao, NotificationType.NOTIFICATION);
    }

    public void notifyUser(Long idUsuario, String message, TipoNotificacaoSimples tipoNotificacao, NotificationType notificationType) {
        this.notifyUser(idUsuario, message, tipoNotificacao, notificationType, 5000);
    }

    public void notifyUser(Long idUsuario, String message, TipoNotificacaoSimples tipoNotificacao, NotificationType notificationType, int timeout) {
        try {
            String usuarioNotificacao = ContextoHolder.getTenant() + "." + idUsuario;
            Long idNotificacao = NotificacaoUsuarioRN.getInstance().gravaNotificacaoUsuario(SessaoUtil.getSessao(), idUsuario, usuarioNotificacao, message, tipoNotificacao);
            Notification notification = new Notification(notificationType, usuarioNotificacao, (Object)message, idNotificacao);
            notification.setNotificacaoSimples(tipoNotificacao);
            notification.setTimeout(timeout);
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + ContextoHolder.getTenant()), (Object)new Gson().toJson((Object)notification));
        }
        catch (UnicoMensagemUsuarioException | MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", ex);
        }
    }

    public void notifyUser(String message, TipoNotificacaoSimples tipoNotificacao) {
        this.notifyUser(SessaoUtil.getSessao().getIdUsuario(), message, tipoNotificacao);
    }

    public void notityUsersAdministrator(TipoNotificacaoSimples notificationType, String tenant, String message) {
        List usuarios = UsuarioRN.getInstance().buscarAdministradores();
        usuarios.forEach(usuario -> {
            try {
                String userNotification = tenant.concat(".").concat(usuario.getId().toString());
                Long idNotificacao = NotificacaoUsuarioRN.getInstance().gravaNotificacaoUsuario(SessaoUtil.getSessao(), usuario.getId(), userNotification, message, notificationType);
                Notification notification = new Notification(NotificationType.NOTIFICATION, userNotification, (Object)message, idNotificacao);
                notification.setNotificacaoSimples(notificationType);
                this.messagingTemplate.convertAndSend((Object)(DESTINATION + tenant), (Object)new Gson().toJson((Object)notification));
            }
            catch (UnicoMensagemUsuarioException | MessagingException ex) {
                this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", ex);
            }
        });
    }

    public void notifyTenantNow(NotificationType notificationType, Object message) {
        try {
            Notification notification = new Notification(notificationType, "*", (Object)new Gson().toJson(message));
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + ContextoHolder.getTenant()), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyUserNow(String tenant, Long idUsuario, NotificationType notificationType, Object message) {
        try {
            String user = tenant.concat(".").concat(idUsuario.toString());
            Notification notification = new Notification(notificationType, user, (Object)new Gson().toJson(message));
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + ContextoHolder.getTenant()), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyTokenNow(String tenant, String jti, NotificationType notificationType, Object message) {
        try {
            Notification notification = new Notification(notificationType, tenant + "." + jti, (Object)new Gson().toJson(message));
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + ContextoHolder.getTenant()), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyUserNow(NotificationType notificationType, Object message) {
        try {
            Notification notification = new Notification(notificationType, ContextoHolder.getTenant() + "." + SessaoUtil.getSessao().getIdUsuario(), (Object)new Gson().toJson(message));
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + ContextoHolder.getTenant()), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyNfeNow(String mensagem) {
        this.notifyUserTenantNfeNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), mensagem);
    }

    public void notifyConciliacaoNow(String mensagem) {
        String tenant = ContextoHolder.getTenant();
        try {
            Notification notification = new Notification(NotificationType.CONCILIACAO_FINANCEIRA, tenant.concat(".").concat(SessaoUtil.getSessao().getIdUsuario().toString()), (Object)mensagem);
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + tenant), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyUserTenantNfeNow(String tenant, Long idUsuario, String mensagem) {
        try {
            Notification notification = new Notification(NotificationType.NFE, tenant.concat(".").concat(idUsuario.toString()), (Object)mensagem);
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + tenant), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyMdfeNow(String mensagem) {
        this.notifyUserTenantMdfeNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), mensagem);
    }

    public void notifyUserTenantMdfeNow(String tenant, Long idUsuario, String mensagem) {
        try {
            Notification notification = new Notification(NotificationType.MDFE, tenant.concat(".").concat(idUsuario.toString()), (Object)mensagem);
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + tenant), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyGnreNow(String mensagem) {
        this.notifyUserTenantGnreNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), mensagem);
    }

    public void notifyUserTenantGnreNow(String tenant, Long idUsuario, String mensagem) {
        try {
            Notification notification = new Notification(NotificationType.GNRE, tenant.concat(".").concat(idUsuario.toString()), (Object)mensagem);
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + tenant), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyCteNow(String msg) {
        this.notifyUserTenantCteNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), msg);
    }

    public void notifyUserTenantCteNow(String tenant, Long idUsuario, String mensagem) {
        try {
            Notification notification = new Notification(NotificationType.CTE, tenant.concat(".").concat(idUsuario.toString()), (Object)mensagem);
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + tenant), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o", (Throwable)ex);
        }
    }

    public void notifyUserTask(Long idUsuario, String mensagem, TipoNotificacaoSimples tipoNotificacao, Task task, boolean isDownload) {
        try {
            String tenant = ContextoHolder.getTenant();
            String usuarioNotificacao = ContextoHolder.getTenant() + "." + idUsuario;
            NotificationReport notification = new NotificationReport(NotificationType.TASK, usuarioNotificacao, (Object)mensagem, Long.valueOf(0L));
            notification.setNotificacaoSimples(tipoNotificacao);
            notification.setIdTask(task.getId());
            notification.setDownload(isDownload);
            notification.setTitulo(task.getName());
            JobMetadata jobMetadata = JobMetadata.from((String)task.getMetadata());
            notification.setEndPoint((String)jobMetadata.get("report"));
            this.messagingTemplate.convertAndSend((Object)(DESTINATION + tenant), (Object)new Gson().toJson((Object)notification));
        }
        catch (MessagingException ex) {
            this.logger.error("Falhou ao enviar notifica\u00e7\u00e3o de task", (Throwable)ex);
        }
    }
}

