/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.dashboard.base;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.dashboard.ConfiguracaoDashBoard;
import br.intelidata.commons.domain.pojo.enuns.dashboard.TipoFiltroDataDashBoard;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoDashBoardCommonRN;
import br.intelidata.commons.domain.regranegocio.PerfilFilialCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.dashboard.base.FiltroDashboard;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class WidgetController
extends SimpleController {
    protected void gravarConfiguracao(Long idWidget, TipoFiltroDataDashBoard filtro, FiltroDashboard filtroDashboard) throws UnicoMensagemUsuarioException {
        ConfiguracaoDashBoard configuracaoDashBoard;
        if (!NumberUtil.longNullOuZero((Long)idWidget) && (configuracaoDashBoard = (ConfiguracaoDashBoard)ConfiguracaoDashBoardCommonRN.getInstance().buscarPorId(idWidget)) != null) {
            configuracaoDashBoard.setUltimoFiltroPeriodo(filtro);
            if (filtroDashboard != null) {
                configuracaoDashBoard.setFiltro(JSONUtil.objectToJson((Object)filtroDashboard));
            }
            ConfiguracaoDashBoardCommonRN.getInstance().gravar(1, (AbstractPojo)configuracaoDashBoard, SessaoUtil.getSessao());
        }
    }

    protected List<Long> getIdsFiliais(List<Long> idsFiliais) {
        return this.getIdsFiliais(idsFiliais, null);
    }

    protected List<Long> getIdsFiliais(List<Long> idsFiliais, List<Long> idsEmpresas) {
        Sessao sessao = SessaoUtil.getSessao();
        if (ListMapUtil.listNullOrEmpty(idsEmpresas)) {
            idsEmpresas = Collections.singletonList(sessao.getFilial().getIdEmpresa());
        }
        if (Util.listNullOrEmpty(idsFiliais)) {
            boolean filtrarFilialInativa = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getIdFilial(), 2000000);
            if (sessao.getUsuario().isAdministrador()) {
                return FilialRN.getInstance().buscarListaIdsPorIdEmpresas(filtrarFilialInativa, idsEmpresas);
            }
            return PerfilFilialCommonRN.getInstance().buscarListaLongPorIdPerfil(sessao.getUsuario().getIdPerfil(), filtrarFilialInativa);
        }
        return idsFiliais;
    }

    protected List<String> getCodigosFiliais(List<String> codigosFiliais) {
        Sessao sessao = SessaoUtil.getSessao();
        if (ListMapUtil.listNullOrEmpty(codigosFiliais)) {
            if (sessao.getUsuario().isAdministrador()) {
                return FilialRN.getInstance().buscarListaCodigoFiliais();
            }
            return PerfilFilialCommonRN.getInstance().buscarListaCodigoFilialPorIdPerfil(sessao.getUsuario().getIdPerfil());
        }
        return codigosFiliais;
    }

    protected FiltroDashboard carregarFiltroPeriodo(Map<String, String> map) {
        FiltroDashboard filtro = null;
        if (map.containsKey("queryMap")) {
            filtro = (FiltroDashboard)JSONUtil.getObject((String)map.get("queryMap"), FiltroDashboard.class);
        }
        return filtro;
    }
}

