/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.batch.dao;

import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.batch.Metrica;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.dao.AbstractWebDAO;
import br.intelidata.uniplusweb.web.rest.app.batch.dao.SqlWeb;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class MetricaRepository
extends AbstractWebDAO<Metrica> {
    public String getTabela() {
        return "metrica";
    }

    public Metrica save(Metrica metrica) {
        metrica.setCurrentTimeMillis(Long.valueOf(System.currentTimeMillis()));
        SqlWeb sql = new SqlWeb(this.getInsertSQL());
        this.setValoresSql(1, (Sql)sql, this.getAtributos(), (Object)metrica, null, false);
        metrica.setId((Long)sql.executaValorQuery(s -> sql.getLong("id")));
        return metrica;
    }

    public List<Map<String, Object>> top10(String criterio, String tenant) {
        String andTenant = "";
        if (!StringUtil.stringNullOrEmpty((String)tenant)) {
            andTenant = " and tenant = ?";
        }
        String query = "WITH ranked_requests AS (\n    SELECT tenant,\n           endpoint,\n           method,\n           media,\n           p95_duration_ms,\n           p99_duration_ms,\n           total_calls,\n           RANK() OVER (\n               PARTITION BY tenant\n               ORDER BY\n                 CASE WHEN ? = 'media' THEN media END DESC,\n                 CASE WHEN ? = 'p95'   THEN p95_duration_ms END DESC,\n                 CASE WHEN ? = 'p99'   THEN p99_duration_ms END DESC\n           ) AS rank_crit\n    FROM vw_metricas\n)\nSELECT tenant,\n       endpoint,\n       method,\n       media,\n       p95_duration_ms,\n       p99_duration_ms,\n       total_calls\nFROM ranked_requests\nWHERE rank_crit <= 10 " + andTenant + "ORDER BY tenant, rank_crit;";
        ArrayList<Map<String, Object>> metricas = new ArrayList<Map<String, Object>>();
        SqlWeb sql = new SqlWeb(query);
        sql.setString(1, criterio);
        sql.setString(2, criterio);
        sql.setString(3, criterio);
        if (!StringUtil.stringNullOrEmpty((String)andTenant)) {
            sql.setString(4, tenant);
        }
        sql.executaQuery();
        while (sql.next()) {
            HashMap<String, Object> metrica = new HashMap<String, Object>();
            metrica.put("tenant", sql.getString("tenant"));
            metrica.put("endpoint", sql.getString("endpoint"));
            metrica.put("method", sql.getString("method"));
            metrica.put("total_call", sql.getLong("total_calls"));
            metrica.put("media", sql.getBigDecimal("media", 2));
            metrica.put("p95_duration", sql.getBigDecimal("p95_duration_ms", 2));
            metrica.put("p99_duration", sql.getBigDecimal("p99_duration_ms", 2));
            metricas.add(metrica);
        }
        sql.close();
        return metricas;
    }

    public List<Map<String, Object>> metricasGrafico(String tenant, String endpoint, int intervalo, String agrupador) {
        String query = "SELECT\n    endpoint AS endpoint,\n    date_trunc('" + agrupador + "', datahora) AS hora,\n    ROUND(AVG(duracao)::numeric, 2) AS media,\n    PERCENTILE_CONT(0.95) WITHIN GROUP (ORDER BY duracao) AS p95,\n    PERCENTILE_CONT(0.99) WITHIN GROUP (ORDER BY duracao) AS p99,\n    COUNT(*) AS total_calls\nFROM metrica\nWHERE tenant = ?\n  AND datahora >= NOW() - INTERVAL '" + intervalo + " day'\n  AND endpoint = ?\nGROUP BY endpoint, date_trunc('" + agrupador + "', datahora)\nORDER BY hora;";
        ArrayList<Map<String, Object>> metricas = new ArrayList<Map<String, Object>>();
        SqlWeb sql = new SqlWeb(query);
        sql.setString(1, tenant);
        sql.setString(2, endpoint);
        sql.executaQuery();
        while (sql.next()) {
            HashMap<String, Object> metrica = new HashMap<String, Object>();
            metrica.put("hora", Util.formataDataHora((Temporal)sql.getDateTime("hora"), (String)"/MM/dd/yyyy HH:mm:ss"));
            metrica.put("endpoint", sql.getString("endpoint"));
            metrica.put("totalRequests", sql.getLong("total_calls"));
            metrica.put("avg", sql.getBigDecimal("media"));
            metrica.put("p95", sql.getBigDecimal("p95"));
            metrica.put("p99", sql.getBigDecimal("p99"));
            metricas.add(metrica);
        }
        sql.close();
        return metricas;
    }

    public List<Map<String, Object>> mestricas(String tenant, int intervalo) {
        ArrayList<Map<String, Object>> metricas = new ArrayList<Map<String, Object>>();
        SqlWeb sql = new SqlWeb("select * from vw_metricas where last_call >= NOW() - INTERVAL '" + intervalo + " day' and tenant = ?");
        sql.setString(1, tenant);
        sql.executaQuery();
        while (sql.next()) {
            HashMap<String, Object> metrica = new HashMap<String, Object>();
            metrica.put("endpoint", sql.getString("endpoint"));
            metrica.put("method", sql.getString("method"));
            metrica.put("total_call", sql.getLong("total_calls"));
            metrica.put("media", sql.getBigDecimal("media"));
            metrica.put("max_duration", sql.getLong("max_duration_ms"));
            metrica.put("p95_duration", sql.getBigDecimal("p95_duration_ms"));
            metrica.put("p99_duration", sql.getBigDecimal("p99_duration_ms"));
            metrica.put("first_call", sql.getDateTime("first_call"));
            metrica.put("last_call", sql.getDateTime("last_call"));
            metricas.add(metrica);
        }
        sql.close();
        return metricas;
    }
}

