/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.batch.serices;

import br.intelidata.commons.domain.pojo.batch.Metrica;
import br.intelidata.uniplusweb.core.spring.aop.baseUniplusWeb.DBAutoCommitCore;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.dao.MetricaRepository;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class MetricaService {
    private final MetricaRepository metricaRepository;

    public MetricaService(MetricaRepository metricaRepository) {
        this.metricaRepository = metricaRepository;
    }

    @DBAutoCommitCore
    public void gerarMetrica(String tenant, ServletRequest request, ServletResponse response, long tempo) {
        if (!StringUtil.stringNullOrEmpty((String)tenant) && request instanceof HttpServletRequest) {
            HttpServletRequest httpReq = (HttpServletRequest)request;
            HttpServletResponse httpResp = (HttpServletResponse)response;
            if (httpReq.getRequestURI() != null) {
                String method = httpReq.getMethod();
                String baseUri = httpReq.getRequestURI().replaceAll("/\\d+", "");
                int status = httpResp.getStatus();
                boolean achouRotaIgnorada = this.rotasIgnoradas().stream().anyMatch(p -> baseUri.toLowerCase().contains(p.toLowerCase()));
                if (!achouRotaIgnorada) {
                    Metrica metrica = new Metrica();
                    metrica.setTenant(tenant);
                    metrica.setEndPoint(baseUri);
                    metrica.setMethod(method);
                    metrica.setStatusCode(status);
                    metrica.setDuracao(Long.valueOf(tempo));
                    metrica.setDataHora(LocalDateTime.now());
                    this.metricaRepository.save(metrica);
                }
            }
        }
    }

    @DBAutoCommitCore
    public List<Map<String, Object>> buscarMetricas(String tenant, int dias) {
        return this.metricaRepository.mestricas(tenant, dias);
    }

    @DBAutoCommitCore
    public List<Map<String, Object>> top10(String criterio, String tenant) {
        return this.metricaRepository.top10(criterio, tenant);
    }

    @DBAutoCommitCore
    public List<Map<String, Object>> metricasGrafico(String tenant, String endpoint, int intervalo, String agrupador) {
        return this.metricaRepository.metricasGrafico(tenant, endpoint, intervalo, agrupador);
    }

    private List<String> rotasIgnoradas() {
        ArrayList<String> rotas = new ArrayList<String>();
        rotas.add("gerenciador-licencas");
        rotas.add("batch");
        rotas.add("configuracoes");
        return rotas;
    }
}

