/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.calculoimposto;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ItemKit;
import br.intelidata.commons.domain.pojo.ProdutoItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.wrapper.ImpostoWrapper;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.TratamentoDadoImpostoInterface;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemKitController;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ImpostoCalculadoWrapper;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class CalculoImpostoController<POJO extends AbstractPojo, ITEM extends ProdutoItem, IK extends ItemKit<IK>, RN extends AbstractRegraNegocio>
extends ItemKitController<POJO, IK, RN> {
    @Autowired
    private Map<String, TratamentoDadoImpostoInterface> tratamentoDadoImpostoMap;
    private CalculoImpostoService<ITEM> calculoImpostoService;

    public CalculoImpostoController(RN regraNegocio, CalculoImpostoService<ITEM> calculoImpostoService, Supplier<POJO> pojoSupplier) {
        super(regraNegocio, pojoSupplier, true, true, null, true);
        this.calculoImpostoService = calculoImpostoService;
    }

    @RequestMapping(value={"/atualizar-componentes-impostos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ImpostoCalculadoWrapper<ITEM> atualizarComponentes(@RequestBody ImpostoWrapper<ITEM> impostoWrapper) throws UnicoMensagemUsuarioException {
        return this.calculoImpostoService.atualizarComponentes(impostoWrapper);
    }

    @RequestMapping(value={"/calcular-impostos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ImpostoCalculadoWrapper<ITEM> calcularImpostos(@RequestBody ImpostoWrapper<ITEM> impostoWrapper, @RequestParam(required=false) String crud, @RequestParam(required=false, defaultValue="true") boolean mapearAcoes) throws UnicoMensagemUsuarioException {
        TratamentoDadoImpostoInterface interfaceTratamento;
        if (!StringUtil.stringNullOrEmpty((String)crud) && (interfaceTratamento = (TratamentoDadoImpostoInterface)this.tratamentoDadoImpostoMap.get(crud)) != null) {
            interfaceTratamento.tratarObjeto(impostoWrapper);
        }
        return this.calculoImpostoService.calcularImpostos(impostoWrapper, mapearAcoes);
    }

    @RequestMapping(value={"/recalcular-impostos-itens"})
    @DBAutoCommit
    public List<ITEM> recalcularImpostosItens(@RequestBody ImpostoWrapper<ITEM> impostoWrapper) throws UnicoMensagemUsuarioException {
        return this.calculoImpostoService.recalcularImpostosItens(impostoWrapper);
    }
}

