/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.blocox.estoque;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.pafecf.EnvioBlocoX;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.BlocoXJobController;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.BlocoXJobWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.estoque.AtualizacaoCestWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.job.BlocoXAtualizacaoStatusJob;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.job.BlocoXEstoqueReprocessamentoJob;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.job.BlocoXEstoqueTransmissaoJob;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.job.JobAtualizacaoCest;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/blocox-estoque"})
public class BlocoXEstoqueJobController
extends BlocoXJobController {
    private TipoJob tipoJob;
    private Class<? extends AbstractJob> job;

    public BlocoXEstoqueJobController(TaskManager taskManager) {
        super(taskManager);
    }

    public TipoJob getTipoJob() {
        return this.tipoJob;
    }

    public Class<? extends AbstractJob> job() {
        return this.job;
    }

    @PostMapping(value={"/transmitir"})
    @DBTransaction
    public void agendarTransmissao(@RequestBody BlocoXJobWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.validarDocumentos(wrapper, this.getCondicaoTransmissao());
        this.tipoJob = TipoJob.TRANSMISSAO_ESTOQUE_BLOCOX;
        this.job = BlocoXEstoqueTransmissaoJob.class;
        this.createTask((Object)wrapper, "Arquivo(s): " + wrapper.getDocumentos().stream().map(EnvioBlocoX::getArquivo).collect(Collectors.joining(",")));
    }

    @PostMapping(value={"/consultar"})
    @DBTransaction
    public void consultarAguardando(@RequestBody BlocoXJobWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.validarDocumentos(wrapper, this.getCondicaoAguardando());
        this.tipoJob = TipoJob.ATUALIZACAO_STATUS_BLOCOX;
        this.job = BlocoXAtualizacaoStatusJob.class;
        this.createTask((Object)wrapper, "Arquivo(s): " + wrapper.getDocumentos().stream().map(EnvioBlocoX::getArquivo).collect(Collectors.joining(",")));
    }

    @PostMapping(value={"/reprocessar"})
    @DBTransaction
    public void agendarReprocessamento(@RequestBody BlocoXJobWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.validarDocumentos(wrapper, this.getCondicaoReprocessamento());
        this.tipoJob = TipoJob.REPROCESSAR_ESTOQUE_BLOCOX;
        this.job = BlocoXEstoqueReprocessamentoJob.class;
        this.createTask((Object)wrapper, "Arquivo(s): " + wrapper.getDocumentos().stream().map(EnvioBlocoX::getArquivo).collect(Collectors.joining(",")));
    }

    @PostMapping(value={"/atualizar-status"})
    @DBTransaction
    public void agendarAtualizacaoStatus(@RequestBody BlocoXJobWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.validarDocumentos(wrapper, this.getCondicaoAtualizacaoStatus());
        this.tipoJob = TipoJob.ATUALIZACAO_STATUS_BLOCOX;
        this.job = BlocoXAtualizacaoStatusJob.class;
        this.createTask((Object)wrapper, "Arquivo(s): " + wrapper.getDocumentos().stream().map(EnvioBlocoX::getArquivo).collect(Collectors.joining(",")));
    }

    @PostMapping(value={"/atualizar-cest"})
    @DBTransaction
    public void agendarAtualizacaoCest(@RequestBody AtualizacaoCestWrapper atualizacaoCest) throws UnicoMensagemUsuarioException {
        this.tipoJob = TipoJob.ATUALIZACAO_CEST;
        this.job = JobAtualizacaoCest.class;
        this.createTask((Object)atualizacaoCest);
    }
}

