/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.blocox.reducaoz;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.pafecf.EnvioBlocoX;
import br.intelidata.commons.modulo.pdv.blocox.ConsumirLinhaXml;
import br.intelidata.commons.modulo.pdv.blocox.ImportacaoXlsBlocoX;
import br.intelidata.commons.modulo.pdv.regranegocio.EnvioBlocoXRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.core.wrapper.ArquivoInfoWrapper;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.BlocoXJobController;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.BlocoXJobWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.job.BlocoXAtualizacaoStatusJob;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.job.BlocoXReducaoZExclusaoArquivoJob;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.job.BlocoXReducaoZReprocessamentoJob;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.job.BlocoXReducaoZTransmissaoJob;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.job.BlocoXReducaoZValidacaoJob;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import unipaf.geracaoarquivo.CertificadoAssinatura;
import unipaf.geracaoarquivo.blocox.transmissao.AssinaBlocoX;

@RestController
@RequestMapping(value={"/jobs/blocox-reducaoz"})
public class BlocoXReducaoZJobController
extends BlocoXJobController {
    private TipoJob tipoJob;
    private Class<? extends AbstractJob> job;

    public BlocoXReducaoZJobController(TaskManager taskManager) {
        super(taskManager);
    }

    public TipoJob getTipoJob() {
        return this.tipoJob;
    }

    public Class<? extends AbstractJob> job() {
        return this.job;
    }

    @PostMapping(value={"/transmitir"})
    @DBTransaction
    public void agendarTransmissao(@RequestBody BlocoXJobWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.validarDocumentos(wrapper, this.getCondicaoTransmissao());
        this.tipoJob = TipoJob.TRANSMISSAO_REDUCAOZ_BLOCOX;
        this.job = BlocoXReducaoZTransmissaoJob.class;
        this.createTask((Object)wrapper, "Arquivo(s): " + wrapper.getDocumentos().stream().map(EnvioBlocoX::getArquivo).collect(Collectors.joining(",")));
    }

    @PostMapping(value={"/consultar"})
    @DBTransaction
    public void consultarAguardando(@RequestBody BlocoXJobWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.validarDocumentos(wrapper, this.getCondicaoAguardando());
        this.tipoJob = TipoJob.ATUALIZACAO_STATUS_BLOCOX;
        this.job = BlocoXAtualizacaoStatusJob.class;
        this.createTask((Object)wrapper, "Arquivo(s): " + wrapper.getDocumentos().stream().map(EnvioBlocoX::getArquivo).collect(Collectors.joining(",")));
    }

    @PostMapping(value={"/reprocessar"})
    @DBTransaction
    public void agendarReprocessamento(@RequestBody BlocoXJobWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.validarDocumentos(wrapper, this.getCondicaoReprocessamento());
        this.tipoJob = TipoJob.REPROCESSAR_REDUCAOZ_BLOCOX;
        this.job = BlocoXReducaoZReprocessamentoJob.class;
        this.createTask((Object)wrapper, "Arquivo(s): " + wrapper.getDocumentos().stream().map(EnvioBlocoX::getArquivo).collect(Collectors.joining(",")));
    }

    @PostMapping(value={"/atualizar-status"})
    @DBTransaction
    public void agendarAtualizacaoStatus(@RequestBody BlocoXJobWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.validarDocumentos(wrapper, this.getCondicaoAtualizacaoStatus());
        this.tipoJob = TipoJob.ATUALIZACAO_STATUS_BLOCOX;
        this.job = BlocoXAtualizacaoStatusJob.class;
        this.createTask((Object)wrapper, "Arquivo(s): " + wrapper.getDocumentos().stream().map(EnvioBlocoX::getArquivo).collect(Collectors.joining(",")));
    }

    @PostMapping(value={"/validar-reducao-z"})
    @DBTransaction
    public void validarReducaoZ(@RequestBody BlocoXJobWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.tipoJob = TipoJob.VALIDACAO_REDUCAOZ_BLOCOX;
        this.job = BlocoXReducaoZValidacaoJob.class;
        this.createTask((Object)wrapper, "Arquivo(s): " + wrapper.getDocumentos().stream().map(EnvioBlocoX::getArquivo).collect(Collectors.joining(",")));
    }

    @PostMapping(value={"/exclusao-arquivos"})
    @DBTransaction
    public void exclusaoArquivosAnteriores() throws UnicoMensagemUsuarioException {
        this.tipoJob = TipoJob.EXCLUIR_ARQUIVOS_REDUCAOZ_BLOCOX;
        this.job = BlocoXReducaoZExclusaoArquivoJob.class;
        this.createTask(null, "Excluir registros/arquivos do Bloco X anteriores \u00e0 data de in\u00edcio da obriga\u00e7\u00e3o");
    }

    @RequestMapping(value={"/operacoes-xls"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    @DBTransaction
    public void processarArquivo(@RequestPart(value="file") MultipartFile file, @RequestPart(value="importar") boolean importar) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        CertificadoAssinatura certificadoBlocoX = AssinaBlocoX.getInstance().getInfoCertificadoBlocoX(sessao, null).getCertificado();
        ConsumirLinhaXml consumer = importar ? linhaXls -> EnvioBlocoXRN.getInstance().importarRecibo(sessao, linhaXls) : linhaXls -> EnvioBlocoXRN.getInstance().cancelarRecibos(sessao, linhaXls, certificadoBlocoX);
        try {
            new ImportacaoXlsBlocoX().consumirXls(file.getInputStream(), consumer, null);
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW552", "N\u00e3o foi poss\u00edvel processar o arquivo", (Throwable)e);
        }
    }

    @RequestMapping(value={"/carregar-arquivos"})
    public List<ArquivoInfoWrapper> getArquivos() throws UnicoMensagemUsuarioException {
        StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
        return storageService.getArquivos(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, "pafecf/geracaoautomatica/transmitidos");
    }

    @RequestMapping(value={"/download-arquivos"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> downloadArquivo(@RequestBody ArquivoInfoWrapper arquivo) throws UnicoMensagemUsuarioException {
        StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
        ResponseEntityService responseEntityService = (ResponseEntityService)BeanUtil.getBean((String)"responseEntityService");
        File file = storageService.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, arquivo.getPath(), true, false);
        return responseEntityService.createFileResponse(FileUtil.file2ByteArray((File)file), MediaType.APPLICATION_OCTET_STREAM, arquivo.getNome());
    }
}

