/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.camposextras;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.enuns.TabelaCampoExtra;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.ConfiguracaoOrdemServicoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/campos-extras"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", ICONE="icon-dica-campo", NOME="Configura\u00e7\u00e3o de campos extras", ROTA="/cadastros/campos-extras", PROGRAMA=1467)
public class CamposExtrasCrudController
extends CrudController<Extras, ExtrasRN> {
    public CamposExtrasCrudController() {
        super((AbstractRegraNegocio)ExtrasRN.getInstance(), Extras::new);
    }

    @RequestMapping(value={"/buscar-por-tabela"})
    @DBAutoCommit
    public Extras getByNomeTabela(@RequestParam(name="tabela") String nomeTabela) {
        Extras extras;
        if ("conf_os".equalsIgnoreCase(nomeTabela)) {
            nomeTabela = ConfiguracaoOrdemServicoRN.getInstance().getTabelaCampoExtra(SessaoUtil.getSessao().getIdFilial());
        }
        if ((extras = ExtrasRN.getInstance().buscarPorNomeTabela(nomeTabela)) == null) {
            extras = new Extras();
        }
        return extras;
    }

    protected void beforeSave(Extras extras, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (StringUtil.stringNullOrEmpty((String)extras.getNometabela())) {
            throw new UnicoMensagemUsuarioException("COM236186", "Por favor especifique a tabela.");
        }
        if ("conf_os".equalsIgnoreCase(extras.getNometabela())) {
            extras.setNometabela(ConfiguracaoOrdemServicoRN.getInstance().getTabelaCampoExtra(SessaoUtil.getSessao().getIdFilial()));
        }
    }

    protected void afterSave(Extras extras, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        TabelaCampoExtra tabelaCampoExtra = TabelaCampoExtra.getPorAlias((String)extras.getNometabela());
        if (tabelaCampoExtra != null) {
            this.cacheService.removerPorPrefixo(ContextoHolder.getTenant() + "_" + tabelaCampoExtra.getTabelaBase() + "_" + tabelaCampoExtra.getAlias());
        }
    }

    protected GridBuilder<ExtrasRN> getGridBuilder() {
        return new GridBuilder(ExtrasRN.getInstance().getTabela(), new ArrayList());
    }

    protected String getCacheId() {
        return "campos-extras";
    }
}

