/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.compras.pedidocompra;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.TrataImagemWeb;
import br.intelidata.commons.core.impressao.TrataModeloIReportWeb;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.InputStreamDataSource;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.ModeloImpressaoCabecalho;
import br.intelidata.commons.domain.pojo.compras.PedidoCompra;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoCabecalhoRN;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.compras.impressao.ImpressaoPedidoCompra;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.TrataModeloIReportWebImpl;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/pedido-compras"})
public class PedidoCompraJobcontroller
extends CompartilhamentoController<NotificacaoCompartilhamento> {
    @Autowired
    private TrataModeloIReportWebImpl trataModeloIReportWeb;

    public PedidoCompraJobcontroller(TaskManager taskManager) {
        super(taskManager);
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setAssunto(compartilhamento.getAssunto());
        notificacao.setMsg(compartilhamento.getMensagem());
        ModeloImpressaoCabecalho modeloImpressaoCabecalho = (ModeloImpressaoCabecalho)ModeloImpressaoCabecalhoRN.getInstance().buscarPorId(compartilhamento.getIdModelo());
        ArrayList<InputStreamDataSource> sources = new ArrayList<InputStreamDataSource>();
        Malote malote = new Malote();
        List pedidos = PedidoCompraRN.getInstance().buscarListaPorIds(compartilhamento.getIdsDocumentos());
        for (PedidoCompra pedido : pedidos) {
            ImpressaoPedidoCompra impressao = new ImpressaoPedidoCompra(sessao);
            impressao.setTrataImagemWeb((TrataImagemWeb)this);
            Remessa remessa = impressao.imprimir(modeloImpressaoCabecalho, (TrataModeloIReportWeb)this.trataModeloIReportWeb, new Long[]{pedido.getId()});
            byte[] arquivo = remessa.getMalote().extrai("pdf");
            if (arquivo == null) continue;
            String nome = "PedidoCompra" + pedido.getCodigo() + ".pdf";
            InputStreamDataSource dataSourceXml = new InputStreamDataSource(nome, "application/pdf", (InputStream)new ByteArrayInputStream(arquivo));
            malote.inclui(nome, arquivo);
            sources.add(dataSourceXml);
        }
        notificacao.setDataSources(sources.toArray(new DataSource[0]));
        notificacao.setMalote(malote);
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "Pedido de compra");
        taskEmail.createTask((Object)parametrosEmail, "Envio de e-mail de pedido de compra");
    }

    @PostMapping(value={"/compartilhar"})
    @DBTransaction
    public String compartilhar(@RequestBody NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        return super.compartilhar(compartilhamento);
    }
}

