/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.configuracaopdv;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.pafecf.ConfiguracaoPdv;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.ConfiguracaoPdvRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.configuracaopdv.ConfiguracaoPdvWrapper;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracao-pdv"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Configura\u00e7\u00e3o do PDV Web", ICONE="icon-cupom-fiscal", ROTA="/vendas/configuracao-pdv", PROGRAMA=1000084)
public class ConfiguracaoPdvCrudController
extends SimpleCrudController<ConfiguracaoPdv, ConfiguracaoPdvRN> {
    public ConfiguracaoPdvCrudController() {
        super((AbstractRegraNegocio)ConfiguracaoPdvRN.getInstance());
    }

    @RequestMapping(value={"/buscar-lista"})
    @DBAutoCommit
    public ConfiguracaoPdvWrapper buscarListaConfiguracoes() {
        ConfiguracaoPdvWrapper config = new ConfiguracaoPdvWrapper();
        Map maps = ((ConfiguracaoPdvRN)this.getRegraNegocio()).buscarListaPorPerfilEChaveWeb(SessaoUtil.getSessao().getCodigoFilial());
        config.setVerificarSaldoSangria((String)maps.get("Pdv.VerificaSaldoSangria"));
        config.setImpressoraNaoFiscal((String)maps.get("comboModeloImpressoraNaoFiscal"));
        config.setImpressoraNaoFiscalEndereco((String)maps.get("ImpressoraNaoFiscal.Endereco"));
        config.setImpressoraNaoFiscalCodigoPagina((String)maps.get("ImpressoraNaoFiscal.CodigoPagina"));
        config.setImpressoraNaoFiscalAvancarLinhas((String)maps.get("ImpressoraNaoFiscal.AvancarLinhas"));
        config.setImpressoraNaoFiscalEspacoLinhas((String)maps.get("ImpressoraNaoFiscal.EspacoLinhas"));
        config.setImpressoraNaoFiscalRemoverAcentos((String)maps.get("ImpressoraNaoFiscal.RemoverAcentos"));
        config.setNumeroDeViasImpressao(maps.containsKey("numeroDeViasImpressao") ? Integer.parseInt((String)maps.get("numeroDeViasImpressao")) : 1);
        return config;
    }

    @RequestMapping(value={"/gravar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void gravarLista(@RequestBody ConfiguracaoPdvWrapper configuracoes) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ((ConfiguracaoPdvRN)this.getRegraNegocio()).alterarPorChaveWeb(sessao, "Pdv.VerificaSaldoSangria", configuracoes.getVerificarSaldoSangria());
        ((ConfiguracaoPdvRN)this.getRegraNegocio()).alterarPorChaveWeb(sessao, "comboModeloImpressoraNaoFiscal", configuracoes.getImpressoraNaoFiscal());
        ((ConfiguracaoPdvRN)this.getRegraNegocio()).alterarPorChaveWeb(sessao, "ImpressoraNaoFiscal.Endereco", configuracoes.getImpressoraNaoFiscalEndereco());
        ((ConfiguracaoPdvRN)this.getRegraNegocio()).alterarPorChaveWeb(sessao, "ImpressoraNaoFiscal.CodigoPagina", configuracoes.getImpressoraNaoFiscalCodigoPagina());
        ((ConfiguracaoPdvRN)this.getRegraNegocio()).alterarPorChaveWeb(sessao, "ImpressoraNaoFiscal.AvancarLinhas", configuracoes.getImpressoraNaoFiscalAvancarLinhas());
        ((ConfiguracaoPdvRN)this.getRegraNegocio()).alterarPorChaveWeb(sessao, "ImpressoraNaoFiscal.EspacoLinhas", configuracoes.getImpressoraNaoFiscalEspacoLinhas());
        ((ConfiguracaoPdvRN)this.getRegraNegocio()).alterarPorChaveWeb(sessao, "ImpressoraNaoFiscal.RemoverAcentos", configuracoes.getImpressoraNaoFiscalRemoverAcentos());
        ((ConfiguracaoPdvRN)this.getRegraNegocio()).alterarPorChaveWeb(sessao, "numeroDeViasImpressao", String.valueOf(configuracoes.getNumeroDeViasImpressao()));
    }
}

