/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.cupompromocional;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.pafecf.CupomPromocional;
import br.intelidata.commons.domain.pojo.pafecf.CupomPromocionalFilial;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.pdv.regranegocio.CupomPromocionalFilialRN;
import br.intelidata.commons.modulo.pdv.regranegocio.CupomPromocionalRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cupom-promocional"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Cupom promocional", ROTA="/pdvs/cupom-promocional", PROGRAMA=1000083)
public class CupomPromocionalCrudController
extends CrudController<CupomPromocional, CupomPromocionalRN> {
    public CupomPromocionalCrudController() {
        super((AbstractRegraNegocio)CupomPromocionalRN.getInstance(), CupomPromocional::new);
    }

    protected String getCacheId() {
        return "cupom-promocional";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("datainicial", "fdatainicial", "Data inicial", 0, false, new String[0]));
        colunas.add(new ColunaSQL("datafinal", "fdatafinal", "Data final", 0, false, new String[0]));
        ColunaSQL coluna = new ColunaSQL("inativo", "finativo", "Inativo", 0, false, new String[0]);
        coluna.setClasseEnum(EnumSimNao.class);
        colunas.add(coluna);
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 200, true));
        colunas.add(new ColunaSQL("datainicial", "Data inicial", 400, true));
        colunas.add(new ColunaSQL("datafinal", "Data final", 400, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("inativo", "Inativo", 150, true));
        GridBuilder gb = new GridBuilder(((CupomPromocionalRN)this.rn).getTabela(), colunas);
        gb.setOrdemDefault(new Ordem("datainicial"));
        return gb;
    }

    protected void beforeRead(CupomPromocional cupomPromocional, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        List filiais = CupomPromocionalFilialRN.getInstance().buscarListaPorCupom(cupomPromocional.getId());
        for (CupomPromocionalFilial cpf : filiais) {
            Filial filial = (Filial)FilialRN.getInstance().buscarPorId(cpf.getIdFilial());
            if (filial == null) continue;
            cpf.setCodigoFilial(filial.getCodigo());
            cpf.setNomeFilial(filial.getNome());
        }
        cupomPromocional.setFiliais(filiais);
    }
}

