/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ecommerce;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.ConfiguracaoEcommerce;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoEcommerceCommonRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.ecommerce.EcommerceProcessoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.ecommerce.JobEcommerce;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/jobs-ecommerce/"})
@SubMenuMapping(MENU="SubMenuEcommerceGeral", ICONE="icon-internet", NOME="Sincronizar", ROTA="/ecommerce/sincronizar-ecommerce", PROGRAMA=11005)
public class EcommerceTaskJobController
implements ICreateTask {
    private final TaskManager taskManager;

    @Autowired
    public EcommerceTaskJobController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return TipoJob.ECOMMERCE;
    }

    public Class<? extends AbstractJob> job() {
        return JobEcommerce.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"sincronizar-produtos"}, method={RequestMethod.POST})
    @DBTransaction
    public void agendarSincronizarProdutos(@RequestBody EcommerceProcessoWrapper wrapper) throws UnicoMensagemUsuarioException {
        String detalhe = "Sincronizar produtos E-commerce";
        this.agendar(wrapper, 0, detalhe);
    }

    @RequestMapping(value={"sincronizar-pedidos"}, method={RequestMethod.POST})
    @DBTransaction
    public void agendarSincronizarPedidos(@RequestBody EcommerceProcessoWrapper wrapper) throws UnicoMensagemUsuarioException {
        String detalhe = "Sincronizar pedidos E-commerce";
        this.agendar(wrapper, 1, detalhe);
    }

    @RequestMapping(value={"importar-produtos"}, method={RequestMethod.POST})
    @DBTransaction
    public void agendarImportacaoPedidos(@RequestBody EcommerceProcessoWrapper wrapper) throws UnicoMensagemUsuarioException {
        String detalhe = "Importa\u00e7\u00e3o associa\u00e7\u00f5es";
        this.agendar(wrapper, 2, detalhe);
    }

    private void agendar(EcommerceProcessoWrapper wrapper, int processo, String descricao) throws UnicoMensagemUsuarioException {
        this.verificaPodeSincronizar(wrapper.getIdConfiguracao());
        wrapper.setProcesso(processo);
        this.createTask((Object)wrapper, null, descricao, true);
    }

    public void verificaPodeSincronizar(Long idConfiguracaoEcommerce) throws UnicoMensagemUsuarioException {
        ConfiguracaoEcommerce configuracaoEcommerce = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(idConfiguracaoEcommerce);
        if (configuracaoEcommerce != null && configuracaoEcommerce.isInativo()) {
            throw new UnicoMensagemUsuarioException("WECO339", "Configura\u00e7\u00e3o de e-commerce inativa.");
        }
        List configuracaoEcommerces = ConfiguracaoEcommerceCommonRN.getInstance().buscarListaSincronizar();
        if (configuracaoEcommerce == null && ListMapUtil.listNullOrEmpty((List)configuracaoEcommerces)) {
            throw new UnicoMensagemUsuarioException("WWW709", "Nenhuma configura\u00e7\u00e3o Ecommerce encontrada para a filial logada. Verifique!");
        }
    }
}

