/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.expedicao.carga;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoCargaDocumento;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoRetiradaEntregaItem;
import br.intelidata.commons.domain.pojo.enuns.expedicao.StatusCarga;
import br.intelidata.commons.domain.pojo.expedicao.DocumentoConferidoInterface;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoDocumento;
import br.intelidata.commons.domain.pojo.vendas.Carga;
import br.intelidata.commons.domain.pojo.vendas.CargaDocumento;
import br.intelidata.commons.domain.pojo.vendas.CargaItem;
import br.intelidata.commons.domain.pojo.vendas.ConferenciaDocumentoItemDivergencia;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.CargaDocumentoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.CargaDocumentoRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.CargaItemRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.CargaRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.ConferenciaDocumentoItemDivergenciaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.expedicao.carga.CargaWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.expedicao.carga.ImportarDocumentoCargaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cargas"})
@SubMenuMapping(MENU="SubMenuEstoqueExpedicao", NOME="Cargas", ROTA="/expedicoes/cargas", PROGRAMA=317, ICONE="icon-local-estoque")
public class CargaCrudController
extends CrudController<Carga, CargaRN> {
    @Autowired
    public CargaCrudController() {
        super((AbstractRegraNegocio)CargaRN.getInstance(), Carga::new, true, true);
    }

    protected GridBuilder<CargaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo da carga", 0, false));
        colunas.add(new ColunaSQL("data", "Data", 0, false));
        colunas.add(new ColunaSQL("status", "Status", 0, false));
        colunas.add(new ColunaSQL("statusConferencia", "Status confer\u00eancia", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 150, true));
        colunas.add(new ColunaSQL("nomeCarga", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("data", "Data", 150, true));
        colunas.add(new ColunaSQL("nome", "nomeMotorista", "Motorista", 0, true, new String[]{"fk_carga_motorista"}));
        colunas.add(new ColunaSQL("descricao", "descricaoMeioTransporte", "Meio de transporte", 0, true, new String[]{"fk_carga_meiotransporte"}));
        colunas.add(new ColunaSQL("status", "Status", 150, true));
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CONFERENCIA)) {
            colunas.add(new ColunaSQL("statusconferencia", "Confer\u00eancia", 200, true));
        }
        GridBuilder grid = new GridBuilder(CargaRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        grid.addOrdemDefault(new Ordem("data"));
        grid.addOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    @RequestMapping(value={"/buscar-documentos-carga"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<CargaDocumento> getDocumentos(@RequestBody ImportarDocumentoCargaWrapper wrapper) throws UnicoMensagemUsuarioException {
        List documentos = null;
        if (wrapper.getTipoCarga().equals((Object)TipoCargaDocumento.PEDIDO_FATURAMENTO)) {
            documentos = CargaRN.getInstance().buscarDadosParaCargaDePedidos(wrapper.getIdCliente(), SessaoUtil.getSessao().getFilial(), TipoRetiradaEntregaItem.ENTREGA, wrapper.getEntregaDe(), wrapper.getEntregaAte(), wrapper.getIdRota(), wrapper.getIdsSelecionados(), wrapper.getIdEstado(), wrapper.getBairro(), wrapper.getIdCidade(), wrapper.getNumeroDocumento(), wrapper.getIdVendedor(), wrapper.getIdsExcluidos(), wrapper.getEmissaoDe(), wrapper.getEmissaoAte());
        } else {
            if (wrapper.getEmissaoDe() == null || wrapper.getEmissaoAte() == null) {
                throw new UnicoMensagemUsuarioException("EXP101", "Informe a emiss\u00e3o inicial e final para o filtro.");
            }
            Filial filial = !Util.longNullOuZero((Long)wrapper.getIdFilial()) ? (Filial)FilialRN.getInstance().buscarPorId(wrapper.getIdFilial()) : SessaoUtil.getSessao().getFilial();
            if (wrapper.getTipoCarga().equals((Object)TipoCargaDocumento.PDV)) {
                documentos = CargaRN.getInstance().buscarDadosParaCargaDeOperacao(wrapper.getIdCliente(), filial, TipoRetiradaEntregaItem.ENTREGA, wrapper.getEmissaoDe(), wrapper.getEmissaoAte(), wrapper.getIdRota(), wrapper.getIdsSelecionados(), wrapper.getIdEstado(), wrapper.getBairro(), wrapper.getIdCidade(), wrapper.getNumeroDocumento(), wrapper.getConsumidor(), wrapper.getIdsExcluidos());
            } else if (wrapper.getTipoCarga().equals((Object)TipoCargaDocumento.NOTA_FISCAL)) {
                documentos = CargaRN.getInstance().buscarDadosParaCargaDeNotaFiscal(wrapper.getIdCliente(), filial, TipoRetiradaEntregaItem.ENTREGA, wrapper.getEmissaoDe(), wrapper.getEmissaoAte(), wrapper.getIdRota(), wrapper.getIdsSelecionados(), wrapper.getIdEstado(), wrapper.getBairro(), wrapper.getIdCidade(), wrapper.getNumeroNotaFiscal(), wrapper.getNumeroPedido(), wrapper.getIdsExcluidos(), null, true);
            }
        }
        this.definePodeAlterar(documentos);
        if (documentos != null) {
            documentos.forEach(doc -> doc.setItens(this.agruparItensKit(doc.getItens())));
        }
        return documentos;
    }

    @PostMapping(value={"/abrir"})
    @DBTransaction
    public void abrirCarga(@RequestBody Long idCarga) throws UnicoMensagemUsuarioException {
        Carga carga = (Carga)((CargaRN)this.rn).buscarPorId(idCarga);
        if (carga == null) {
            throw new UnicoMensagemUsuarioException("EXP95", "N\u00e3o foi poss\u00edvel encontrar a carga selecionada. Verifique");
        }
        if (!carga.getStatus().isPodeAbrir()) {
            throw new UnicoMensagemUsuarioException("EXP96", "O status '" + carga.getStatus().getDescricao() + "' n\u00e3o permite abrir a carga.");
        }
        CargaRN.getInstance().abrirCarga(carga, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/verificar-pode-fechar"})
    @DBAutoCommit
    public Map<String, Object> verificarSePodeFecharCarga(@RequestParam Long idCarga) throws UnicoMensagemUsuarioException {
        Carga carga = (Carga)((CargaRN)this.rn).buscarPorId(idCarga);
        if (carga == null) {
            throw new UnicoMensagemUsuarioException("EXP97", "N\u00e3o foi poss\u00edvel encontrar a carga selecionada. Verifique");
        }
        if (carga.getStatus().isPodeFechar()) {
            List idsPedidos = CargaDocumentoRN.getInstance().buscarListaIdPedidos(carga.getId());
            if (!ListMapUtil.listNullOrEmpty((List)idsPedidos)) {
                HashMap<String, Object> retorno = new HashMap<String, Object>();
                retorno.put("idsPedidos", idsPedidos);
                retorno.put("itensCarga", CargaItemRN.getInstance().buscarListaPorIdCarga(carga.getId()));
                return retorno;
            }
        } else {
            throw new UnicoMensagemUsuarioException("EXP98", "O status '" + carga.getStatus().getDescricao() + "' n\u00e3o permite fechar a carga.");
        }
        return null;
    }

    @PostMapping(value={"/fechar"})
    @DBTransaction
    public void fecharCarga(@RequestBody Long idCarga) throws UnicoMensagemUsuarioException {
        Carga carga = (Carga)((CargaRN)this.rn).buscarPorId(idCarga);
        if (carga == null) {
            throw new UnicoMensagemUsuarioException("EXP99", "N\u00e3o foi poss\u00edvel encontrar a carga selecionada. Verifique");
        }
        if (!carga.getStatus().isPodeFechar()) {
            throw new UnicoMensagemUsuarioException("EXP100", "O status '" + carga.getStatus().getDescricao() + "' n\u00e3o permite fechar a carga.");
        }
        CargaRN.getInstance().fecharCarga(SessaoUtil.getSessao(), idCarga);
    }

    private void definePodeAlterar(List<CargaDocumento> documentos) {
        if (documentos != null) {
            for (CargaDocumento documento : documentos) {
                for (CargaItem item : documento.getItens()) {
                    Map map = ProdutoRN.getInstance().buscarValoresPorID(item.getIdProduto(), new String[]{"numeroserie", "possuivariacao", "possuilote"});
                    item.setPossuiNumeroSerie((Integer)map.get("numeroserie") == 1);
                    item.setPossuiVariacao((Integer)map.get("possuivariacao") == 1);
                    item.setPossuiLote((Integer)map.get("possuilote") == 1);
                }
            }
        }
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @DBAutoCommit
    public Carga read(@PathVariable Long id, @PathVariable Optional<Long> parentId, @RequestParam(required=false, defaultValue="0") int modo, @RequestParam(required=false) MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        boolean conferencia;
        Carga carga = (Carga)super.read(id, parentId, modo, parameters);
        if (parameters.containsKey((Object)"conferencia") && (conferencia = Boolean.parseBoolean((String)parameters.getFirst((Object)"conferencia")))) {
            List divergencias = new ConferenciaDocumentoItemDivergenciaRN().conferir(new DocumentoConferidoInterface[]{carga});
            Map mapPorItem = divergencias.stream().filter(c -> c.getCargaItem() != null).collect(Collectors.toMap(c -> c.getCargaItem().getId(), Function.identity()));
            carga.getDocumentos().stream().flatMap(d -> d.getItens().stream()).forEach(i -> i.setConferencia((ConferenciaDocumentoItemDivergencia)mapPorItem.get(i.getId())));
        }
        carga.getDocumentos().forEach(doc -> doc.setItens(this.agruparItensKit(doc.getItens())));
        return carga;
    }

    protected void beforeRead(Carga carga, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        carga.setDocumentos(CargaDocumentoCommonRN.getInstance().buscarListaPorIdCargaComItens(carga.getId()));
        this.definePodeAlterar(carga.getDocumentos());
    }

    protected void beforeCreate(Carga carga, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        carga.setStatus(StatusCarga.ABERTA);
    }

    protected void beforeSave(Carga carga, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        carga.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        carga.getDocumentos().forEach(doc -> doc.setItens(this.separarItensKit(doc.getItens())));
    }

    @PostMapping(value={"/processar-status-conferencia"})
    @DBAutoCommit
    public CargaItem processarStatusConferencia(@RequestBody CargaWrapper wrapper) {
        wrapper.getItem().getConferencia().processarStatus(wrapper.getItens().stream().map(CargaItem::getConferencia).filter(Objects::nonNull).collect(Collectors.toList()), wrapper.getItem().getQuantidade());
        return wrapper.getItem();
    }

    @PostMapping(value={"/gerar-mdfe"})
    @DBAutoCommit
    public ManifestoDocumento gerarMDFe(@RequestBody Long idCarga) throws UnicoMensagemUsuarioException {
        List listaDocumentosCarga = CargaDocumentoRN.getInstance().buscarListaPorIdCarga(idCarga);
        ArrayList<CargaDocumento> listaNotas = new ArrayList<CargaDocumento>();
        StringBuilder sbDocumentosIgnorados = new StringBuilder();
        StringBuilder sbNotasSemXml = new StringBuilder();
        for (CargaDocumento documento : listaDocumentosCarga) {
            if (Util.longNullOuZero((Long)documento.getIdNotaFiscal())) {
                sbDocumentosIgnorados.append(Util.stringNullOrEmpty((String)sbDocumentosIgnorados.toString()) ? "Os seguintes documentos foram ignorados: " + Util.lineSeparator : ", ");
                sbDocumentosIgnorados.append(Util.longNullOuZero((Long)documento.getNumeroPedido()) ? "PDV " + documento.getNumeroOperacao() : "Pedido " + documento.getNumeroPedido());
                continue;
            }
            Map map = NotaFiscalRN.getInstance().buscarValoresPorID(documento.getIdNotaFiscal(), new String[]{"arquivoXmlAutorizada"});
            if (map.get("arquivoXmlAutorizada") == null || ((byte[])map.get("arquivoXmlAutorizada")).length == 0) {
                sbNotasSemXml.append(Util.stringNullOrEmpty((String)sbNotasSemXml.toString()) ? "As seguintes notas sem XML autorizado foram ignoradas: " + Util.lineSeparator : ", ");
                sbNotasSemXml.append(documento.getNumeroNotaFiscal());
                continue;
            }
            listaNotas.add(documento);
        }
        if (Util.listNullOrEmpty(listaNotas)) {
            throw new UnicoMensagemUsuarioException("WEXPEDICAO27", "N\u00e3o \u00e9 poss\u00edvel gerar MDF-e de uma carga sem notas autorizadas.");
        }
        ManifestoDocumento manifesto = CargaRN.getInstance().gerarMDFe(idCarga, listaNotas);
        if (sbDocumentosIgnorados.length() > 0 || sbNotasSemXml.length() > 0) {
            manifesto.setMensagem("MDF-e gerado com avisos:<br>" + sbDocumentosIgnorados.append("<br>").append((CharSequence)sbNotasSemXml).toString().trim());
        }
        return manifesto;
    }

    private List<CargaItem> separarItensKit(List<CargaItem> itensOriginal) {
        ArrayList<CargaItem> itens = new ArrayList<CargaItem>();
        if (itensOriginal != null) {
            for (CargaItem it : itensOriginal) {
                itens.add(it);
                if (ListMapUtil.listNullOrEmpty((List)it.getFilhosKit())) continue;
                itens.addAll(it.getFilhosKit());
                it.setFilhosKit(null);
            }
        }
        return itens;
    }

    private List<CargaItem> agruparItensKit(List<CargaItem> itens) {
        ArrayList<CargaItem> itensFinal = new ArrayList<CargaItem>();
        for (int i = 0; i < itens.size(); ++i) {
            CargaItem item = itens.get(i);
            if (item.getTipoKit() == TipoKit.KIT_PAI.getId().intValue()) {
                CargaItem itemKit;
                ArrayList<CargaItem> filhos = new ArrayList<CargaItem>();
                for (int j = i + 1; j < itens.size() && (itemKit = itens.get(j)).getTipoKit() == TipoKit.KIT_COMPONENTE.getId().intValue(); ++j) {
                    CargaItem itemPai = (CargaItem)SerializationUtils.clone((Serializable)item);
                    itemPai.setFilhosKit(null);
                    filhos.add(itemKit);
                }
                item.setFilhosKit(filhos);
                itensFinal.add(item);
                continue;
            }
            if (item.getTipoKit() != TipoKit.SEM_KIT.getId().intValue()) continue;
            itensFinal.add(item);
        }
        return itensFinal;
    }

    protected String getCacheId() {
        return "cargas".concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }
}

