/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.fiscal;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.fiscal.NaturezaOperacaoClassificacaoTributaria;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.fiscal.regranegocio.ClassificacaoTributariaIbsCbsRN;
import br.intelidata.commons.modulo.fiscal.regranegocio.NaturezaOperacaoClassificacaoTributariaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.fiscal.ValidacaoClassificacaoTributariaWrapper;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/naturezas-operacao-classificacao-tributaria"})
public class NaturezaOperacaoClassificacaoTributariaCrudController
extends CrudController<NaturezaOperacaoClassificacaoTributaria, NaturezaOperacaoClassificacaoTributariaRN> {
    public NaturezaOperacaoClassificacaoTributariaCrudController() {
        super((AbstractRegraNegocio)NaturezaOperacaoClassificacaoTributariaRN.getInstance(), NaturezaOperacaoClassificacaoTributaria::new);
        this.dependsOn("idNaturezaOperacao");
    }

    protected String getCacheId() {
        return "naturezas-operacao-classificacao-tributaria";
    }

    public GridBuilder<NaturezaOperacaoClassificacaoTributariaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idNaturezaOperacao", "idNaturezaOperacao", 0, false));
        colunas.add(new ColunaSQL("currentTimeMillis", "currentTimeMillis", 0, false));
        colunas.add(new ColunaSQL("idClassificacaoTributaria", "idClassificacaoTributaria", 0, false));
        colunas.add(new ColunaSQL("idClassificacaoTributacaoReg", "idClassificacaoTributacaoReg", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoClassificacao", "C\u00f3digo", 84, true, new String[]{"natopeclassiftrib_classiftrib"}));
        colunas.add(new ColunaSQL("codigo", "codigoClassificacaoTribReg", "Classifica\u00e7\u00e3o regular", 84, true, new String[]{"natopeclassiftrib_trib_reg"}));
        colunas.add(new ColunaSQL("cst", "cstClassificacao", "CST", 220, true, new String[]{"natopeclassiftrib_classiftrib"}));
        colunas.add(new ColunaSQL("nome", "nomeClassificacao", "Nome", 400, true, new String[]{"natopeclassiftrib_classiftrib"}));
        colunas.add(new ColunaSQL("datainiciovigencia", "dataInicioVigencia", "In\u00edcio", 220, true, new String[]{"natopeclassiftrib_classiftrib"}));
        colunas.add(new ColunaSQL("datafimvigencia", "dataFimVigencia", "Fim", 220, true, new String[]{"natopeclassiftrib_classiftrib"}));
        return new GridBuilder(NaturezaOperacaoClassificacaoTributariaRN.getInstance().getTabela(), colunas);
    }

    @PostMapping(value={"/validar-inclusao-tabela"})
    @DBAutoCommit
    public void validarInclusaoTabela(@RequestBody ValidacaoClassificacaoTributariaWrapper<NaturezaOperacaoClassificacaoTributaria> validacaoWrapper) throws UnicoMensagemUsuarioException {
        ClassificacaoTributariaIbsCbsRN.getInstance().validarObjetoClassificacaoTributaria(validacaoWrapper.getListaClassificacoes(), validacaoWrapper.getClassificacaoInformada());
    }
}

