/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.integracao.RetornoIntegracaoFiscal;
import br.intelidata.commons.modulo.integracao.regranegocio.UnicoIntegracaoFiscal;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal.IntegracaoFiscalJobWrapper;

public class JobIntegracaoFiscal
extends AbstractPrepareJob {
    private RetornoIntegracaoFiscal retorno;

    public JobIntegracaoFiscal(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void execute() throws Exception {
        IntegracaoFiscalJobWrapper wrapper = (IntegracaoFiscalJobWrapper)this.getObjetoDeserializado(IntegracaoFiscalJobWrapper.class);
        Sessao sessao = SessaoUtil.getSessaoJob();
        this.retorno = new UnicoIntegracaoFiscal(sessao).geraRemessaProdutosJson(sessao, wrapper.getProdutos(), null);
    }

    public boolean abstractControlTransaction() {
        return false;
    }

    public void onFailure(Exception ex) {
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        String mensagem;
        if (this.retorno != null) {
            String string = mensagem = !StringUtil.stringNullOrEmpty((String)this.retorno.getMensagemRetornoDetalhe()) ? this.retorno.getMensagemRetorno() : "Consulta de tributa\u00e7\u00e3o efetuada!";
            if (!StringUtil.stringNullOrEmpty((String)this.retorno.getMensagemRetornoDetalhe())) {
                mensagem = mensagem + "<br>" + this.retorno.getMensagemRetornoDetalhe().replace("\n", "<br>");
            }
        } else {
            mensagem = "Envio de produtos realizado com sucesso.";
        }
        return new Notificacao(TipoNotificacaoSimples.SUCCESS, mensagem);
    }

    protected Notificacao getNotificacaoErro(Task task) {
        String msg = "Falhou ao enviar produtos";
        if (task.getExcecao() != null && task.getExcecao() instanceof UnicoMensagemUsuarioException) {
            msg = msg + ". " + ((UnicoMensagemUsuarioException)((Object)task.getExcecao())).getMensagemSemCodigo();
        }
        return new Notificacao(TipoNotificacaoSimples.ERROR, msg);
    }
}

