/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.jobsexecutor;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.JobExecutor;
import br.intelidata.commons.domain.pojo.JobExecutorFile;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.JobExecutorFileRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.JobExecutorRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class JobsExecutorCrudController
extends CrudController<JobExecutor, JobExecutorRN> {
    private StorageService fileServer;

    @Autowired
    public JobsExecutorCrudController(StorageService fileServer) {
        super((AbstractRegraNegocio)JobExecutorRN.getInstance(), JobExecutor::new, true, true);
        this.fileServer = fileServer;
    }

    protected GridBuilder<JobExecutorRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 80, true));
        colunas.add(new ColunaSQL("idUsuario", "idUsuario", 0, false));
        colunas.add(new ColunaSQL("possuiArquivo", "possuiArquivo", 0, false));
        colunas.add(new ColunaSQL("tipoJob", "Tipo", 200, true));
        colunas.add(new ColunaSQL("nome", "Descri\u00e7\u00e3o", 300, true));
        colunas.add(new ColunaSQL("status", "Status", 80, true));
        colunas.add(new ColunaSQL("dataHoraFinal", "Data/hora Execu\u00e7\u00e3o", 150, true));
        colunas.add(new ColunaSQL("resumoFiltros", "Detalhes", 320, true));
        colunas.add(new ColunaSQL("retorno", "Retorno", 600, true));
        colunas.add(new ColunaSQL("tipoJob", "tipoJobFiltro", "Tipo", 200, false, new String[0]));
        GridBuilder grid = new GridBuilder(JobExecutorRN.getInstance().getTabela(), colunas);
        grid.addCodicaoDefault(new Condicao("idUsuario", Operador.IGUAL, SessaoUtil.getSessao().getIdUsuario()));
        grid.setOrdemDefault(new Ordem("id", true));
        return grid;
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    @DBAutoCommit
    public String downloadXML(@RequestParam(value="idJobExecutor") Long idJobExecutor) {
        JobExecutorFile file = (JobExecutorFile)JobExecutorFileRN.getInstance().getArquivosPorIdJobExecutor(idJobExecutor).get(0);
        return this.fileServer.publishArquivo(file.getUrl());
    }

    protected String getCacheId() {
        return "controle-processamentos".concat("_USUARIO=").concat(SessaoUtil.getSessao().getIdUsuario().toString());
    }
}

