/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.naturezaoperacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.CfopEstado;
import br.intelidata.commons.domain.pojo.CfopIncentivoFiscal;
import br.intelidata.commons.domain.pojo.CfopTributacao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.NaturezaOperacaoDTOWeb;
import br.intelidata.commons.domain.pojo.NaturezaOperacaoIncentivoImposto;
import br.intelidata.commons.domain.pojo.enuns.CstICMS;
import br.intelidata.commons.domain.pojo.enuns.CstPisCofins;
import br.intelidata.commons.domain.pojo.enuns.CstSNICMS;
import br.intelidata.commons.domain.pojo.enuns.FinalidadeEmissaoNfeCFOP;
import br.intelidata.commons.domain.pojo.enuns.MotivoDesoneracaoIcms;
import br.intelidata.commons.domain.pojo.enuns.MotivoDesoneracaoPisCofins;
import br.intelidata.commons.domain.pojo.enuns.NaturezaOperacaoConhecimentoTransporte;
import br.intelidata.commons.domain.pojo.enuns.TipoImpostoIncentivado;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimento;
import br.intelidata.commons.domain.pojo.enuns.nfe.LocalDestinoOperacaoNFE;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.BeneficioFiscalRN;
import br.intelidata.commons.domain.regranegocio.CfopEstadoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CfopEstadoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CfopPadraoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoIncentivoImpostoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/naturezas-operacao"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Naturezas de opera\u00e7\u00e3o fiscal", ROTA="/notas-fiscais/naturezas-operacao", PROGRAMA=18)
public class NaturezaOperacaoCrudController
extends CrudController<NaturezaOperacao, NaturezaOperacaoRN> {
    @Autowired
    public NaturezaOperacaoCrudController() {
        super((AbstractRegraNegocio)NaturezaOperacaoRN.getInstance(), NaturezaOperacao::new, true, true);
    }

    @RequestMapping(value={"/filtrar-tributacao-especial"})
    @DBAutoCommit
    public ResponseEntity<String> filtrarTributacaoEspecial(@RequestParam(value="query", required=false) String query, @RequestParam(required=false) String id) {
        List tributacoes = NaturezaOperacaoRN.getInstance().getTributacaoesEspeciais(SessaoUtil.getSessao().getIdFilial());
        tributacoes = !StringUtil.stringNullOrEmpty((String)id) ? tributacoes.stream().filter(tributacao -> !tributacao.trim().isEmpty() && tributacao.toUpperCase().equals(id.toUpperCase())).collect(Collectors.toList()) : tributacoes.stream().filter(tributacao -> !tributacao.trim().isEmpty() && (StringUtil.stringNullOrEmpty((String)query) || tributacao.toUpperCase().contains(query.toUpperCase()))).collect(Collectors.toList());
        String json = tributacoes.stream().map(tributacao -> new StringBuilder("{\"id\":").append(JsonUtil.escapeQuote((String)tributacao)).append(", \"descricao\":").append(JsonUtil.escapeQuote((String)tributacao)).append("}")).collect(Collectors.joining(","));
        return this.responseEntityService.createJSONResponse("[" + json + "]");
    }

    @RequestMapping(value={"/filtrar-tipo-estado"})
    @DBAutoCommit
    public List<NaturezaOperacaoDTOWeb> filtrarPorTipoEstado(@RequestParam(required=false) Boolean interna, @RequestParam(required=false) TipoMovimento tipoMovimento, @RequestParam(required=false) String estadoOrigem, @RequestParam(required=false) String estadoDestino, @RequestParam(defaultValue="0") int origem, @RequestParam(required=false) String query, @RequestParam(defaultValue="6") int limit, @RequestParam(required=false) boolean cteAnulacao, @RequestParam(required=false) boolean removerInformarTotaisManualmente) {
        List naturezas = cteAnulacao ? NaturezaOperacaoRN.getInstance().getListaCFOPCteAnulacaoWeb(SessaoUtil.getSessao()) : (interna != null ? NaturezaOperacaoRN.getInstance().getListaCFOPInternaExternaWeb(SessaoUtil.getSessao(), interna.booleanValue(), tipoMovimento, query, limit) : NaturezaOperacaoRN.getInstance().getNaturezasAutoCompleteTypeWeb(SessaoUtil.getSessao(), tipoMovimento, estadoOrigem, estadoDestino, origem, query, limit));
        if (removerInformarTotaisManualmente) {
            naturezas.removeIf(NaturezaOperacao::isInformarTotaisManualmente);
        }
        return naturezas.stream().map(naturezaOperacao -> {
            NaturezaOperacaoDTOWeb dto = new NaturezaOperacaoDTOWeb();
            BeanUtil.copiarValores((Object)naturezaOperacao, (Object)dto, (boolean)false, null);
            return dto;
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<NaturezaOperacaoDTOWeb> carregarCombo(@RequestParam(required=false, defaultValue="0") Long idFilial, @RequestParam TipoMovimento tipoMovimento, @RequestParam LocalDestinoOperacaoNFE destino) {
        Sessao sessao = SessaoUtil.getSessao();
        Filial filial = !NumberUtil.longNullOuZero((Long)idFilial) ? (Filial)FilialRN.getInstance().buscarPorId(idFilial) : sessao.getFilial();
        List comboWeb = NaturezaOperacaoRN.getInstance().getComboWeb(sessao, filial, tipoMovimento, destino);
        return comboWeb.stream().map(naturezaOperacao -> {
            NaturezaOperacaoDTOWeb dto = new NaturezaOperacaoDTOWeb();
            BeanUtil.copiarValores((Object)naturezaOperacao, (Object)dto, (boolean)false, null);
            return dto;
        }).collect(Collectors.toList());
    }

    @DBAutoCommit
    public boolean validCode(String value) throws UnicoMensagemUsuarioException {
        NaturezaOperacaoRN.getInstance().validarCodigoCfop(value, SessaoUtil.getSessao().getFilial());
        return super.validCode(value);
    }

    @RequestMapping(value={"/validar-nao-contribuinte-icms"})
    @DBAutoCommit
    public boolean validarCodigoBarra(@RequestParam(value="idCfopContribuinte") Long idCfopContribuinte, @RequestParam(value="codigoCfop") String codigoCfop) throws UnicoMensagemUsuarioException {
        NaturezaOperacao naturezaOperacaoContribuinte;
        if (!Util.longNullOuZero((Long)idCfopContribuinte) && (naturezaOperacaoContribuinte = NaturezaOperacaoRN.getInstance().buscarPorId(idCfopContribuinte)) != null) {
            String prefixoCFOP;
            String codigoNaoContribuinte = naturezaOperacaoContribuinte.getCodigo();
            if (!codigoNaoContribuinte.startsWith(prefixoCFOP = codigoCfop.substring(0, 1))) {
                throw new UnicoMensagemUsuarioException("WWW448", "A natureza de opera\u00e7\u00e3o n\u00e3o contribuinte de ICMS deve ter prefixo " + prefixoCFOP + ".");
            }
            if (codigoCfop.equals(codigoNaoContribuinte)) {
                throw new UnicoMensagemUsuarioException("WWW11", "N\u00e3o \u00e9 poss\u00edvel selecionar a mesma natureza de opera\u00e7\u00e3o.");
            }
        }
        return true;
    }

    @RequestMapping(value={"/filtrar-prefixo"})
    @DBAutoCommit
    public List<NaturezaOperacao> filtrarPorPrefixo(@RequestParam String prefixo, @RequestParam(required=false) String query, @RequestParam(defaultValue="6") int limit) {
        return NaturezaOperacaoRN.getInstance().getNaturezasPorPrefixoAutoCompleteTypeWeb(SessaoUtil.getSessao(), prefixo, query, limit);
    }

    @RequestMapping(value={"/validar-controle-perda"})
    @DBAutoCommit
    public boolean validarCfopControlePerda(@RequestParam Long idCfop) throws UnicoMensagemUsuarioException {
        NaturezaOperacaoRN.getInstance().validarCfopControlePerda(idCfop);
        return true;
    }

    @RequestMapping(value={"/validar-servico-transporte"})
    @DBAutoCommit
    public boolean validarCfopServicoTransporte(@RequestParam Long idCfop) throws UnicoMensagemUsuarioException {
        if (!Util.longNullOuZero((Long)idCfop)) {
            List cfopsPermitidasModelo07 = Stream.of(NaturezaOperacaoConhecimentoTransporte.values()).map(NaturezaOperacaoConhecimentoTransporte::getCodigo).collect(Collectors.toList());
            boolean codigoValido = NaturezaOperacaoRN.getInstance().codigoExistsIn(cfopsPermitidasModelo07, idCfop);
            if (!codigoValido) {
                throw new UnicoMensagemUsuarioException("WNTF563", "CFOP inv\u00e1lida para o modelo 7 - " + ModeloNotaFiscal.NOTA_FISCAL_SERVICO_TRANSPORTE.getDescricao() + ".\nValores v\u00e1lidos: " + cfopsPermitidasModelo07);
            }
        }
        return true;
    }

    @RequestMapping(value={"/interna-externa"})
    @DBAutoCommit
    public List<NaturezaOperacao> getGridCFOPInternaExternaPropriedade(@RequestParam boolean interna) {
        return NaturezaOperacaoRN.getInstance().getListaCFOPInternaExternaWeb(SessaoUtil.getSessao(), interna, TipoMovimento.SAIDA, "", 1000);
    }

    @RequestMapping(value={"/descricao-default"})
    @DBAutoCommit
    public String buscarDescricaoPadrao(@RequestParam String codigo) {
        return CfopPadraoRN.getInstance().buscarDescricao(codigo);
    }

    protected GridBuilder<NaturezaOperacaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 120, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("tributacaoEspecial", "Trib. especial", 120, true));
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 372)) {
            colunas.add(new ColunaSQL("nome", "nomeOp", "Opera\u00e7\u00e3o fiscal", 120, true, new String[]{"fk_cfop_operacaofiscal"}));
            colunas.add(new ColunaSQL("nome", "nomeEstado", "Estado origem", 120, true, new String[]{"fk_cfop_estadoorigem"}));
        }
        GridBuilder grid = new GridBuilder(NaturezaOperacaoRN.getInstance().getTabela(), colunas);
        grid.addOrdem(new Ordem("codigo"));
        return grid;
    }

    protected void beforeSave(NaturezaOperacao naturezaOperacao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        naturezaOperacao.setCstcofins(naturezaOperacao.getCstpis());
        naturezaOperacao.setCstCofinsEntrada(naturezaOperacao.getCstPisEntrada());
        if (!Util.longNullOuZero((Long)naturezaOperacao.getId()) && naturezaOperacao.isConsideraDevolucaoVenda() && !naturezaOperacao.getFinalidadeEmissaoNfe().equals((Object)FinalidadeEmissaoNfeCFOP.DEVOLUCAO_VENDA)) {
            naturezaOperacao.setConsideraDevolucaoVenda(false);
        }
        this.carregarEnunsCfopTributacao(naturezaOperacao.getEstados());
        if (!Util.listNullOrEmpty((List)naturezaOperacao.getEstados())) {
            for (CfopEstado cfopEstado : naturezaOperacao.getEstados()) {
                if (Util.longNullOuZero((Long)cfopEstado.getId()) || cfopEstado.getId() < 0L) {
                    this.verificarSeTemIcmsEstado(cfopEstado);
                }
                BeneficioFiscalRN.getInstance().validarBeneficioPorCST(SessaoUtil.getSessao().getFilial(), cfopEstado.getIdBeneficioFiscal(), cfopEstado.getSt(), null);
            }
        }
        this.carregarEnunsCfopTributacao(naturezaOperacao.getIncentivosFiscais());
        if (!Util.listNullOrEmpty((List)naturezaOperacao.getIncentivosFiscais())) {
            for (CfopIncentivoFiscal incentivoFiscal : naturezaOperacao.getIncentivosFiscais()) {
                if (Util.longNullOuZero((Long)incentivoFiscal.getId()) || incentivoFiscal.getId() < 0L) {
                    this.verificarSeTemIncentivoFiscal(incentivoFiscal);
                }
                BeneficioFiscalRN.getInstance().validarBeneficioPorCST(SessaoUtil.getSessao().getFilial(), incentivoFiscal.getIdBeneficioFiscal(), incentivoFiscal.getSt(), null);
            }
        }
        if (Util.listNullOrEmpty((List)naturezaOperacao.getImpostosIncentivados())) {
            if (!Util.longNullOuZero((Long)naturezaOperacao.getId())) {
                List impostosGravados = NaturezaOperacaoIncentivoImpostoRN.getInstance().buscarPorNaturezaOperacao(naturezaOperacao.getId());
                naturezaOperacao.setImpostosIncentivados(impostosGravados);
            }
        } else {
            for (NaturezaOperacaoIncentivoImposto natImp : naturezaOperacao.getImpostosIncentivados()) {
                if (Util.longNullOuZero((Long)natImp.getId()) || natImp.getId() < 0L) {
                    this.validarImpostoIncentivado(natImp);
                }
                this.carregarCstIncentivoImposto(natImp);
            }
        }
    }

    protected String getCacheId() {
        return "naturezas-operacao";
    }

    private void carregarEnunsCfopTributacao(List<?> listTributacao) {
        if (listTributacao != null) {
            block0: for (Object obj : listTributacao) {
                CfopTributacao trib = (CfopTributacao)obj;
                if (SessaoUtil.getSessao().getFilial().isSimplesNacional()) {
                    for (CstSNICMS cstSNICMS : CstSNICMS.values()) {
                        if (!cstSNICMS.name().equals(trib.getSt())) continue;
                        trib.setSt(cstSNICMS.getId());
                        continue block0;
                    }
                    continue;
                }
                for (CstSNICMS cstSNICMS : CstICMS.values()) {
                    if (!cstSNICMS.name().equals(trib.getSt())) continue;
                    trib.setSt(cstSNICMS.getId());
                    continue block0;
                }
            }
        }
    }

    private void carregarCstIncentivoImposto(NaturezaOperacaoIncentivoImposto imposto) {
        boolean isIcms = imposto.getTipoImposto().equals((Object)TipoImpostoIncentivado.ICMS);
        if (isIcms) {
            for (CstICMS cst : CstICMS.values()) {
                if (!cst.name().equalsIgnoreCase(imposto.getCst())) continue;
                imposto.setCst(cst.getId());
                break;
            }
            imposto.setMotivoDesoneracaoPisCofins(null);
        } else {
            for (CstPisCofins cst : CstPisCofins.values()) {
                if (!cst.name().equalsIgnoreCase(imposto.getCst())) continue;
                imposto.setCst(cst.getId());
                break;
            }
            imposto.setMotivoDesoneracaoIcms(null);
        }
    }

    private void validarImpostoIncentivado(NaturezaOperacaoIncentivoImposto impostoIncentivado) throws UnicoMensagemUsuarioException {
        TipoImpostoIncentivado tipoImposto = impostoIncentivado.getTipoImposto();
        if (tipoImposto == null) {
            throw new UnicoMensagemUsuarioException("WWW147", "Tipo imposto n\u00e3o informado!");
        }
        boolean isIcms = TipoImpostoIncentivado.ICMS.equals((Object)tipoImposto);
        MotivoDesoneracaoIcms motivoIcms = impostoIncentivado.getMotivoDesoneracaoIcms();
        MotivoDesoneracaoPisCofins motivoPisCofins = impostoIncentivado.getMotivoDesoneracaoPisCofins();
        if (isIcms && motivoIcms == null || !isIcms && motivoPisCofins == null) {
            throw new UnicoMensagemUsuarioException("WWW143", "Motivo n\u00e3o informado!");
        }
        boolean isSuframa = MotivoDesoneracaoPisCofins.SUFRAMA.equals((Object)motivoPisCofins) || MotivoDesoneracaoIcms.SUFRAMA.equals((Object)motivoIcms);
        Long idIncentivoFiscal = impostoIncentivado.getIdIncentivoFiscal();
        if (isSuframa && Util.longNullOuZero((Long)idIncentivoFiscal)) {
            throw new UnicoMensagemUsuarioException("WWW144", "Zona Franca/ALC n\u00e3o informada!");
        }
        Long idEstado = impostoIncentivado.getIdEstado();
        if (!isSuframa && Util.longNullOuZero((Long)idEstado)) {
            throw new UnicoMensagemUsuarioException("WWW145", "Estado n\u00e3o informado!");
        }
        if (Util.stringNullOrEmpty((String)impostoIncentivado.getCst())) {
            throw new UnicoMensagemUsuarioException("WWW449", "CST n\u00e3o informada!");
        }
        List impostosGravados = NaturezaOperacaoIncentivoImpostoRN.getInstance().buscarPorNaturezaOperacao(impostoIncentivado.getIdNaturezaOperacao());
        for (NaturezaOperacaoIncentivoImposto impostoGravado : impostosGravados) {
            boolean isSuframaMesmoIncentivo;
            if (impostoGravado.equals((Object)impostoIncentivado) || !impostoGravado.getTipoImposto().equals((Object)tipoImposto)) continue;
            boolean isSuframaGravado = MotivoDesoneracaoPisCofins.SUFRAMA.equals((Object)impostoGravado.getMotivoDesoneracaoPisCofins()) || MotivoDesoneracaoIcms.SUFRAMA.equals((Object)impostoGravado.getMotivoDesoneracaoIcms());
            boolean bl = isSuframaMesmoIncentivo = isSuframa && isSuframaGravado && impostoGravado.getIdIncentivoFiscal().equals(idIncentivoFiscal);
            if (isSuframaMesmoIncentivo) {
                throw new UnicoMensagemUsuarioException("WWW148", "Zona Franca/ALC j\u00e1 informada!");
            }
            boolean naoSuframaMesmoEstado = !isSuframa && !isSuframaGravado && impostoGravado.getIdEstado().equals(idEstado);
            if (!naoSuframaMesmoEstado) continue;
            throw new UnicoMensagemUsuarioException("WWW149", "Estado j\u00e1 informado!");
        }
    }

    private void verificarSeTemIcmsEstado(CfopEstado cfopEstado) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)cfopEstado.getIdEstado())) {
            throw new UnicoMensagemUsuarioException("WWW156", "Por favor, informe o estado.");
        }
        if (!Util.longNullOuZero((Long)cfopEstado.getIdCfopPai())) {
            List estados = CfopEstadoCommonRN.getInstance().buscarPorIdNaturezaOperacao(cfopEstado.getIdCfopPai());
            for (CfopEstado estado : estados) {
                if (!estado.getIdEstado().equals(cfopEstado.getIdEstado())) continue;
                throw new UnicoMensagemUsuarioException("WWW450", "Estado " + cfopEstado.getCodigoEstado() + " j\u00e1 configurado!");
            }
        }
    }

    private void verificarSeTemIncentivoFiscal(CfopIncentivoFiscal cfopIncentivoFiscal) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)cfopIncentivoFiscal.getIdIncentivofiscal())) {
            throw new UnicoMensagemUsuarioException("WWW157", "Por favor, informe a Zona Franca/ALC.");
        }
        if (!Util.longNullOuZero((Long)cfopIncentivoFiscal.getIdCfopPai())) {
            List incentivoFiscais = CfopEstadoRN.getInstance().buscarPorIdNaturezaOperacao(cfopIncentivoFiscal.getIdCfopPai());
            for (CfopIncentivoFiscal imposto : incentivoFiscais) {
                if (!imposto.getIdIncentivofiscal().equals(cfopIncentivoFiscal.getIdIncentivofiscal())) continue;
                throw new UnicoMensagemUsuarioException("WWW451", "Zona Franca/ALC " + cfopIncentivoFiscal.getNomeIncentivoFiscal() + " j\u00e1 configurada.");
            }
        }
    }
}

