/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.nfce;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscal;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscalFactory;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ModeloImpressoraNaoFiscal;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Visao;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.dicionario.paf.OperacaoNfceVW;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.Pagamento;
import br.intelidata.commons.domain.pojo.ParametroNfceSat;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.VendaNfce;
import br.intelidata.commons.domain.pojo.VendaNfceDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoFinalizador;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusNfce;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoOperacao;
import br.intelidata.commons.domain.pojo.notafiscal.AbstractDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.pafecf.FechamentoPdv;
import br.intelidata.commons.domain.pojo.pafecf.Finalizador;
import br.intelidata.commons.domain.pojo.pafecf.InutilizacaoNfce;
import br.intelidata.commons.domain.regranegocio.EntidadeCommonRN;
import br.intelidata.commons.domain.regranegocio.FechamentoPdvCommonRN;
import br.intelidata.commons.domain.regranegocio.GridControleVisaoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.VendaNfceDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.BancoRN;
import br.intelidata.commons.modulo.pdv.dao.ColunaCustomizavelPagamentoNFCe;
import br.intelidata.commons.modulo.pdv.regranegocio.AlteraMeioPagamentoOperacao;
import br.intelidata.commons.modulo.pdv.regranegocio.FinalizadorRN;
import br.intelidata.commons.modulo.pdv.regranegocio.InutilizacaoNfceRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoNfceRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.PagamentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TabelaConfigurada;
import br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.NfceSatCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.NfceUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.nfce.RetornoConsultaNfceWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.nfce.GeraDanfeNfce;
import unipaf.nfce.ImpressaoDanfe;
import unipaf.nfce.ImpressaoDanfePDF;
import unipaf.pojo.nfce.DanfeNfce;
import unipaf.servidor.nfce.AutorizacaoPendenciaNfce;

@RestController
@RequestMapping(value={"/api/nfces"})
@SubMenuMapping(MENU="SubMenuPdvFiscal", NOME="Consulta NFC-e", ROTA="/pdvs/nfces", PROGRAMA=1000032, ICONE="icon icon-date")
public class NfceCrudController
extends NfceSatCrudController {
    public NfceCrudController(ResponseEntityService responseEntityService) {
        super(responseEntityService);
    }

    @RequestMapping(value={"/imprimir-impressora-termica"})
    @DBAutoCommit
    public String imprimir(@RequestParam Long idOperacao, @RequestParam ModeloImpressoraNaoFiscal modelo, @RequestParam String pagina, @RequestParam boolean removeAcentos, @RequestParam int linhas) throws UnicoMensagemUsuarioException {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        Filial filial = (Filial)FilialRN.getInstance().buscarPorCodigo(operacao.getFilial());
        DanfeNfce danfe = new GeraDanfeNfce().getDanfe(idOperacao);
        ImpressoraNaoFiscal inf = ImpressoraNaoFiscalFactory.getImpressora((ModeloImpressoraNaoFiscal)modelo);
        ImpressaoDanfe impressao = new ImpressaoDanfe(danfe, inf.getColunas());
        inf.setNaoCriarPrintService(true);
        inf.setRemoveAcentos(removeAcentos);
        inf.inicializa("", linhas, pagina, true);
        inf.setCabecalho(ImpressaoDanfePDF.getCabecalhoPadrao((Filial)filial));
        inf.setLogoTipo(NfceUtil.getLogoTipo((ParametroNfceSat)filial.getParametroNfceSat()));
        return Base64.getEncoder().encodeToString(inf.getBytesImpressao(impressao.getDanfe().toString()));
    }

    protected GridBuilder<GridControleVisaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("data", "data_filtro", "Data", 0, false, new String[0]));
        colunas.add(new ColunaSQL("modeloNfce", "modeloNfce", 0, false));
        colunas.add(new ColunaSQL("serienfce", "serienfce_filtro", "serienfce", 0, false, new String[0]));
        colunas.add(new ColunaSQL("numeronfce", "numeronfce_filtro", "numeronfce", 0, false, new String[0]));
        colunas.add(new ColunaSQL("filial", "filial_filtro"));
        colunas.add(new ColunaSQL("numerosubstituido", "numerosubstituido"));
        colunas.add(new ColunaSQL("serienfce", "S\u00e9rie", 60, true));
        colunas.add(new ColunaSQL("numeronfce", "N\u00famero", 75, true));
        colunas.add(new ColunaSQL("horafinal", "Emiss\u00e3o", 100, true));
        colunas.add(new ColunaSQL("pdv", "Pdv", 50, true));
        colunas.add(new ColunaSQL("chaveacessonfce", "Chave de acesso", 290, true));
        colunas.add(new ColunaSQL("tipoambientenfce", "Ambiente", 130, true));
        colunas.add(new ColunaSQL("formaemissaonfce", "Forma emiss\u00e3o", 190, true));
        colunas.add(new ColunaSQL("statusnfce", "Status", 180, true));
        colunas.add(new ColunaSQL("numeroprotocolonfce", "Protocolo", 110, true));
        colunas.add(new ColunaSQL("numeronfcependente", "N\u00famero substituido", 75, true));
        colunas.add(new ColunaSQL("tempoautorizacao", "Tempo Aut.", 90, true));
        ColunaSQL colunaStatusNfceID = new ColunaSQL("statusnfce", "statusnfce_id");
        colunaStatusNfceID.setNaoAlterarValorEnum(true);
        colunas.add(colunaStatusNfceID);
        ColunaSQL tipo = new ColunaSQL("tipo", "tipo", 0, false);
        tipo.setClasseEnum(TipoOperacao.class);
        colunas.add(tipo);
        GridControleVisaoRN visaoRN = new GridControleVisaoRN((Visao)new OperacaoNfceVW());
        GridBuilder grid = new GridBuilder(visaoRN.getTabela(), colunas, new ArrayList(), "operacaonfce_v1_web", true);
        grid.addCodicaoDefault(new Condicao("modeloNfce", Operador.IGUAL, ModeloNotaFiscal.NOTA_FISCAL_CONSUMIDOR_ELETRONICA.getId()));
        grid.addCodicaoDefault(new Condicao("filial_filtro", Operador.IGUAL, SessaoUtil.getSessao().getCodigoFilial()));
        grid.addOrdem(new Ordem("data_filtro"));
        grid.addOrdem(new Ordem("modeloNfce"));
        grid.addOrdem(new Ordem("serienfce_filtro"));
        grid.addOrdem(new Ordem("numeronfce_filtro"));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPagamentoNFCe(SessaoUtil.getSessao()));
        return grid;
    }

    @RequestMapping(value={"/consultar-nfce"})
    @DBTransaction
    public RetornoConsultaNfceWrapper consultarNfce(@RequestParam Long idOperacao, @RequestParam int numSubstituido) {
        Operacao nfce;
        boolean substituido;
        boolean bl = substituido = numSubstituido == 1;
        if (substituido) {
            nfce = OperacaoNfceRN.getInstance().buscarNfceSubstituida(idOperacao);
            if (nfce == null) {
                nfce = OperacaoNfceRN.getInstance().criarOperacaoSubstituida((Operacao)OperacaoNfceRN.getInstance().buscarPorId(idOperacao));
            }
        } else {
            nfce = (Operacao)OperacaoNfceRN.getInstance().buscarPorId(idOperacao);
        }
        String msg = "Consultar o status da NFC-e " + nfce.getSerieNfce() + "/" + nfce.getNumeroNfce() + " no sistema do SEFAZ";
        return new RetornoConsultaNfceWrapper(msg, nfce.getId());
    }

    @RequestMapping(value={"/gerar-parcelas"})
    @DBAutoCommit
    public List<VendaNfceDocumentoFinanceiro> gerarParcelas(@RequestParam Long idCondicaoPagamento, @RequestParam BigDecimal total, @RequestParam(required=false) boolean isSaida, @RequestParam(required=false) Long idEntidade, @RequestParam Long idTipoDocumentoFinanceiro, @RequestParam(required=false) String dataPedido, @RequestParam String dataEmissao, @RequestParam(required=false, defaultValue="0") int diaFaturamentoContrato, @RequestParam(required=false) String dataVencimentoContrato) throws UnicoMensagemUsuarioException {
        Finalizador finalizador = (Finalizador)FinalizadorRN.getInstance().buscarPorId(idTipoDocumentoFinanceiro);
        total = total.setScale(2, RoundingMode.HALF_EVEN);
        return VendaNfceDocumentoFinanceiroRN.getInstance().gerarParcelas(idCondicaoPagamento, total, isSaida, idEntidade, Long.valueOf(finalizador.getTipoDocumentoRetaguarda()), null, DataHoraFactory.string2LocalDate((String)dataEmissao, (String)"dd/MM/yyyy"), diaFaturamentoContrato, null, SessaoUtil.getSessao().getFilial(), null);
    }

    @RequestMapping(value={"/validar-alterar-meio-pagamento"})
    @DBAutoCommit
    public String validarAlterarMeioPagamento(@RequestParam Long idOperacao) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamentoPdv;
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        if (operacao.getTipo() != TipoOperacao.VENDA) {
            throw new UnicoMensagemUsuarioException("WPDV1395", "N\u00e3o \u00e9 poss\u00edvel alterar os meios de pagamento deste tipo de opera\u00e7\u00e3o.");
        }
        if (operacao.getStatusNfce() != StatusNfce.AUTORIZADA && operacao.getStatusNfce() != StatusNfce.EMITIDA_EM_CONTIGENCIA && operacao.getStatusNfce() != StatusNfce.CONTIGENCIA_REJEITADA) {
            throw new UnicoMensagemUsuarioException("WPDV1332", "Status n\u00e3o permitido para alterar o meio de pagamento.");
        }
        if (!Util.longNullOuZero((Long)operacao.getIdFechamento()) && !operacao.isFechamentoLocal() && (fechamentoPdv = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorId(operacao.getIdFechamento())) != null && fechamentoPdv.isFechado()) {
            throw new UnicoMensagemUsuarioException("WPDV1339", "O controle de fechamento c\u00f3digo " + fechamentoPdv.getCodigo() + " j\u00e1 foi fechado.");
        }
        if (!Util.longNullOuZero((Long)operacao.getIdRps())) {
            throw new UnicoMensagemUsuarioException("WPDV1337", "N\u00e3o \u00e9 permitido alterar venda com RPS.");
        }
        if (operacao.getTipo() == TipoOperacao.RESGATE_CARTAO_FIDELIDADE) {
            throw new UnicoMensagemUsuarioException("WPDV1345", "N\u00e3o \u00e9 permitido alterar resgate do cart\u00e3o fidelidade");
        }
        List pagamentos = PagamentoRN.getInstance().buscarListaPorOperacao(operacao.getId());
        for (Pagamento pagamento : pagamentos) {
            Finalizador finalizador = FinalizadorRN.getInstance().buscarPorCodigo(pagamento.getFinalizador());
            if (finalizador == null || finalizador.isCompativelComRetaguarda()) continue;
            throw new UnicoMensagemUsuarioException("WPDV1338", String.join((CharSequence)"", "N\u00e3o \u00e9 poss\u00edvel alterar opera\u00e7\u00e3o com meio de pagamento ", finalizador.getNome(), "."));
        }
        String retorno = "Alterar meio de pagamento ";
        retorno = operacao.getModeloNfce().equals(ModeloNotaFiscal.NOTA_FISCAL_CONSUMIDOR_ELETRONICA.getId()) ? retorno + "NFC-e " + operacao.getSerieNfce() + "/" + operacao.getNumeroNfce() : retorno + "CF-e " + operacao.getNumeroNfce();
        return retorno;
    }

    @PostMapping(value={"/gravar-alterar-meio-pagamento"})
    @DBAutoCommit
    public void gravarAlterarMeioPagamento(@RequestBody VendaNfce vendaNfce) throws UnicoMensagemUsuarioException {
        Entidade cliente;
        BigDecimal totalFinanceiro;
        List documentosFinanceirosGerados = vendaNfce.getDocumentosFinanceiros().stream().filter(doc -> doc.getTipoPOS() == null).collect(Collectors.toList());
        BigDecimal valorParaParcelar = documentosFinanceirosGerados.stream().map(AbstractDocumentoFinanceiro::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (valorParaParcelar.compareTo(totalFinanceiro = vendaNfce.getAPrazo().subtract(vendaNfce.getPosAPrazo())) != 0) {
            throw new UnicoMensagemUsuarioException("WPDV1335", "Total das parcelas n\u00e3o \u00e9 igual ao valor a prazo. Verifique.");
        }
        boolean geraFinanceiro = valorParaParcelar.compareTo(BigDecimal.ZERO) > 0 || vendaNfce.getCheque().compareTo(BigDecimal.ZERO) > 0;
        Sessao sessao = SessaoUtil.getSessao();
        Entidade entidade = cliente = !NumberUtil.longNullOuZero((Long)vendaNfce.getIdCliente()) ? (Entidade)EntidadeRN.getInstance().buscarPorId(vendaNfce.getIdCliente()) : null;
        if (cliente == null) {
            if (geraFinanceiro) {
                throw new UnicoMensagemUsuarioException("WPDV1336", "Informe um cliente.");
            }
        } else {
            EntidadeCommonRN.getInstance().permiteVender(sessao, cliente, true, true);
        }
        Long idFinalizador = vendaNfce.getIdTipoDocumentoFinanceiro();
        Finalizador finalizador = (Finalizador)FinalizadorRN.getInstance().buscarPorId(idFinalizador);
        if (finalizador != null && finalizador.getTipoDocumento() == TipoDocumentoFinalizador.CHEQUE) {
            boolean exigirDadosCheque = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 396);
            for (VendaNfceDocumentoFinanceiro vndf : documentosFinanceirosGerados) {
                if (Util.stringNullOrEmpty((String)vndf.getCodigoBanco())) {
                    throw new UnicoMensagemUsuarioException("WPDV1340", "Informe o n\u00famero do banco do cheque.");
                }
                Banco banco = (Banco)BancoRN.getInstance().buscarPorCodigo(vndf.getCodigoBanco());
                if (banco == null) {
                    throw new UnicoMensagemUsuarioException("WPDV1341", "Banco " + vndf.getCodigoBanco() + " informado no cheque n\u00e3o encontrado.");
                }
                if (exigirDadosCheque && Util.stringNullOrEmpty((String)vndf.getAgencia())) {
                    throw new UnicoMensagemUsuarioException("WPDV1342", "Informe a ag\u00eancia do cheque.");
                }
                if (exigirDadosCheque && Util.stringNullOrEmpty((String)vndf.getNumeroContaCorrente())) {
                    throw new UnicoMensagemUsuarioException("WPDV1343", "Informe o n\u00famero da conta do cheque.");
                }
                if (!Util.stringNullOrEmpty((String)vndf.getNumeroCheque())) continue;
                throw new UnicoMensagemUsuarioException("WPDV1344", "Informe o n\u00famero do cheque.");
            }
        }
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(vendaNfce.getIdOperacao());
        vendaNfce.setIdFinalizador(vendaNfce.getIdTipoDocumentoFinanceiro());
        new AlteraMeioPagamentoOperacao(sessao).alterar(operacao, vendaNfce, vendaNfce.getDocumentosFinanceiros(), cliente);
    }

    @RequestMapping(value={"/consultar-sefaz"})
    @DBTransaction
    public void consultarSefaz(@RequestParam Long idOperacao) throws UnicoMensagemUsuarioException {
        AutorizacaoPendenciaNfce.getInstance().consultarRetaguarda(idOperacao);
    }

    protected String getCacheId() {
        return "nfces".concat("_").concat("_FILIAL=(").concat(SessaoUtil.getSessao().getCodigoFilial()).concat(")");
    }

    protected void beforeRead(Operacao operacao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        InutilizacaoNfce inut;
        super.beforeRead(operacao, modo, parentId);
        if (!Util.stringNullOrEmpty((String)operacao.getNumeroNfcePendente()) && operacao.getStatusNfcePendente() == StatusNfce.NUMERACAO_INUTILIZADA && (inut = InutilizacaoNfceRN.getInstance().buscarPorNumero(operacao.getFilial(), operacao.getSerieNfcePendente(), operacao.getNumeroNfcePendente(), operacao.getTipoAmbienteNfce())) != null) {
            operacao.setProtocoloInutilizacaoPendente(inut.getNumeroProtocolo());
            operacao.setDataInutilizacaoPendente(inut.getData());
        }
        operacao.setVendedor(OperacaoRN.getInstance().buscarVendedorPorCupomWeb(operacao.getId()));
        if (!StringUtil.stringNullOrEmpty((String)operacao.getUsuario())) {
            Usuario usuario = UsuarioRN.getInstance().buscarPorCodigo(operacao.getUsuario());
            operacao.setIdUsuario(Long.valueOf(usuario != null ? usuario.getId() : 0L));
        }
        if (!StringUtil.stringNullOrEmpty((String)operacao.getCliente())) {
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorCodigo(operacao.getCliente());
            operacao.setIdCliente(Long.valueOf(entidade != null ? entidade.getId() : 0L));
        }
        if (!NumberUtil.longNullOuZero((Long)operacao.getIdUsuarioAlteracaoMP())) {
            String nome = (String)UsuarioRN.getInstance().buscarValorPorID(operacao.getIdUsuarioAlteracaoMP(), "nome");
            operacao.setNomeUsuarioAlteracaoMP(nome);
        }
    }

    protected List<TabelaConfigurada> getTabelasConfiguracaoRelatorio() {
        return Arrays.asList(new TabelaConfigurada("operacao_nfce_view", "NFC-e"), new TabelaConfigurada("vendas_itens_view", "Itens de venda"));
    }

    protected void afterLoadColunaSQL(List<ColunaSQL> colunas) throws UnicoMensagemUsuarioException {
        for (ColunaSQL coluna : colunas) {
            if (!coluna.getNome().equalsIgnoreCase("valorliquido") && !coluna.getNome().equalsIgnoreCase("valorbruto")) continue;
            coluna.setTotalizar(true);
        }
    }

    @RequestMapping(value={"/buscar-rastreabilidade"})
    @DBAutoCommit
    public List buscarRastreabilidade(Long idOrigem) {
        return OperacaoRN.getInstance().buscarListaRastreabilidadeNfce(idOrigem);
    }
}

