/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.uboleto.enums.InstrucaoCobranca;
import br.intelidata.commons.core.util.IFileStorage;
import br.intelidata.commons.core.util.InputStreamDataSource;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.TipoNotificacao;
import br.intelidata.commons.core.util.UnicoByteArrayDataSource;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.CartaCorrecao;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.enuns.AnexoEmailNfe;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteCarteiraRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.GeraBoletoRNSimplificada;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.nfse.NfseManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CartaCorrecaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ArquivoFiscalWeb;
import br.intelidata.uniplusweb.service.WhatsAppService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobExecutorService;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalCompartilhamentoComponent;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.NotaFiscalTransmissaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.wrapper.CompartilhamentoRetornoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.wrapper.DadosBoletoCompartilhamento;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.wrapper.ExcecaoCompartilhamentoWrapper;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.activation.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotaFiscalCompartilhamentoComponent {
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private JobExecutorService jobExecutorService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private ArquivoFiscalWeb arquivoFiscalWeb;

    public List<ExcecaoCompartilhamentoWrapper> agendarEnvioEmail(Sessao sessao, List<NotaFiscal> notasAutorizadas, NotaFiscalTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Map<Long, List<NotaFiscal>> mapNotasPorCliente;
        ArrayList<ExcecaoCompartilhamentoWrapper> excecoes = new ArrayList<ExcecaoCompartilhamentoWrapper>();
        if (!ListMapUtil.listNullOrEmpty(notasAutorizadas) && !ListMapUtil.mapNullOrEmpty(mapNotasPorCliente = notasAutorizadas.stream().collect(Collectors.groupingBy(NotaFiscal::getIdEntidade)))) {
            for (Map.Entry<Long, List<NotaFiscal>> entry : mapNotasPorCliente.entrySet()) {
                String email;
                Long idCliente = entry.getKey();
                List<NotaFiscal> notasCliente = entry.getValue();
                Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
                if (entidade == null) continue;
                if (!StringUtil.stringNullOrEmpty((String)entidade.getEmailFaturamento())) {
                    email = entidade.getEmailFaturamento();
                } else if (!StringUtil.stringNullOrEmpty((String)entidade.getEmail())) {
                    email = entidade.getEmail();
                } else {
                    String excecao = entidade.toString().concat(" - Notas fiscais: ").concat(notasCliente.stream().map(NotaFiscal::getNumeroNotaFiscal).collect(Collectors.joining(","))).concat(".");
                    excecoes.add(new ExcecaoCompartilhamentoWrapper(excecao, TipoNotificacao.EMAIL));
                    this.notificationService.notifyUser("N\u00e3o foi poss\u00edvel enviar o e-mail, cliente sem e-mail configurado.".concat(excecao), TipoNotificacaoSimples.ERROR);
                    continue;
                }
                ArrayList<String> emailCC = new ArrayList<String>();
                if (!StringUtil.stringNullOrEmpty((String)entidade.getEmailFaturamentoCopia())) {
                    emailCC.add(entidade.getEmailFaturamentoCopia());
                }
                for (NotaFiscal notaFiscal : notasCliente) {
                    String emailTransportadora;
                    if (!(NumberUtil.longNullOuZero((Long)notaFiscal.getIdTransportadora()) || StringUtil.stringNullOrEmpty((String)(emailTransportadora = EntidadeRN.getInstance().buscarEmailTransportadoraWeb(notaFiscal.getIdTransportadora()))) || emailCC.contains(emailTransportadora))) {
                        emailCC.add(emailTransportadora);
                    }
                    DadosBoletoCompartilhamento dadosBoleto = new DadosBoletoCompartilhamento(wrapper.getIdContaCorrente(), wrapper.getIdCarteira(), wrapper.getInstrucao(), wrapper.getNumeroDiasInstrucao().intValue(), wrapper.getPercentualDescontoPagamentoAteVencimento(), wrapper.getObservacao());
                    Notificacao notificacao = new Notificacao();
                    if (NotaFiscalRN.getInstance().isNfe(notaFiscal)) {
                        this.montarDadosNFe(sessao, notaFiscal, dadosBoleto, notificacao);
                    } else if (NotaFiscalRN.getInstance().isNfse(notaFiscal)) {
                        this.montarDadosNFSe(sessao, notaFiscal, dadosBoleto, notificacao);
                    }
                    ParametrosEmailWeb parametrosEmail = EmailUtil.getParametros((Sessao)sessao, (String)email, (String)String.join((CharSequence)";", emailCC), (String)this.getAssunto(notaFiscal), (String)NotaFiscalRN.getInstance().getMensagemCompartilhamentoNFe(sessao.getFilial(), notaFiscal, null));
                    parametrosEmail.setAnexos(notificacao.getDataSources());
                    CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "NF-e - ".concat(notaFiscal.getNumeroNotaFiscal()));
                    taskEmail.createTask((Object)parametrosEmail, parametrosEmail.getAssunto());
                }
            }
        }
        return excecoes;
    }

    public void enviarWhatsApp(Sessao sessao, List<NotaFiscal> notasAutorizadas, CompartilhamentoRetornoWrapper compartilhamentoRetorno, NotaFiscalTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Map<Long, List<NotaFiscal>> mapNotasPorCliente;
        if (!ListMapUtil.listNullOrEmpty(notasAutorizadas) && !ListMapUtil.mapNullOrEmpty(mapNotasPorCliente = notasAutorizadas.stream().collect(Collectors.groupingBy(NotaFiscal::getIdEntidade)))) {
            ArrayList<Notificacao> notificacoes = new ArrayList<Notificacao>();
            for (Map.Entry<Long, List<NotaFiscal>> entry : mapNotasPorCliente.entrySet()) {
                Long idCliente = entry.getKey();
                List<NotaFiscal> notasCliente = entry.getValue();
                Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
                if (entidade == null) continue;
                String celular = entidade.getCelular();
                if (StringUtil.stringNullOrEmpty((String)NumberUtil.apenasNumeros((String)celular))) {
                    String excecao = entidade.toString().concat(" - Notas fiscais: ").concat(notasCliente.stream().map(NotaFiscal::getNumeroNotaFiscal).collect(Collectors.joining(","))).concat(".");
                    compartilhamentoRetorno.getExcecoes().add(new ExcecaoCompartilhamentoWrapper(excecao, TipoNotificacao.WHATSAPP));
                    this.notificationService.notifyUser("N\u00e3o foi poss\u00edvel enviar o WhatsApp, cliente sem celular configurado.".concat(excecao), TipoNotificacaoSimples.ERROR);
                    continue;
                }
                compartilhamentoRetorno.setFone(celular);
                for (NotaFiscal notaFiscal : notasCliente) {
                    Notificacao notificacao = new Notificacao();
                    notificacao.setFone(celular);
                    notificacao.setMsg(NotaFiscalRN.getInstance().getMensagemCompartilhamentoNFe(sessao.getFilial(), notaFiscal, null, TipoNotificacao.WHATSAPP));
                    DadosBoletoCompartilhamento dadosBoleto = new DadosBoletoCompartilhamento(wrapper.getIdContaCorrente(), wrapper.getIdCarteira(), wrapper.getInstrucao(), wrapper.getNumeroDiasInstrucao().intValue(), wrapper.getPercentualDescontoPagamentoAteVencimento(), wrapper.getObservacao());
                    this.montarDadosNFe(sessao, notaFiscal, dadosBoleto, notificacao);
                    notificacoes.add(notificacao);
                }
            }
            if (!ListMapUtil.listNullOrEmpty(notificacoes)) {
                String msg = this.whatsAppService.enviarWhatsApp(notificacoes, sessao);
                if (StringUtil.stringNullOrEmpty((String)msg)) {
                    this.notificationService.notifyUser("WhatsApp enviado com sucesso.", TipoNotificacaoSimples.ERROR);
                }
                compartilhamentoRetorno.setMensagem(msg);
            }
        }
    }

    private String getAssunto(NotaFiscal notaFiscal) {
        String nomeEmpresa = SessaoUtil.getSessao().getFilial().getRazaoSocialCompleta();
        String assunto = NotaFiscalRN.getInstance().isNfse(notaFiscal) ? "Nota fiscal de servi\u00e7o eletr\u00f4nica (NFS-e) " : "Nota fiscal eletr\u00f4nica (NF-e) ";
        return assunto.concat(notaFiscal.getNumeroNotaFiscal()).concat(" de ").concat(nomeEmpresa);
    }

    void montarDadosNFSe(Sessao sessao, NotaFiscal notaFiscal, DadosBoletoCompartilhamento dadosBoleto, Notificacao notificacao) throws UnicoMensagemUsuarioException {
        InputStreamDataSource dataSourceXml;
        ArrayList<Object> dataSources = new ArrayList<Object>();
        Malote malote = new Malote();
        String numeroNfse = StringUtil.stringNullOrEmpty((String)notaFiscal.getNumeroNfse()) ? notaFiscal.getNumeroNotaFiscal() : notaFiscal.getNumeroNfse();
        AnexoEmailNfe anexosDoEmail = sessao.getFilial().getParametroNFSE().getAnexoEmailNfse();
        if (anexosDoEmail == null) {
            anexosDoEmail = AnexoEmailNfe.PDF_XML;
        }
        if ((AnexoEmailNfe.PDF_XML.equals((Object)anexosDoEmail) || AnexoEmailNfe.XML.equals((Object)anexosDoEmail) || anexosDoEmail.equals((Object)AnexoEmailNfe.PDF_XML_BOLETO)) && notaFiscal.getArquivoXmlAutorizada() != null) {
            dataSourceXml = new InputStreamDataSource(numeroNfse + ".xml", "text/xml", (InputStream)new ByteArrayInputStream(notaFiscal.getArquivoXmlAutorizada()));
            malote.inclui(numeroNfse + ".xml", notaFiscal.getArquivoXmlAutorizada());
            dataSources.add(dataSourceXml);
        }
        if (anexosDoEmail.equals((Object)AnexoEmailNfe.PDF_XML) || anexosDoEmail.equals((Object)AnexoEmailNfe.PDF) || anexosDoEmail.equals((Object)AnexoEmailNfe.PDF_XML_BOLETO)) {
            byte[] arquivo;
            String linkNfse = null;
            if (sessao.getFilial().getParametroNFSE() != null && sessao.getFilial().getParametroNFSE().isImpressaoNfsePrefeitura()) {
                linkNfse = notaFiscal.getLinkNfse();
            }
            byte[] byArray = arquivo = Util.stringNullOrEmpty(linkNfse) ? new NfseManagerWeb(sessao, null, (IFileStorage)this.arquivoFiscalWeb).imprimirNFSe(notaFiscal.getId(), true).getArquivo() : null;
            if (StringUtil.stringNullOrEmpty(linkNfse)) {
                UnicoByteArrayDataSource dataSourcePDF = new UnicoByteArrayDataSource(arquivo, "NFS-e-" + numeroNfse + ".pdf", "application/pdf");
                malote.inclui("NFS-e-" + numeroNfse + ".pdf", arquivo);
                dataSources.add(dataSourcePDF);
            }
        }
        if (anexosDoEmail.equals((Object)AnexoEmailNfe.PDF_XML_BOLETO) && dadosBoleto != null) {
            ContaCorrenteCarteira carteira = (ContaCorrenteCarteira)ContaCorrenteCarteiraRN.getInstance().buscarPorId(dadosBoleto.getIdCarteira());
            ByteArrayOutputStream boletos = null;
            if (carteira != null) {
                boletos = GeraBoletoRNSimplificada.getInstance().geraBoletosNotaFiscal(sessao, notaFiscal.getId(), dadosBoleto.getIdContaCorrente(), carteira, (InstrucaoCobranca)EnumUtils.getPorId(InstrucaoCobranca.class, (Object)dadosBoleto.getInstrucao()), dadosBoleto.getNumeroDiasInstrucao(), dadosBoleto.getPercentualDescontoPagamentoAteVencimento(), dadosBoleto.getObservacao());
            }
            if (boletos != null) {
                1 dataSourceByteArray = new /* Unavailable Anonymous Inner Class!! */;
                dataSources.add(dataSourceByteArray);
                malote.inclui("boletos" + notaFiscal.getNumeroNotaFiscal() + ".pdf", boletos.toByteArray());
            }
        }
        if (notaFiscal.getArquivoXmlCancelada() != null) {
            dataSourceXml = new InputStreamDataSource(numeroNfse + "-canc.xml", "text/xml", (InputStream)new ByteArrayInputStream(notaFiscal.getArquivoXmlCancelada()));
            malote.inclui(numeroNfse + "-canc.xml", notaFiscal.getArquivoXmlCancelada());
            dataSources.add(dataSourceXml);
        }
        notificacao.setDataSources(dataSources.toArray(new DataSource[0]));
        notificacao.setMalote(malote);
    }

    public void montarDadosNFe(Sessao sessao, NotaFiscal notaFiscal, DadosBoletoCompartilhamento dadosBoleto, Notificacao notificacao) throws UnicoMensagemUsuarioException {
        ArrayList<Object> dataSources = new ArrayList<Object>();
        Malote malote = new Malote();
        AnexoEmailNfe anexosDoEmail = sessao.getFilial().getParametroNFE().getAnexoEmailNfe();
        if (anexosDoEmail == null) {
            anexosDoEmail = AnexoEmailNfe.PDF_XML;
        }
        String chaveNfe = notaFiscal.getChaveNfe();
        if ((anexosDoEmail.equals((Object)AnexoEmailNfe.PDF_XML) || anexosDoEmail.equals((Object)AnexoEmailNfe.XML) || anexosDoEmail.equals((Object)AnexoEmailNfe.PDF_XML_BOLETO)) && notaFiscal.getArquivoXmlAutorizada() != null) {
            dataSources.add(new InputStreamDataSource(chaveNfe + "-procNFe.xml", "text/xml", (InputStream)new ByteArrayInputStream(notaFiscal.getArquivoXmlAutorizada())));
            malote.inclui(chaveNfe + "-procNFe.xml", notaFiscal.getArquivoXmlAutorizada());
        }
        if (anexosDoEmail.equals((Object)AnexoEmailNfe.PDF_XML) || anexosDoEmail.equals((Object)AnexoEmailNfe.PDF) || anexosDoEmail.equals((Object)AnexoEmailNfe.PDF_XML_BOLETO)) {
            byte[] arquivo = new NfeManagerWeb(sessao, null).gerarDanfeWeb(notaFiscal.getChaveNfe());
            UnicoByteArrayDataSource dataSourcePDF = new UnicoByteArrayDataSource(arquivo, "DANFE-" + chaveNfe + ".pdf", "application/pdf");
            dataSources.add(dataSourcePDF);
            malote.inclui("DANFE-" + chaveNfe + ".pdf", arquivo);
        }
        if (anexosDoEmail.equals((Object)AnexoEmailNfe.PDF_XML_BOLETO) && dadosBoleto != null && ContaCorrenteRN.getInstance().isContaCorrenteImprimeBoleto(dadosBoleto.getIdContaCorrente())) {
            ContaCorrenteCarteira carteira = (ContaCorrenteCarteira)ContaCorrenteCarteiraRN.getInstance().buscarPorId(dadosBoleto.getIdCarteira());
            ByteArrayOutputStream boletos = null;
            if (carteira != null) {
                boletos = GeraBoletoRNSimplificada.getInstance().geraBoletosNotaFiscal(sessao, notaFiscal.getId(), dadosBoleto.getIdContaCorrente(), carteira, (InstrucaoCobranca)EnumUtils.getPorId(InstrucaoCobranca.class, (Object)dadosBoleto.getInstrucao()), dadosBoleto.getNumeroDiasInstrucao(), dadosBoleto.getPercentualDescontoPagamentoAteVencimento(), dadosBoleto.getObservacao());
            }
            if (boletos != null) {
                2 dataSourceByteArray = new /* Unavailable Anonymous Inner Class!! */;
                dataSources.add(dataSourceByteArray);
                malote.inclui("boletos" + notaFiscal.getNumeroNotaFiscal() + ".pdf", boletos.toByteArray());
            }
        }
        if (notaFiscal.getArquivoXmlCancelada() != null) {
            dataSources.add(new InputStreamDataSource(chaveNfe + "-canc.xml", "text/xml", (InputStream)new ByteArrayInputStream(notaFiscal.getArquivoXmlCancelada())));
            malote.inclui(chaveNfe + "-canc.xml", notaFiscal.getArquivoXmlCancelada());
        }
        List cartasCorrecao = CartaCorrecaoRN.getInstance().buscarListaPorIdNotaFiscal(notaFiscal.getId());
        for (CartaCorrecao cartaCorrecao : cartasCorrecao) {
            if (cartaCorrecao.getArquivoTransmitido() == null) continue;
            String arquivo = chaveNfe + "-CCE" + StringUtil.zeroEsquerda((String)String.valueOf(cartaCorrecao.getSequencia()), (int)2) + ".xml";
            dataSources.add(new InputStreamDataSource(arquivo, "text/xml", (InputStream)new ByteArrayInputStream(cartaCorrecao.getArquivoTransmitido())));
            malote.inclui(arquivo, cartaCorrecao.getArquivoTransmitido());
        }
        notificacao.setDataSources(dataSources.toArray(new DataSource[0]));
        notificacao.setMalote(malote);
    }
}

