/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.estoqueterceiros;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.enuns.StatusRemessaTerceiros;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.estoqueterceiros.RemessaTerceiros;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/remessas-terceiros"})
public class RemessaTerceirosCrudController
extends CrudController<RemessaTerceiros, NotaFiscalItemRN> {
    public RemessaTerceirosCrudController() {
        super((AbstractRegraNegocio)NotaFiscalItemRN.getInstance(), RemessaTerceiros::new, false, true, false);
    }

    protected String getCacheId() {
        return "remessas-terceiros";
    }

    protected GridBuilder<NotaFiscalItemRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("razaosocial", "razaoSocial", "Nota", 0, false, new String[]{"fk_notafiscalitem_notafiscal"}));
        colunas.add(new ColunaSQL("numeronotafiscal", "numeroNotaFiscal", "Nota", 100, true, new String[]{"fk_notafiscalitem_notafiscal"}));
        colunas.add(new ColunaSQL("emissao", "emissao", "Data", 120, true, new String[]{"fk_notafiscalitem_notafiscal"}));
        colunas.add(new ColunaSQL("nome", "cliente", "Cliente/Fornec.", 220, true, new String[]{"fk_notafiscalitem_notafiscal", "fk_notafiscal_entidade"}));
        colunas.add(new ColunaSQL("nome", "produto", "Produto", 0, true, new String[]{"fk_notafiscalitem_produto"}));
        colunas.add(new ColunaSQL("quantidade", "Qtd", 100, true));
        colunas.add(new ColunaSQL("precounitario", "precoUnitario", "Valor", 100, true, new String[0]));
        GridBuilder grid = new GridBuilder(NotaFiscalItemRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("statusremessaterceiros"));
        grid.addCodicaoDefault(new Condicao("statusremessaterceiros", Operador.IGUAL, StatusRemessaTerceiros.PEDENTE.getId().intValue()));
        grid.addOrdemDefault(new Ordem("emissao", true));
        return grid;
    }
}

