/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.operacao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Item;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.operacao.OperacaoDTO;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/operacoes"})
@SubMenuMapping(MENU="SubMenuPdvGeral", NOME="Opera\u00e7\u00f5es realizadas", ROTA="/pdvs/operacoes", PROGRAMA=1000038, ICONE="icon icon-trabalharcom")
public class OperacaoCrudController
extends CrudController<Operacao, OperacaoRN> {
    public OperacaoCrudController() {
        super((AbstractRegraNegocio)OperacaoRN.getInstance(), Operacao::new, true, true);
        this.setItemSupplier(Item::new);
    }

    protected GridBuilder<OperacaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("filial", "filialFiltro", "Filial", 0, false, new String[0]));
        colunas.add(new ColunaSQL("nfce", "nfceFiltro", "NFCE", 0, false, new String[0]));
        colunas.add(new ColunaSQL("data", "dataOrdem", "Data", 0, false, new String[0]));
        colunas.add(new ColunaSQL("ecfserie", "ecfSerieOrdem", "S\u00e9rie ECF", 0, false, new String[0]));
        colunas.add(new ColunaSQL("coo", "cooOrdem", "COO", 0, false, new String[0]));
        colunas.add(new ColunaSQL("cancelado", "canceladoFiltro", "Cancelado", 0, false, new String[0]));
        colunas.add(new ColunaSQL("filial", "Filial", 0, true));
        colunas.add(new ColunaSQL("nfce", "NFCE", 0, true));
        colunas.add(new ColunaSQL("data", "Data", 0, true));
        colunas.add(new ColunaSQL("cro", "CRO", 0, true));
        colunas.add(new ColunaSQL("crz", "CRZ", 0, true));
        colunas.add(new ColunaSQL("coo", "COO", 0, true));
        colunas.add(new ColunaSQL("pdv", "Pdv", 0, true));
        colunas.add(new ColunaSQL("nome", "nomeususuario", "Usu\u00e1rio", 0, true, new String[]{"fk_operacao_usuario"}));
        colunas.add(new ColunaSQL("tipo", "Tipo", 0, true));
        colunas.add(new ColunaSQL("valorLiquido", "Valor", 0, true));
        colunas.add(new ColunaSQL("cancelado", "Cancelado", 0, true));
        colunas.add(new ColunaSQL("ecfSerie", "S\u00e9rie ECF", 0, true));
        GridBuilder grid = new GridBuilder(OperacaoRN.getInstance().getTabela(), colunas, "operacao");
        grid.addCodicaoDefault(new Condicao("nfceFiltro", Operador.DIFERENTE, EnumSimNao.SIM.getId().intValue()));
        grid.addCodicaoDefault(new Condicao("filialFiltro", Operador.IGUAL, SessaoUtil.getSessao().getCodigoFilial()));
        grid.addOrdem(new Ordem("dataOrdem"));
        grid.addOrdem(new Ordem("ecfSerieOrdem"));
        grid.addOrdem(new Ordem("cooOrdem"));
        return grid;
    }

    protected String getCacheId() {
        return "operacoes".concat("_").concat("_FILIAL=(").concat(SessaoUtil.getSessao().getCodigoFilial()).concat(")");
    }

    @RequestMapping(value={"/cancela-cupom"})
    @DBAutoCommit
    public void cancelarCupom(@RequestParam(value="idOperacao") Long idOperacao, @RequestParam(value="historico") String historico) throws UnicoMensagemUsuarioException {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        OperacaoRN.getInstance().gravarCancelamentoOperacao(operacao, historico, SessaoUtil.getSessao());
    }

    protected void beforeRead(Operacao operacao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (operacao != null && "0".equalsIgnoreCase(operacao.getCliente())) {
            operacao.setCliente("");
        }
        super.beforeRead((AbstractPojo)operacao, modo, parentId);
    }

    @RequestMapping(value={"/recupera-vendedor"})
    @DBAutoCommit
    public String recuperaVendedorOperacao(@RequestParam(value="idOperacao") Long idOperacao) {
        return JsonUtil.toJson((Object)OperacaoRN.getInstance().buscarVendedorPorCupomWeb(idOperacao));
    }

    @RequestMapping(value={"/buscar-por-pdv-coo"})
    @DBAutoCommit
    public OperacaoDTO buscarPorPdvCoo(@RequestParam Integer coo, @RequestParam Integer pdv) {
        OperacaoDTO operacaoDTO = null;
        Operacao operacao = OperacaoRN.getInstance().getObjetoPorPdvCooFilial(pdv, coo, SessaoUtil.getSessao().getFilial().getCodigo());
        if (operacao != null) {
            operacaoDTO = new OperacaoDTO();
            BeanUtil.copiarValores((Object)operacao, (Object)operacaoDTO, (boolean)false, (boolean)true, null);
        }
        return operacaoDTO;
    }

    @RequestMapping(value={"/buscar-nfce-autorizada-por-num-serie"})
    @DBAutoCommit
    public OperacaoDTO buscaNFCEAutorizada(@RequestParam String numeroNfce, @RequestParam String serieNfce) {
        OperacaoDTO operacaoDTO = null;
        Operacao operacao = OperacaoRN.getInstance().buscaNFCEAutorizada(SessaoUtil.getSessao().getFilial().getCodigo(), ModeloNotaFiscal.NOTA_FISCAL_CONSUMIDOR_ELETRONICA.getId(), serieNfce, numeroNfce);
        if (operacao != null) {
            operacaoDTO = new OperacaoDTO();
            BeanUtil.copiarValores((Object)operacao, (Object)operacaoDTO, (boolean)false, (boolean)true, null);
        }
        return operacaoDTO;
    }

    @RequestMapping(value={"/buscar-sat-autorizado"})
    @DBAutoCommit
    public OperacaoDTO buscaSATAutorizado(@RequestParam String numero, @RequestParam String serie) {
        OperacaoDTO operacaoDTO = null;
        Operacao operacao = OperacaoRN.getInstance().buscaSatAutorizado(SessaoUtil.getSessao().getFilial().getCodigo(), ModeloNotaFiscal.CUPOM_FISCAL_SAT.getId(), serie, numero);
        if (operacao != null) {
            operacaoDTO = new OperacaoDTO();
            BeanUtil.copiarValores((Object)operacao, (Object)operacaoDTO, (boolean)false, (boolean)true, null);
        }
        return operacaoDTO;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody Operacao operacao, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        OperacaoRN.getInstance().incluirOperacaoCompleta(operacao, SessaoUtil.getSessao());
        this.gravarAuditoriaRegistro(null, (AbstractPojo)operacao, 0);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return operacao.getId();
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Operacao operacao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis((AbstractPojo)operacao);
        this.gravarAuditoriaRegistro(operacao.getId(), (AbstractPojo)operacao, 1);
        OperacaoRN.getInstance().alterarOperacaoCompleta(operacao, SessaoUtil.getSessao());
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return operacao.getId();
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        this.gravarAuditoriaRegistro(id, null, 2);
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(id);
        OperacaoRN.getInstance().excluir(operacao, SessaoUtil.getSessao());
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
    }
}

