/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.parametrosintegracaofiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ParametroIntegracaoFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.service.LicencaService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-integracao-fiscal"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarIntegracaoFiscal", NOME="Par\u00e2metros da integra\u00e7\u00e3o fiscal", ROTA="/notas-fiscais/parametros-integracao-fiscal", PROGRAMA=1123)
public class ParametroIntegracaoFiscalCrudController
extends SimpleCrudController<ParametroIntegracaoFiscal, FilialRN> {
    public ParametroIntegracaoFiscalCrudController(LicencaService licencaService) {
        super((AbstractRegraNegocio)FilialRN.getInstance(), TipoArquivoArmazenado.Produto);
    }

    @DBAutoCommit
    public ParametroIntegracaoFiscal get(Long parentId) {
        return ((Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial())).getParametroIntegracaoFiscal();
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ParametroIntegracaoFiscal entity) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Filial filial = sessao.getFilial();
        filial.setParametroIntegracaoFiscal(entity);
        FilialRN.getInstance().gravar(1, filial, sessao);
        return filial.getId();
    }
}

