/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pautapreco;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.ProdutoPautaPreco;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PautaPreco;
import br.intelidata.commons.domain.regranegocio.PautaPrecoFilialRN;
import br.intelidata.commons.domain.regranegocio.PautaPrecoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pautas-preco"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarProdutos", NOME="Pautas de pre\u00e7o", ROTA="/cadastros/pautas-preco", PROGRAMA=1470)
public class PautaPrecoCrudController
extends CrudController<br.intelidata.commons.domain.pojo.PautaPreco, PautaPrecoRN> {
    public PautaPrecoCrudController() {
        super((AbstractRegraNegocio)PautaPrecoRN.getInstance(), br.intelidata.commons.domain.pojo.PautaPreco::new);
    }

    protected String getCacheId() {
        return "pautas-preco";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 300, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        GridBuilder grid = new GridBuilder(((PautaPrecoRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("inativo", "pautainativa"));
        grid.addOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    protected void read(br.intelidata.commons.domain.pojo.PautaPreco pautaPreco, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (LicencaManager.getInstance().isEnterprise()) {
            pautaPreco.setFiliais(PautaPrecoFilialRN.getInstance().buscarListaPorIdPauta(pautaPreco.getId()));
        }
    }

    @DBAutoCommit
    public br.intelidata.commons.domain.pojo.PautaPreco getObjeto(@RequestParam(required=false) Map<String, String> queryMap) {
        int modo = NumberUtil.string2int((String)queryMap.get("modo"));
        if (modo == 0) {
            return new br.intelidata.commons.domain.pojo.PautaPreco();
        }
        br.intelidata.commons.domain.pojo.PautaPreco pauta = (br.intelidata.commons.domain.pojo.PautaPreco)((PautaPrecoRN)this.rn).buscarPorId(Long.valueOf(0L));
        if (LicencaManager.getInstance().isEnterprise()) {
            pauta.setFiliais(PautaPrecoFilialRN.getInstance().buscarListaPorIdPauta(Long.valueOf(0L)));
        }
        return pauta;
    }

    @RequestMapping(value={"/lista-ativas"})
    @DBAutoCommit
    public ResponseEntity<String> pautasAtivasDynaList() {
        List pautas = this.get(true, SessaoUtil.getSessaoSistema().getIdFilial(), true, false, true);
        String pautasFormatada = pautas.stream().map(p -> new StringBuilder("{\"id\":").append(p.getId().toString()).append(", \"nome\":").append(JsonUtil.escapeQuote((String)p.getNome())).append(", \"selecionado\":").append(false).append("}")).collect(Collectors.joining(","));
        return this.responseEntityService.createJSONResponse("[" + pautasFormatada + "]");
    }

    @RequestMapping(value={"/buscar-pautas"})
    @DBAutoCommit
    public List<br.intelidata.commons.domain.pojo.PautaPreco> get(@RequestParam(required=false) boolean utilizaFilial, @RequestParam(required=false) Long idFilial, @RequestParam(required=false) boolean carregarBase, @RequestParam(required=false) boolean carregarInativo, @RequestParam(required=false) boolean consideraTodasPautas) {
        Sessao sessao = Contexto.getInstance().getSessao();
        List pautas = new ArrayList();
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            pautas = utilizaFilial && !NumberUtil.longNullOuZero((Long)idFilial) ? PautaPrecoRN.getInstance().getComboPautaFilialWeb(idFilial, carregarInativo, carregarBase) : PautaPrecoRN.getInstance().getComboPautaFilialWeb(null, carregarInativo, carregarBase);
            if (consideraTodasPautas) {
                br.intelidata.commons.domain.pojo.PautaPreco pauta = new br.intelidata.commons.domain.pojo.PautaPreco();
                pauta.setId(Long.valueOf(-1L));
                pauta.setNome("Todas");
                pautas.add(0, (br.intelidata.commons.domain.pojo.PautaPreco)pauta);
            }
        } else {
            Object[] pautasAntiga;
            for (Object o : pautasAntiga = PautaPreco.getInstance().getListPautaPreco(sessao, true)) {
                br.intelidata.commons.domain.pojo.PautaPreco pauta = new br.intelidata.commons.domain.pojo.PautaPreco();
                pauta.setId(((PautaPreco)o).getId());
                pauta.setNome(((PautaPreco)o).getNome());
                pautas.add((br.intelidata.commons.domain.pojo.PautaPreco)pauta);
            }
        }
        return pautas;
    }

    @RequestMapping(value={"/pauta-preco-ativa"})
    @DBAutoCommit
    public boolean isPautaPrecoAtiva() {
        boolean isPautasAtivas = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO) ? PautaPrecoRN.getInstance().isPautaPrecoAtiva(SessaoUtil.getSessao()) : PautaPreco.getInstance().isPautasPrecoAtivas(SessaoUtil.getSessao().getFilial());
        return isPautasAtivas;
    }

    @RequestMapping(value={"/pauta-preco-base-ativa-mobile"})
    @DBAutoCommit
    public boolean isPautaPrecoBaseAtivaMobile() {
        return PautaPrecoRN.getInstance().isPautaPrecoBaseAtivaMobile();
    }

    @RequestMapping(value={"/pauta-preco-produto"})
    @DBAutoCommit
    public List<ProdutoPautaPreco> buscarListaPautaPrecoProduto(@RequestParam Long idProduto) {
        Map mapProduto = ProdutoRN.getInstance().buscarValoresPorID(idProduto, new String[]{"idunidademedida", "casasdecimais"});
        Integer decimaisPreco = (Integer)mapProduto.get("casasdecimais");
        if (decimaisPreco == null || decimaisPreco == 0) {
            decimaisPreco = 2;
        }
        int decimaisQuantidade = UnidademedidaRN.getInstance().getCasasDecimais((Long)mapProduto.get("idunidademedida"));
        List lista = ProdutoRN.getInstance().buscarListaPautaPrecoProduto(SessaoUtil.getSessao(), idProduto);
        for (ProdutoPautaPreco prodPauta : lista) {
            prodPauta.setDecimaisPreco(decimaisPreco.intValue());
            prodPauta.setDecimaisQuantidade(decimaisQuantidade);
        }
        return lista;
    }

    @RequestMapping(value={"/pauta-cadastro-ativa"})
    @DBAutoCommit
    public boolean isPautaAtiva() {
        return PautaPrecoRN.getInstance().isPautaPrecoAtiva(SessaoUtil.getSessao());
    }
}

