/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv.cargabase;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.batch.serices.TaskService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.cargabase.PdvCargaBaseController;
import java.time.Duration;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import unipaf.dto.pdv.CargaBaseRequest;

@RestController
@RequestMapping(value={"/jobs-pdv/pdv-carga-base"})
public class PdvCargaBaseController
extends SimpleCrudController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TaskManager taskManager;
    private final TaskService taskService;

    public PdvCargaBaseController(TaskManager taskManager, TaskService taskService) {
        this.taskManager = taskManager;
        this.taskService = taskService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/gerar-arquivo"})
    @DBAutoCommit
    public void gerarArquivo(@RequestBody CargaBaseRequest request) throws UnicoMensagemUsuarioException {
        String tenant = ContextoHolder.getTenant();
        String string = tenant.intern();
        synchronized (string) {
            if (request.isForcar()) {
                this.criarTarefa(request, true);
            } else {
                Filial filial = this.getFilial(request);
                Task task = this.taskService.buscarUltimoTaskCargaBase(this.getMetaData(request), ContextoHolder.getTenant());
                if (this.isRecriarTask(task)) {
                    this.criarTarefa(request, false);
                } else if (task.getTaskStatus().equals((Object)TaskStatus.SUCCEDED) && this.arquivoExpirou(filial.getId(), task.getT2())) {
                    this.saveFile.excluirArquivo(ContextoHolder.getTenant(), TipoArquivoArmazenado.JobExecutor, task.getUrl(), true);
                    this.criarTarefa(request, false);
                }
            }
        }
    }

    private boolean isRecriarTask(Task task) {
        return task == null || task.getTaskStatus().equals((Object)TaskStatus.FAILED) || task.getTaskStatus().equals((Object)TaskStatus.DELETED);
    }

    @RequestMapping(value={"/arquivo-carga"})
    @DBAutoCommit
    public String getCaminhoArquivo(@RequestBody CargaBaseRequest request) throws UnicoMensagemUsuarioException {
        Filial filial = this.getFilial(request);
        Task task = this.taskService.buscarUltimoTaskCargaBase(this.getMetaData(request), ContextoHolder.getTenant());
        if (task != null) {
            this.log.info("Job carga de base est\u00e1 " + task.getTaskStatus().getDescricao());
            if (task.getTaskStatus().equals((Object)TaskStatus.ENQUEUED) && this.jobExpirou(filial.getId(), task.getCurrentTimeMillis())) {
                this.log.info("Job expirtou, ser\u00e1 criado um novo");
                task.setPrintStack("TimeOut de 5 min");
                this.taskManager.fail(task);
                this.log.info("Alterado job para error, pq o mesmo expirou");
            }
            if (task.getTaskStatus() == TaskStatus.ENQUEUED || task.getTaskStatus() == TaskStatus.PROCESSING) {
                return "";
            }
            if (task.getTaskStatus().equals((Object)TaskStatus.SUCCEDED)) {
                boolean possuiArquivo;
                if (!StringUtil.stringNullOrEmpty((String)task.getUrl()) && (possuiArquivo = this.saveFile.existObject(ContextoHolder.getTenant(), TipoArquivoArmazenado.JobExecutor, task.getUrl(), true))) {
                    String url;
                    int idxFim;
                    int idxIni = task.getUrl().indexOf("_", task.getUrl().indexOf("CargaArquivo"));
                    if (idxIni > -1 && (idxFim = task.getUrl().indexOf("_", ++idxIni)) > -1) {
                        String hash = task.getUrl().substring(idxIni, idxFim);
                        this.log.info("hash do arquivo: ({}) hash da carga: ({})", (Object)hash, (Object)request.getHash());
                        if (!hash.equals(request.getHash())) {
                            request.setForcar(true);
                            this.gerarArquivo(request);
                            return "";
                        }
                    }
                    if (!StringUtil.stringNullOrEmpty((String)(url = this.saveFile.publishArquivo(task.getUrl())))) {
                        return url.replace("\\", "/");
                    }
                }
                throw new UnicoException("WWW708", "A Carga da base finalizou mas n\u00e3o conseguiu salvar o arquivo. Verifique o Log.");
            }
            if (task.getTaskStatus().equals((Object)TaskStatus.FAILED)) {
                throw new UnicoException("WYODA43", "A Carga da base falhou. Verifique o Log da tarefa que gerou a carga da base.");
            }
            if (task.getTaskStatus().equals((Object)TaskStatus.DELETED)) {
                throw new UnicoException("WWW725", "A tarefa de carga da base foi cancelada.");
            }
        }
        return "";
    }

    private boolean arquivoExpirou(Long idFilial, LocalDateTime dataHoraFinalJob) {
        LocalDateTime agora = DataHoraFactory.getDataHora((Long)idFilial);
        long min = Duration.between(dataHoraFinalJob, agora).toMinutes();
        this.log.info("Verifica se o arquivo expirou.. Data hora job: " + dataHoraFinalJob + " | Agora: " + agora + " | minutos: " + min);
        return min > 30L;
    }

    private boolean jobExpirou(Long idFilial, Long millisJob) {
        LocalDateTime dataHoraCriacaoJob = DataHoraFactory.long2LocalDateTime((long)millisJob);
        LocalDateTime agora = DataHoraFactory.getDataHora((Long)idFilial);
        long min = Duration.between(dataHoraCriacaoJob, agora).toMinutes();
        this.log.info("Verifica se job expirou.. Data hora job: " + dataHoraCriacaoJob + " | Agora: " + agora + " | minutos: " + min);
        return min > 5L;
    }

    private void criarTarefa(CargaBaseRequest request, boolean validarFila) throws UnicoMensagemUsuarioException {
        1 iCreateTask = new /* Unavailable Anonymous Inner Class!! */;
        String detalhe = request.isForcar() ? "For\u00e7ar a carga" : "N\u00e3o for\u00e7ar a carga";
        iCreateTask.createTask((Object)request, null, detalhe, validarFila);
    }

    private String getMetaData(CargaBaseRequest request) {
        Long idUsuario = request.getSessao().getIdUsuario();
        if (Util.longNullOuZero((Long)idUsuario)) {
            Sessao sessao = SessaoUtil.getSessao();
            idUsuario = sessao.getIdUsuario();
        }
        JobMetadata metadata = new JobMetadata();
        metadata.set("codigoFilial", request.getFilial());
        metadata.set("hash", request.getHash());
        metadata.setIdUsuario(idUsuario);
        return metadata.to();
    }

    private Filial getFilial(CargaBaseRequest request) throws UnicoMensagemUsuarioException {
        Filial filial = FilialRN.getInstance().buscarQualquerFilialPorCodigo(request.getFilial());
        if (filial == null) {
            throw new UnicoMensagemUsuarioException("PDV1037", "Filial " + request.getFilial() + " n\u00e3o encontrada");
        }
        return filial;
    }

    static /* synthetic */ TaskManager access$000(PdvCargaBaseController x0) {
        return x0.taskManager;
    }

    static /* synthetic */ String access$100(PdvCargaBaseController x0, CargaBaseRequest x1) {
        return x0.getMetaData(x1);
    }
}

