/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pendenciaprocessamento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.Item;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.Pagamento;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.enuns.TipoEntidade;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusProcessamento;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoPendencia;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.domain.pojo.pafecf.AdmCartaoIdentificador;
import br.intelidata.commons.domain.pojo.pafecf.AdministradoraCartao;
import br.intelidata.commons.domain.pojo.pafecf.BandeiraCartao;
import br.intelidata.commons.domain.pojo.pafecf.BandeiraCartaoIdentificador;
import br.intelidata.commons.domain.pojo.pafecf.PendenciaProcessamento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ItemCommonRN;
import br.intelidata.commons.domain.regranegocio.VariacaoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroLancamentoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.AdmCartaoIdentificadorRN;
import br.intelidata.commons.modulo.pdv.regranegocio.AdministradoraCartaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.BandeiraCartaoIdentificadorRN;
import br.intelidata.commons.modulo.pdv.regranegocio.BandeiraCartaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.ItemRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.PagamentoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.PendenciaProcessamentoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.pendenciaprocessamento.PendenciaProcessamentoSolucaoSemVariacaoWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.processa.ProcessaCancelamento;
import unipaf.processa.ProcessaOperacao;

@RestController
@RequestMapping(value={"/api/pendencias-processamento"})
@SubMenuMapping(MENU="SubMenuPdvGeral", NOME="Opera\u00e7\u00f5es n\u00e3o processadas", ROTA="/pdvs/pendencias-processamento", PROGRAMA=1000033, ICONE="icon icon-trabalharcom")
public class PendenciaProcessamentoCrudController
extends CrudController<PendenciaProcessamento, PendenciaProcessamentoRN> {
    private final IConnectionHandler connectionHandler;

    @Autowired
    public PendenciaProcessamentoCrudController(IConnectionHandler connectionHandler) {
        super((AbstractRegraNegocio)PendenciaProcessamentoRN.getInstance(), PendenciaProcessamento::new);
        this.connectionHandler = connectionHandler;
    }

    protected GridBuilder<PendenciaProcessamentoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        ColunaSQL virtual = new ColunaSQL("idFilial", "idfilial", 0, false);
        virtual.setVirtual(true);
        colunas.add(virtual);
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idOperacao", "idOperacao", 0, false));
        colunas.add(new ColunaSQL("filial", "operacao_filial", "Filial", 0, true, new String[]{"fk_pendencia_operacao"}));
        colunas.add(new ColunaSQL("usuario", "operacao_usuario", "Usu\u00e1rio", 0, true, new String[]{"fk_pendencia_operacao"}));
        colunas.add(new ColunaSQL("data", "operacao_data", "Data", 0, true, new String[]{"fk_pendencia_operacao"}));
        colunas.add(new ColunaSQL("pdv", "operacao_pdv", "PDV", 0, true, new String[]{"fk_pendencia_operacao"}));
        colunas.add(new ColunaSQL("tipo", "operacao_tipo", "Tipo", 0, true, new String[]{"fk_pendencia_operacao"}));
        colunas.add(new ColunaSQL("coo", "operacao_coo", "COO", 0, true, new String[]{"fk_pendencia_operacao"}));
        colunas.add(new ColunaSQL("numeroNfce", "operacao_numeronfce", "N\u00famero", 0, true, new String[]{"fk_pendencia_operacao"}));
        colunas.add(new ColunaSQL("codigoErro", "C\u00f3digo erro", 0, true));
        colunas.add(new ColunaSQL("mensagemExcecao", "Msg Excecao", 0, true));
        return new GridBuilder(PendenciaProcessamentoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "pendencias-processamento";
    }

    @RequestMapping(value={"/cancela-cupom"})
    @DBAutoCommit
    public void cancelarCupom(@RequestParam(value="idOperacao") Long idOperacao, @RequestParam(value="historico") String historico, @RequestParam(value="idPendenciaProcessamento") Long idPendenciaProcessamento) throws UnicoMensagemUsuarioException {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        operacao.setStatusProcessamento(StatusProcessamento.PROCESSAR_CANCELAMENTO);
        OperacaoRN.getInstance().gravarCancelamentoOperacao(operacao, historico, SessaoUtil.getSessao());
        PendenciaProcessamentoRN.getInstance().excluir(PendenciaProcessamentoRN.getInstance().buscarPorId(idPendenciaProcessamento), SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/reprocessar"})
    public void reprocessar(@RequestParam List<Long> ids) throws UnicoMensagemUsuarioException {
        ArrayList<String> excecoes = new ArrayList<String>();
        this.connectionHandler.createConnection(false);
        List pendencias = PendenciaProcessamentoRN.getInstance().buscarListaPorIds(ids);
        for (PendenciaProcessamento pendencia : pendencias) {
            Operacao operacao = OperacaoRN.getInstance().buscarOperacaoCompletaPorId(pendencia.getIdOperacao());
            try {
                this.connectionHandler.beginTransaction();
                if (operacao != null) {
                    if (pendencia.getTipo() == TipoPendencia.PROCESSAMENTO) {
                        new ProcessaOperacao().processa(operacao, false);
                    } else {
                        new ProcessaCancelamento().processar(operacao);
                    }
                }
                PendenciaProcessamentoRN.getInstance().excluir((AbstractPojo)pendencia, SessaoUtil.getSessao());
                this.connectionHandler.commit();
            }
            catch (Throwable e) {
                this.connectionHandler.rollback();
                PendenciaProcessamentoRN.getInstance().excluir((AbstractPojo)pendencia, SessaoUtil.getSessao());
                PendenciaProcessamentoRN.getInstance().incluirPendencia(pendencia.getIdOperacao(), pendencia.getTipo(), e);
                excecoes.add(e.getMessage());
            }
        }
        this.connectionHandler.releaseConnection();
        if (!excecoes.isEmpty()) {
            throw new UnicoMensagemUsuarioException("WPDV46", "Erro ao reprocessar opera\u00e7\u00f5es", String.join((CharSequence)"<br>", excecoes));
        }
    }

    @RequestMapping(value={"/gravar-solucao-sem-variacao"}, method={RequestMethod.POST})
    @DBTransaction
    public void solucionarOperacaoSemVariacao(@RequestBody PendenciaProcessamentoSolucaoSemVariacaoWrapper pendenciaWrapper) throws UnicoMensagemUsuarioException {
        for (Item item : pendenciaWrapper.getItens()) {
            if (StringUtil.stringNullOrEmpty((String)item.getVariacoes())) {
                throw new UnicoMensagemUsuarioException("WPDV391", "Informe a varia\u00e7\u00e3o para o item " + item.getContador());
            }
            ItemRN.getInstance().alterar(item, SessaoUtil.getSessao());
        }
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(pendenciaWrapper.getIdPendencia());
        operacao.setStatusProcessamento(StatusProcessamento.PROCESSAR);
        OperacaoRN.getInstance().alterar(operacao, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/buscar-item-sem-variacao"})
    @DBAutoCommit
    public List<Item> buscarPorIdOperacao(@RequestParam(value="idOperacao") Long idOperacao) {
        List itens = ItemRN.getInstance().buscarListaPorIdOperacao(idOperacao);
        ArrayList<Item> produtosSemGrade = new ArrayList<Item>(itens.size());
        for (Item item : itens) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorCodigo(item.getProduto());
            if (produto == null || !VariacaoCommonRN.getInstance().isVariacao(produto.getId()) || !StringUtil.stringNullOrEmpty((String)item.getVariacoes())) continue;
            produtosSemGrade.add(item);
        }
        return produtosSemGrade;
    }

    @RequestMapping(value={"/procurar-cliente"})
    @DBAutoCommit
    public Long carregarIdCliente(@RequestParam Long idOperacao) {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        Entidade entidade = EntidadeRN.getInstance().buscarPorCpfCnpj(operacao.getConsumidorCpfCnpj(), new TipoEntidade[]{TipoEntidade.CLIENTE});
        return entidade != null ? entidade.getId() : null;
    }

    @RequestMapping(value={"/resolver-cliente"})
    @DBAutoCommit
    public void resolverPendenciaSemCliente(@RequestParam Long idOperacao, @RequestParam Long idCliente) throws UnicoMensagemUsuarioException {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        OperacaoRN.getInstance().trocarCliente(operacao, entidade, Contexto.getInstance().getSessao());
    }

    @RequestMapping(value={"/identificar-conta-corrente"})
    @DBTransaction
    public void resolverPendenciaSemContaCorrente(@RequestParam Long idPendencia, @RequestParam Long idContaCorrente, @RequestParam boolean atribuirDemais) throws UnicoMensagemUsuarioException {
        PendenciaProcessamento pendencia = (PendenciaProcessamento)PendenciaProcessamentoRN.getInstance().buscarPorId(idPendencia);
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(pendencia.getIdOperacao());
        Filial filial = (Filial)FilialRN.getInstance().buscarPorCodigo(operacao.getFilial());
        Sessao sessao = Sessao.createSessao((Long)filial.getId());
        if (atribuirDemais) {
            for (PendenciaProcessamento pend : PendenciaProcessamentoRN.getInstance().buscarFilialCodigoErro(sessao.getCodigoFilial(), pendencia.getCodigoErro())) {
                PagamentoRN.getInstance().atualizarPagamentosSemContaCorrente(sessao, idContaCorrente, pend.getIdOperacao());
            }
        } else {
            PagamentoRN.getInstance().atualizarPagamentosSemContaCorrente(sessao, idContaCorrente, pendencia.getIdOperacao());
        }
    }

    @RequestMapping(value={"/resolve-local-estoque"})
    @DBTransaction
    public void resolverPendenciaLocalEstoque(@RequestParam Long idPendencia, @RequestParam Long idLocalEstoque) throws UnicoMensagemUsuarioException {
        PendenciaProcessamento pendencia = (PendenciaProcessamento)PendenciaProcessamentoRN.getInstance().buscarPorId(idPendencia);
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(pendencia.getIdOperacao());
        operacao.setIdLocalEstoque(idLocalEstoque);
        operacao.setStatusProcessamento(StatusProcessamento.PROCESSAR);
        Sessao sessao = SessaoUtil.getSessao();
        OperacaoRN.getInstance().alterar(operacao, sessao);
        PendenciaProcessamentoRN.getInstance().excluir((AbstractPojo)pendencia, sessao);
    }

    @RequestMapping(value={"/pagamento-em-branco"})
    @DBAutoCommit
    public List<Pagamento> carregarPagamentosSemAdm(@RequestParam Long idOperacao) {
        return PagamentoRN.getInstance().getPagamentosRedeEmBranco(idOperacao);
    }

    @RequestMapping(value={"/atualiza-pagamento-em-branco"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void atualizarPagamentosSemAdm(@RequestBody List<Pagamento> pagamentos) throws UnicoMensagemUsuarioException {
        PagamentoRN.getInstance().atualizarPagamentoSemAdm(pagamentos, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/outra-solucoes"})
    @DBAutoCommit
    public Pagamento getPagamentoAdm(@RequestParam Long idOperacao) {
        List pagamentos = PagamentoRN.getInstance().buscarListaPorOperacao(idOperacao);
        for (Pagamento pagamento : pagamentos) {
            AdministradoraCartao adm;
            if (Util.stringNullOrEmpty((String)pagamento.getRede()) && Util.stringNullOrEmpty((String)pagamento.getNomeRede()) || (adm = AdministradoraCartaoRN.getInstance().getAdministradoraCartao(pagamento.getRede(), pagamento.getNomeRede(), null, null)) != null) continue;
            return pagamento;
        }
        return null;
    }

    @RequestMapping(value={"/outra-solucoes-bandeira"})
    @DBAutoCommit
    public Pagamento getPagamentoBandeira(@RequestParam Long idOperacao) {
        List pagamentos = PagamentoRN.getInstance().buscarListaPorOperacao(idOperacao);
        for (Pagamento pagamento : pagamentos) {
            BandeiraCartao bandeiraCartao;
            if (Util.stringNullOrEmpty((String)pagamento.getCodigoBandeira()) && Util.stringNullOrEmpty((String)pagamento.getNomeBandeira()) || (bandeiraCartao = BandeiraCartaoRN.getInstance().buscarBandeiraPorCodigoOrNome(pagamento.getCodigoBandeira(), pagamento.getNomeBandeira())) != null) continue;
            return pagamento;
        }
        return null;
    }

    @RequestMapping(value={"/cadastrar-identificador"})
    @DBTransaction
    public void cadastrarIdentificador(@RequestBody Pagamento pag, @RequestParam Long idAdm) throws UnicoMensagemUsuarioException {
        AdministradoraCartao adm = (AdministradoraCartao)AdministradoraCartaoRN.getInstance().buscarPorId(idAdm);
        AdmCartaoIdentificador identificador = new AdmCartaoIdentificador();
        identificador.setIdAdministradora(adm.getId());
        identificador.setIdentificador(pag.getNomeRede());
        AdmCartaoIdentificadorRN.getInstance().incluir((AbstractPojo)identificador, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/cadastrar-identificador-bandeira"})
    @DBTransaction
    public void cadastrarIdentificadorBandeira(@RequestBody Pagamento pag, @RequestParam Long idBandeira) throws UnicoMensagemUsuarioException {
        BandeiraCartao bandeira = (BandeiraCartao)BandeiraCartaoRN.getInstance().buscarPorId(idBandeira);
        BandeiraCartaoIdentificador identificador = new BandeiraCartaoIdentificador();
        identificador.setIdBandeira(bandeira.getId());
        identificador.setIdentificador(pag.getNomeBandeira());
        BandeiraCartaoIdentificadorRN.getInstance().incluir((AbstractPojo)identificador, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/pendencia-mais-vendedores"})
    @DBTransaction
    public void pendenciaComMaisVendedores(@RequestParam Long idPendencia, @RequestParam Long idVendedor) throws UnicoMensagemUsuarioException {
        PendenciaProcessamento pendencia = (PendenciaProcessamento)PendenciaProcessamentoRN.getInstance().buscarPorId(idPendencia);
        if (pendencia == null) {
            return;
        }
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idVendedor);
        if (entidade == null) {
            throw new UnicoMensagemUsuarioException("WWW722", "Informe um vendedor.");
        }
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(pendencia.getIdOperacao());
        List itens = !Util.longNullOuZero((Long)operacao.getIdRps()) ? ItemCommonRN.getInstance().buscarListaPorIdOperacao(operacao.getIdRps()) : ItemCommonRN.getInstance().buscarListaPorIdOperacao(operacao.getId());
        for (Item item : itens) {
            item.setIdVendedor(entidade.getId());
            item.setVendedor(entidade.getCodigo());
            ItemRN.getInstance().alterar(item, Contexto.getInstance().getSessao());
        }
        operacao.setStatusProcessamento(StatusProcessamento.PROCESSAR);
        Sessao sessao = SessaoUtil.getSessao();
        OperacaoRN.getInstance().alterar(operacao, sessao);
        PendenciaProcessamentoRN.getInstance().excluir((AbstractPojo)pendencia, sessao);
    }

    @RequestMapping(value={"/estorno-financeiro"})
    @DBTransaction
    public Map<String, Object> pendenciaEstornoFinanceiro(@RequestParam Long idOperacao) throws UnicoMensagemUsuarioException {
        List dados = FinanceiroDadoRN.getInstance().buscarListaPorIdOrigemTipoOrigem(1, idOperacao);
        boolean achouDocumentoParaEstornar = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (FinanceiroDado dado : dados) {
            List lancamentosParaEstornar = FinanceiroLancamentoRN.getInstance().buscarPorIdFinanceiro(dado.getId());
            if (lancamentosParaEstornar.isEmpty()) continue;
            TipoFinanceiro tipo = dado.getTipo().equals(TipoFinanceiro.RECEBER.getId()) ? TipoFinanceiro.RECEBER : TipoFinanceiro.PAGAR;
            map.put("id", dado.getId());
            map.put("documento", dado.getDocumento());
            map.put("tipo", tipo);
            achouDocumentoParaEstornar = true;
            break;
        }
        if (!achouDocumentoParaEstornar) {
            throw new UnicoMensagemUsuarioException("WPDV760", "Nenhum documento para estornar. Tente reprocessar a pend\u00eancia.");
        }
        return map;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        int idxIdFilial = this.getIndexColuna("idFilial", colunas);
        int idxfilial = this.getIndexColuna("operacao_filial", colunas);
        if (idxfilial > -1 && idxIdFilial > -1) {
            dados.forEach(registro -> {
                Filial filial = (Filial)FilialRN.getInstance().buscarPorCodigo((String)registro[idxfilial]);
                if (filial != null) {
                    registro[idxIdFilial] = filial.getId();
                }
            });
        }
    }
}

