/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.historico;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.MapResultSet;
import br.intelidata.commons.domain.pojo.FormacaoPrecoLog;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.vendas.HistoricoPeriodo;
import br.intelidata.commons.domain.regranegocio.PromocaoCommonRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoLogRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.HistoricoVendasRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.historico.HistoricoProduto;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.historico.HistoricoProdutoDetalhePreco;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.historico.HistoricoProdutoRequest;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/historico-produto"})
public class HistoricoProdutoCrudController {
    @RequestMapping(value={"/buscar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public HistoricoProduto buscar(@RequestBody HistoricoProdutoRequest request) {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(request.getIdProduto());
        HistoricoProduto historicoProduto = new HistoricoProduto();
        Consumer<MapResultSet> consumer = map -> {
            map.put("entradanotafiscal", (Object)DateUtil.formataDataHora((Temporal)((Temporal)map.get("entradanotafiscal")), (String)"dd/MM/yyyy"));
            map.put("emissaonotafiscal", (Object)DateUtil.formataDataHora((Temporal)((Temporal)map.get("emissaonotafiscal")), (String)"dd/MM/yyyy"));
            BigDecimal embalagem = (BigDecimal)map.compute((Object)"embalagem", (k, v) -> v == null ? BigDecimal.ZERO : v);
            BigDecimal quantidade = (BigDecimal)map.compute((Object)"quantidade", (k, v) -> v == null ? BigDecimal.ZERO : v);
            map.put("quantidadetotal", (Object)embalagem.multiply(quantidade).setScale((int)((Integer)map.get("decimaisquantidade")), RoundingMode.HALF_EVEN));
        };
        List historicoCompra = NotaFiscalItemRN.getInstance().buscarListaPorPeriodo(SessaoUtil.getSessao(), request.getInicio(), request.getFim(), request.getIdProduto(), null);
        historicoCompra.forEach(consumer);
        historicoProduto.setHistoricoCompra(historicoCompra);
        HistoricoVendasRN historicoVendasRN = new HistoricoVendasRN();
        List historicos = historicoVendasRN.buscaHistoricoPorPeriodoDoProduto(SessaoUtil.getSessao(), produto.getCodigo(), SessaoUtil.getSessao().getFilial().getCodigo(), request.getInicio(), request.getFim(), request.getAgrupadorHistoricoProdutoVenda());
        List historicoVendas = HistoricoVendasRN.transformaListaHistoricoSemanalEmMapResultSet((List)historicos);
        historicoVendas.forEach(map -> {
            map.put("iniciosemana", (Object)DateUtil.formataDataHora((Temporal)((Temporal)map.get("iniciosemana")), (String)"dd/MM/yyyy"));
            map.put("fimsemana", (Object)DateUtil.formataDataHora((Temporal)((Temporal)map.get("fimsemana")), (String)"dd/MM/yyyy"));
        });
        BigDecimal totalVendas = BigDecimal.ZERO;
        BigDecimal totalQtdVendas = BigDecimal.ZERO;
        for (HistoricoPeriodo historico : historicos) {
            totalQtdVendas = totalQtdVendas.add(historico.getQuantidade());
            totalVendas = totalVendas.add(historico.getTotal());
        }
        if (!historicos.isEmpty()) {
            totalVendas = totalVendas.divide(new BigDecimal(historicos.size()), RoundingMode.CEILING);
        }
        historicoProduto.setHistoricoVendas(historicoVendas);
        historicoProduto.setTotalVendas(totalVendas);
        historicoProduto.setTotalQtdVendas(totalQtdVendas);
        List historicoPreco = FormacaoPrecoLogRN.getInstance().buscarLogs(produto.getId(), request.getInicio(), request.getFim());
        historicoPreco.forEach(map -> map.put("datahora", (Object)DateUtil.formataDataHora((Temporal)((Temporal)map.get("datahora")), (String)"dd/MM/yyyy HH:mm")));
        historicoProduto.setHistoricoPreco(historicoPreco);
        List historicoPromocao = PromocaoCommonRN.getInstance().montaListaPromocaoPorProduto(request.getIdProduto(), request.isMontarApenasPromocoesVigentes());
        historicoProduto.setHistoricoPromocao(historicoPromocao);
        List historicoTransferenciaEntrada = NotaFiscalItemRN.getInstance().buscarTransferenciasPorPeriodo(SessaoUtil.getSessao(), request.getInicio(), request.getFim(), produto.getId(), "E");
        historicoTransferenciaEntrada.forEach(consumer);
        historicoProduto.setHistoricoTransferenciaEntrada(historicoTransferenciaEntrada);
        List historicoTransferenciaSaida = NotaFiscalItemRN.getInstance().buscarTransferenciasPorPeriodo(SessaoUtil.getSessao(), request.getInicio(), request.getFim(), produto.getId(), "S");
        historicoTransferenciaSaida.forEach(consumer);
        historicoProduto.setHistoricoTransferenciaSaida(historicoTransferenciaSaida);
        return historicoProduto;
    }

    @RequestMapping(value={"/buscar-vendas"}, method={RequestMethod.POST})
    @DBAutoCommit
    public HistoricoProduto buscarVendas(@RequestBody HistoricoProdutoRequest request) {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(request.getIdProduto());
        HistoricoProduto historicoProduto = new HistoricoProduto();
        HistoricoVendasRN historicoVendasRN = new HistoricoVendasRN();
        List historicos = historicoVendasRN.buscaHistoricoPorPeriodoDoProduto(SessaoUtil.getSessao(), produto.getCodigo(), SessaoUtil.getSessao().getFilial().getCodigo(), request.getInicio(), request.getFim(), request.getAgrupadorHistoricoProdutoVenda());
        List historicoVendas = HistoricoVendasRN.transformaListaHistoricoSemanalEmMapResultSet((List)historicos);
        historicoVendas.forEach(map -> {
            map.put("iniciosemana", (Object)DateUtil.formataDataHora((Temporal)((Temporal)map.get("iniciosemana")), (String)"dd/MM/yyyy"));
            map.put("fimsemana", (Object)DateUtil.formataDataHora((Temporal)((Temporal)map.get("fimsemana")), (String)"dd/MM/yyyy"));
        });
        BigDecimal totalVendas = BigDecimal.ZERO;
        BigDecimal totalQtdVendas = BigDecimal.ZERO;
        for (HistoricoPeriodo historico : historicos) {
            totalQtdVendas = totalQtdVendas.add(historico.getQuantidade());
            totalVendas = totalVendas.add(historico.getTotal());
        }
        if (!historicos.isEmpty()) {
            totalVendas = totalVendas.divide(new BigDecimal(historicos.size()), RoundingMode.CEILING);
        }
        historicoProduto.setHistoricoVendas(historicoVendas);
        historicoProduto.setTotalVendas(totalVendas);
        historicoProduto.setTotalQtdVendas(totalQtdVendas);
        return historicoProduto;
    }

    @RequestMapping(value={"/buscar-detalhe-preco"})
    @DBAutoCommit
    public HistoricoProdutoDetalhePreco buscarDetalheHistoricoPreco(@RequestParam Long idLog) throws UnicoMensagemUsuarioException {
        HistoricoProdutoDetalhePreco historico = new HistoricoProdutoDetalhePreco();
        if (!NumberUtil.longNullOuZero((Long)idLog)) {
            historico.setDetalheHistoricoPreco(FormacaoPrecoLogRN.getInstance().getMapResultSetDetalhes(SessaoUtil.getSessao(), idLog));
            historico.setPrecoVenda(((FormacaoPrecoLog)FormacaoPrecoLogRN.getInstance().buscarPorId(idLog)).getPrecoVendaAjustado());
        }
        return historico;
    }

    @RequestMapping(value={"/buscar-promocao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public HistoricoProduto buscarPromocoes(@RequestBody HistoricoProdutoRequest request) {
        HistoricoProduto historicoProduto = new HistoricoProduto();
        List historicoPromocao = PromocaoCommonRN.getInstance().montaListaPromocaoPorProduto(request.getIdProduto(), request.isMontarApenasPromocoesVigentes());
        historicoProduto.setHistoricoPromocao(historicoPromocao);
        return historicoProduto;
    }
}

