/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.tributacaoestado;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.ProdutoTributacaoEstado;
import br.intelidata.commons.domain.pojo.enuns.CstICMS;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.MotivoDesoneracaoIcms;
import br.intelidata.commons.domain.pojo.enuns.TipoAliquotaEstado;
import br.intelidata.commons.domain.pojo.enuns.TributacaoProduto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.AliquotaEstadoCommonRN;
import br.intelidata.commons.domain.regranegocio.BeneficioFiscalRN;
import br.intelidata.commons.domain.regranegocio.MotivoDesoneracaoIcmsPafRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoTributacaoEstadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tributacoes-estado"})
public class ProdutoTributacaoEstadoCrudController
extends CrudController<ProdutoTributacaoEstado, ProdutoTributacaoEstadoRN> {
    public ProdutoTributacaoEstadoCrudController() {
        super((AbstractRegraNegocio)ProdutoTributacaoEstadoRN.getInstance(), ProdutoTributacaoEstado::new, false, true, false);
        this.dependsOn("idProduto");
    }

    @RequestMapping(value={"/tributacoes-por-produto"})
    @DBAutoCommit
    public List<ProdutoTributacaoEstado> getTributacoesPorProduto(@RequestParam Long idProduto) {
        return ProdutoTributacaoEstadoRN.getInstance().buscarListaPorProduto(idProduto);
    }

    protected GridBuilder<ProdutoTributacaoEstadoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idProduto", "idProduto", 0, false));
        colunas.add(new ColunaSQL("idEstado", "idEstado", 0, false));
        colunas.add(new ColunaSQL("idFilial", "idFilial", 0, false));
        colunas.add(new ColunaSQL("possuiIncentivoFiscal", "Possui incentivo fiscal", 120, false));
        colunas.add(new ColunaSQL("filial", "Filial", 100, true));
        colunas.add(new ColunaSQL("estado", "Estado", 100, true));
        colunas.add(new ColunaSQL("tributacao", "Tributa\u00e7\u00e3o", 100, true, TributacaoProduto.class));
        colunas.add(new ColunaSQL("aliquota", "% ICMS", 100, true));
        colunas.add(new ColunaSQL("aliquotaFcp", "% FCP", 100, true));
        colunas.add(new ColunaSQL("tributacaoEspecialNfceSat", "NFC-e", 120, true));
        colunas.add(new ColunaSQL("tributacaoSN", "NFC-e Simples", 100, true));
        colunas.add(new ColunaSQL("aliquotaReducaoIcmsNfceSat", "% Red ICMS", 120, true));
        colunas.add(new ColunaSQL("codigo", "codigoBeneficio", "Benef\u00edcio fiscal", 120, true, new String[]{"fk_prodtribestado_bf"}));
        colunas.add(new ColunaSQL("idBeneficioFiscal", "Benef\u00edcio fiscal", 0, false));
        colunas.add(new ColunaSQL("motivoDesoneracaoIcms", "Motivo desonera\u00e7\u00e3o", 120, true, MotivoDesoneracaoIcms.class));
        colunas.add(new ColunaSQL("idBeneficioFiscalPresu", "Benef\u00edcio fiscal", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoBeneficioFiscalCredPresumido", "Benef\u00edcio fiscal", 120, true, new String[]{"fk_prodtribestado_presum"}));
        colunas.add(new ColunaSQL("aliquotaIcmsPresu", "% Cr\u00e9d. presumido", 120, true));
        return new GridBuilder(ProdutoTributacaoEstadoRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(ProdutoTributacaoEstado tributacaoEstado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)tributacaoEstado.getIdEstado()) && NumberUtil.longNullOuZero((Long)tributacaoEstado.getIdFilial())) {
            throw new UnicoMensagemUsuarioException("WWW44", "Informe a Filial ou o Estado.");
        }
        if (NumberUtil.longNullOuZero((Long)tributacaoEstado.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WWW45", "O produto n\u00e3o foi informado.");
        }
        if (TributacaoProduto.TRIBUTADO.getId().equals(tributacaoEstado.getTributacao())) {
            if (tributacaoEstado.getAliquota().compareTo(BigDecimal.ZERO) == 0 && !CstICMS.OUTROS.equals((Object)tributacaoEstado.getTributacaoEspecialNfceSat()) && !LicencaManager.getInstance().isNfce(SessaoUtil.getSessao().getFilial())) {
                throw new UnicoMensagemUsuarioException("WPRD196", "Se o campo 'PAF-ECF' for 'Tributado', o campo '% ICMS' deve ser maior que zero");
            }
            boolean aliquotaValida = AliquotaEstadoCommonRN.getInstance().isAliquotaValida(TipoAliquotaEstado.ICMS, tributacaoEstado.getIdEstado(), tributacaoEstado.getAliquota());
            if (!aliquotaValida) {
                throw new UnicoMensagemUsuarioException("WPRD198", "Al\u00edquota de ICMS informada \u00e9 inv\u00e1lida. Por favor verifique o cadastro de Al\u00edquotas por estado em Cadastros->Outros->Notas fiscais->Al\u00edquotas por estado");
            }
        }
        if (!NumberUtil.longNullOuZero((Long)tributacaoEstado.getIdBeneficioFiscal())) {
            if (tributacaoEstado.getTributacaoEspecialNfceSat() != null) {
                BeneficioFiscalRN.getInstance().validarBeneficioPorCST(SessaoUtil.getSessao().getFilial(), tributacaoEstado.getIdBeneficioFiscal(), tributacaoEstado.getTributacaoEspecialNfceSat(), null);
            } else {
                BeneficioFiscalRN.getInstance().validarBeneficioPorTributacaoPaf(SessaoUtil.getSessao().getFilial(), tributacaoEstado.getIdBeneficioFiscal(), tributacaoEstado.getTributacao(), null);
            }
        }
        MotivoDesoneracaoIcmsPafRN.getInstance().validarMotivoDesoneracaoIcms(tributacaoEstado.getTributacaoEspecialNfceSat(), (TributacaoProduto)EnumUtils.getPorId(TributacaoProduto.class, (Object)tributacaoEstado.getTributacao()), tributacaoEstado.getMotivoDesoneracaoIcms());
        List tributacoes = ProdutoTributacaoEstadoRN.getInstance().buscarListaPorProduto(tributacaoEstado.getIdProduto());
        if (tributacoes.stream().anyMatch(tributacao -> tributacao.getIdEstado().equals(tributacaoEstado.getIdEstado()) && (NumberUtil.longNullOuZero((Long)tributacaoEstado.getId()) || !tributacaoEstado.getId().equals(tributacao.getId())))) {
            throw new UnicoMensagemUsuarioException("WPRD177", "Tributa\u00e7\u00e3o j\u00e1 cadastrada");
        }
        Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(tributacaoEstado.getIdEstado());
        if (estado != null) {
            tributacaoEstado.setEstado(estado.getCodigo());
        }
    }

    protected String getCacheId() {
        return "tributacoes-estado";
    }
}

