/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.scanntech.configuracao.canaisdevenda;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.InativoFilial;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FilialScanntechDTO;
import br.intelidata.commons.domain.pojo.scanntechcanaisvenda.ConfiguracaoScanntechCanaisVenda;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.scanntech.ConfiguracaoScanntechCanaisVendaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Base64;
import java.util.Comparator;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracao-canais-vendas"})
@SubMenuMapping(MENU="SubMenuScanntech", NOME="Configura\u00e7\u00e3o canais de vendas", ROTA="/cadastros/configuracao-canais-vendas", PROGRAMA=1414)
@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Melhor n\u00e3o corrigir este bug para evitar problemas posteriores")
public class ScanntechConfiguracaoCanaisVendasSimpleController
extends SimpleCrudController<ConfiguracaoScanntechCanaisVenda, ConfiguracaoScanntechCanaisVendaRN> {
    public ScanntechConfiguracaoCanaisVendasSimpleController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)ConfiguracaoScanntechCanaisVendaRN.getInstance());
    }

    @DBAutoCommit
    public ConfiguracaoScanntechCanaisVenda get(@RequestParam(required=false) Long parentId) {
        ConfiguracaoScanntechCanaisVenda configuracao = ((ConfiguracaoScanntechCanaisVendaRN)this.getRegraNegocio()).buscar();
        if (configuracao == null) {
            configuracao = new ConfiguracaoScanntechCanaisVenda();
        }
        for (Filial filial : FilialRN.getInstance().buscarLista()) {
            if (!InativoFilial.NAO.equals((Object)filial.getInativo())) continue;
            configuracao.getFiliais().add(new FilialScanntechDTO(filial));
        }
        configuracao.getFiliais().sort(Comparator.comparing(FilialScanntechDTO::getCodigo));
        return configuracao;
    }

    public void beforeSave(ConfiguracaoScanntechCanaisVenda configuracaoScanntech) throws UnicoMensagemUsuarioException {
        if (!configuracaoScanntech.getSenha().equalsIgnoreCase(configuracaoScanntech.getSenhaNova())) {
            configuracaoScanntech.setSenha(Base64.getEncoder().encodeToString(configuracaoScanntech.getSenhaNova().getBytes()));
        }
        for (FilialScanntechDTO filialDTO : configuracaoScanntech.getFiliais()) {
            FilialRN.getInstance().gravarFilialScanntech(SessaoUtil.getSessao(), filialDTO);
        }
    }
}

