/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tabelapreco;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.domain.pojo.Hierarquia;
import br.intelidata.commons.domain.pojo.TabelaPrecoPainel;
import br.intelidata.commons.domain.pojo.TabelaPrecoPainelImagem;
import br.intelidata.commons.domain.pojo.annotations.FileWeb;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.commons.modulo.tabelapreco.regranegocio.TabelaPrecoPainelImagemRN;
import br.intelidata.commons.modulo.tabelapreco.regranegocio.TabelaPrecoPainelRN;
import br.intelidata.commons.modulo.tabelapreco.regranegocio.TabelaPrecoProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.HierarquiaCrudController;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/tabelas-preco-painel"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarTabelaPreco", NOME="Tabela de pre\u00e7o", ROTA="/cadastros/tabelas-preco-painel", ICONE="icons-grade-produto", PROGRAMA=106)
public class TabelaPrecoPainelCrudController
extends HierarquiaCrudController<TabelaPrecoPainel, TabelaPrecoPainelRN> {
    public TabelaPrecoPainelCrudController() {
        super((HierarquiaRN)TabelaPrecoPainelRN.getInstance(), TabelaPrecoPainel::new);
    }

    @RequestMapping(value={"/buscar-imagens"})
    @DBAutoCommit
    public List<TabelaPrecoPainelImagem> buscarImagens(@RequestParam Long idTabelaPreco) {
        return TabelaPrecoPainelImagemRN.getInstance().buscarListaPorIds(new Long[]{idTabelaPreco});
    }

    protected GridBuilder<TabelaPrecoPainelRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        this.addColunaNivel(colunas);
        colunas.forEach(colunaSQL -> {
            Coluna coluna = ((TabelaPrecoPainelRN)this.rn).buscarColuna(((TabelaPrecoPainelRN)this.rn).getTabela(), colunaSQL.getNome());
            if (coluna != null) {
                colunaSQL.setClasseValor(coluna.getClasseDado());
            }
        });
        return new GridBuilder(TabelaPrecoPainelRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(TabelaPrecoPainel tabelaPrecoPainel, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        tabelaPrecoPainel.getImagens().forEach(tabelaImagem -> {
            tabelaImagem.setImagem(new byte[0]);
            String caminhoOriginal = (String)TabelaPrecoPainelImagemRN.getInstance().buscarValorPorID(tabelaImagem.getId(), "caminhoimagem");
            if (!StringUtil.stringNullOrEmpty((String)caminhoOriginal)) {
                String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, TipoImagem.TamanhoOriginal, caminhoOriginal);
                if (StringUtil.stringNullOrEmpty((String)tabelaImagem.getCaminhoImagem()) || !tabelaImagem.getCaminhoImagem().equals(arquivoRelativo)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, caminhoOriginal);
                } else {
                    tabelaImagem.setCaminhoImagem(caminhoOriginal);
                }
            }
        });
    }

    protected void afterSave(TabelaPrecoPainel tabelaPrecoPainel, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        tabelaPrecoPainel.getImagens().forEach(imagem -> imagem.setIdTabelaPrecoPainel(tabelaPrecoPainel.getId()));
    }

    protected void read(TabelaPrecoPainel tabelaPrecoPainel, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        List tabelaPrecoPainelImagems = TabelaPrecoPainelImagemRN.getInstance().buscarListaPorIds(new Long[]{tabelaPrecoPainel.getId()});
        tabelaPrecoPainelImagems.forEach(tpi -> tpi.setCaminhoImagem(this.getStorageService().publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.TABELA_PRECO, TipoImagem.TamanhoOriginal, tpi.getCaminhoImagem())));
        tabelaPrecoPainel.setImagens(tabelaPrecoPainelImagems);
        tabelaPrecoPainel.setProdutos(TabelaPrecoProdutoRN.getInstance().buscarPorIdTabelaPreco(tabelaPrecoPainel.getId(), false));
    }

    protected String getCacheId() {
        return "tabelas-preco-painel";
    }

    public void loadFile(MultipartFile[] files, TabelaPrecoPainel tabelaPreco) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            Map<Object, Object> mapImagens = !ListMapUtil.listNullOrEmpty((List)tabelaPreco.getImagens()) ? tabelaPreco.getImagens().stream().collect(Collectors.groupingBy(TabelaPrecoPainelImagem::getCaminhoImagem)) : new HashMap();
            for (MultipartFile file : files) {
                Object[] split;
                String originalName = file.getOriginalFilename();
                if (StringUtil.stringNullOrEmpty((String)originalName) || ListMapUtil.arrayNullOrEmpty((Object[])(split = originalName.split("\\|")))) continue;
                try {
                    Object fieldName = split[0];
                    if (((String)fieldName).equalsIgnoreCase("listImagens")) {
                        List imagensTabela = (List)mapImagens.get(split[1]);
                        if (ListMapUtil.listNullOrEmpty((List)imagensTabela)) continue;
                        String caminho = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.TABELA_PRECO, file);
                        byte[] imagem = file.getBytes();
                        imagensTabela.forEach(i -> {
                            i.setCaminhoImagem(caminho);
                            if (this.saveFile.isTabela()) {
                                i.setImagem(imagem);
                            }
                        });
                        continue;
                    }
                    Field field = tabelaPreco.getClass().getDeclaredField((String)fieldName);
                    if (field == null) continue;
                    FileWeb fileWeb = field.getAnnotation(FileWeb.class);
                    if (fileWeb == null) {
                        throw new UnicoMensagemUsuarioException("WWW746", "Atributo n\u00e3o definido para o caminho da imagem [" + (String)fieldName + "]");
                    }
                    String url = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, file);
                    BeanUtil.set((Object)tabelaPreco, (String)fileWeb.ATRIBUTO(), (Object)url);
                    if (!this.saveFile.isTabela()) continue;
                    BeanUtil.set((Object)tabelaPreco, (String)fieldName, (Object)file.getBytes());
                }
                catch (IOException | NoSuchFieldException e) {
                    throw new UnicoMensagemUsuarioException("WWW745", "N\u00e3o foi poss\u00edvel atribuir os arquivos: " + e.getMessage());
                }
            }
        }
    }

    @DBAutoCommit
    public boolean validateSubgroup(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        Hierarquia hierarquia = (Hierarquia)this.read(id, null, 0, null);
        if (hierarquia.isSegundoNivel()) {
            throw new UnicoMensagemUsuarioException("WTBPR15", "N\u00e3o \u00e9 poss\u00edvel adicionar um subgrupo. S\u00e3o permitidos apenas dois n\u00edveis.");
        }
        return true;
    }
}

