/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.textogenerico;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.generico.LocalUsoTextoGenerico;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.uniplusshop.TextoEmailDefaultShop;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/textos-genericos"})
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliar", NOME="Textos gen\u00e9ricos", ICONE="icon-config", ROTA="/ferramentas/textos-genericos", PROGRAMA=97)
public class TextoGenericoCrudController
extends CrudController<TextoGenerico, TextoGenericoRN> {
    public TextoGenericoCrudController() {
        super((AbstractRegraNegocio)TextoGenericoRN.getInstance(), TextoGenerico::new);
    }

    @RequestMapping(value={"/textos-por-local-uso"})
    @DBAutoCommit
    public List<TextoGenerico> getComboPorLocalUso(@RequestParam LocalUsoTextoGenerico localUso) {
        return ((TextoGenericoRN)this.rn).getComboTextoGenericoPorLocalUsoWeb(localUso);
    }

    @RequestMapping(value={"/carregar_default_shop"})
    @DBAutoCommit
    public TextoGenerico getDefaultShop(@RequestParam LocalUsoTextoGenerico localUso) {
        if (LocalUsoTextoGenerico.EMAIL_UNIPLUS_SHOP_ENVIO.equals((Object)localUso)) {
            return TextoEmailDefaultShop.informarEnvio((boolean)true);
        }
        if (LocalUsoTextoGenerico.EMAIL_UNIPLUS_SHOP_COMPRA.equals((Object)localUso)) {
            return TextoEmailDefaultShop.informarCompra((boolean)true);
        }
        return null;
    }

    protected String getCacheId() {
        return "textos-genericos";
    }

    protected GridBuilder<TextoGenericoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 80, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 200, true));
        colunas.add(new ColunaSQL("localUso", "Local de uso", 150, true, LocalUsoTextoGenerico.class));
        colunas.add(new ColunaSQL("texto", "Texto", 0, true));
        return new GridBuilder(((TextoGenericoRN)this.rn).getTabela(), colunas);
    }
}

