/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tipocomissao.pauta.hierarquia;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.financeiro.TipoComissaoPautaHierarquia;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.comissao.regranegocio.TipoComissaoPautaHierarquiaRN;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-comissao-pauta-hierarquia"})
public class TipoComissaoPautaHierarquiaCrudController
extends CrudController<TipoComissaoPautaHierarquia, TipoComissaoPautaHierarquiaRN> {
    public TipoComissaoPautaHierarquiaCrudController() {
        super((AbstractRegraNegocio)TipoComissaoPautaHierarquiaRN.getInstance(), TipoComissaoPautaHierarquia::new);
        this.dependsOn("idTipoComissaoPauta");
    }

    protected GridBuilder<TipoComissaoPautaHierarquiaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idTipoComissaoPauta", "idTipoComissaoPauta", 0, false));
        colunas.add(new ColunaSQL("idHierarquia", "idHierarquia", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoHierarquia", "Grupo", 30, true, new String[]{"fk_tipcompauthier_hier"}));
        colunas.add(new ColunaSQL("nome", "nomeHierarquia", "Grupo", 30, true, new String[]{"fk_tipcompauthier_hier"}));
        colunas.add(new ColunaSQL("comissao", "% Comiss\u00e3o", 50, true));
        colunas.add(new ColunaSQL("comissaoAVista", "% Comiss\u00e3o \u00e0 vista", 50, true));
        colunas.add(new ColunaSQL("comissaoAPrazo", "% Comiss\u00e3o a prazo", 50, true));
        colunas.add(new ColunaSQL("comissaoQuitacao", "% Comiss\u00e3o na quita\u00e7\u00e3o", 50, true));
        return new GridBuilder(TipoComissaoPautaHierarquiaRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(TipoComissaoPautaHierarquia tipoComissaoPautaHierarquia, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)tipoComissaoPautaHierarquia.getIdTipoComissaoPauta())) {
            throw new UnicoMensagemUsuarioException("WWW88", "Pauta de comiss\u00e3o n\u00e3o informada.");
        }
        if (NumberUtil.longNullOuZero((Long)tipoComissaoPautaHierarquia.getIdHierarquia())) {
            throw new UnicoMensagemUsuarioException("WCMS36", "Grupo de produto n\u00e3o informado! Verifique.");
        }
        HierarquiaGrupoProduto grupo = (HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(tipoComissaoPautaHierarquia.getIdHierarquia());
        if (grupo == null) {
            throw new UnicoMensagemUsuarioException("WCMS37", "Grupo de produto n\u00e3o encontrado! Verifique.");
        }
        if (this.hierarquiaExiste(tipoComissaoPautaHierarquia.getIdTipoComissaoPauta(), tipoComissaoPautaHierarquia.getId(), tipoComissaoPautaHierarquia.getIdHierarquia())) {
            throw new UnicoMensagemUsuarioException("WCMS38", "Grupo de produto j\u00e1 existe na lista! Verifique.");
        }
    }

    protected String getCacheId() {
        return "tipos-comissao-pauta-hierarquia";
    }

    private boolean hierarquiaExiste(Long idTipoComissaoPauta, Long id, Long idHierarquia) {
        return TipoComissaoPautaHierarquiaRN.getInstance().buscarComissaoPorTipoComissaoPautaHierarquia(idTipoComissaoPauta, idHierarquia) != null && (NumberUtil.longNullOuZero((Long)id) || !((TipoComissaoPautaHierarquia)TipoComissaoPautaHierarquiaRN.getInstance().buscarPorId(id)).getIdHierarquia().equals(idHierarquia));
    }
}

