/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.usuario;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.ItemComboBox;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.UnicoCrypt;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.PreferenciaUsuario;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.UsuarioBiometria;
import br.intelidata.commons.domain.pojo.UsuarioReseteSenha;
import br.intelidata.commons.domain.pojo.enuns.AccessLogStatus;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.MarcaLeitorBiometrico;
import br.intelidata.commons.domain.pojo.enuns.NivelPoliticaSeguranca;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusDataOrdemServico;
import br.intelidata.commons.domain.pojo.enuns.StatusOrdemServico;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.domain.regranegocio.PreferenciaUsuarioCommonRN;
import br.intelidata.commons.domain.regranegocio.UsuarioBiometriaCommonRN;
import br.intelidata.commons.domain.regranegocio.b2c.SessaoWebRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PreferenciaUsuarioRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteUsuarioRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.UsuarioReseteSenhaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.recoverypassword.ResetPasswordEmailService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ConfiguracaoCampoExtra(TABELA="usuario", QUANTIDADE=QuantidadeCampoExtra.USUARIO)
@RestController
@RequestMapping(value={"/api/usuarios"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarUsuario", NOME="Usu\u00e1rios", ROTA="/cadastros/usuarios", PROGRAMA=21)
public class UsuarioCrudController
extends CrudController<Usuario, UsuarioRN> {
    private final ResetPasswordEmailService emailService;
    private final CacheService cacheService;

    @Autowired
    public UsuarioCrudController(ResetPasswordEmailService emailService, CacheService cacheService) {
        super((AbstractRegraNegocio)UsuarioRN.getInstance(), Usuario::new, TipoArquivoArmazenado.Usuario);
        this.emailService = emailService;
        this.cacheService = cacheService;
    }

    @RequestMapping(value={"/r2d2-propriedades"})
    @DBAutoCommit
    public List<ItemComboBox> getComboR2D2Propriedade() {
        return UsuarioRN.getInstance().getComboUsuarioPreferencialR2D2Web().stream().map(u -> new ItemComboBox((Object)u.getId(), u.getNome())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/usuario-supervisor"})
    @DBAutoCommit
    public List<Usuario> getUsuariosSupervisores(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="6") int limit) {
        return UsuarioRN.getInstance().getListUsuariosSupervisorWeb(query, limit);
    }

    @RequestMapping(value={"/supervisor"}, method={RequestMethod.POST})
    @DBAutoCommit
    public Usuario validarUsuarioSupervisor(@RequestBody Usuario usuario) throws UnicoMensagemUsuarioException {
        return UsuarioRN.getInstance().validarLogin(usuario.getNome(), usuario.getSenha(), false);
    }

    public Extras getCampoExtra(String nome, String tabela) {
        if (tabela.equals(UsuarioRN.getInstance().getTabela())) {
            return ExtrasRN.getInstance().buscarPorNomeTabela(UsuarioRN.getInstance().getTabela());
        }
        return null;
    }

    @RequestMapping(value={"/usuario-alterar-senha"})
    @DBTransaction
    public String alterarSenha(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        Usuario usuario = UsuarioRN.getInstance().alterarSenha(id, SessaoUtil.getSessao());
        return usuario.getSenhaDescriptografada();
    }

    @RequestMapping(value={"/usuario-atualiza-status-os"})
    @DBTransaction
    public void atualizaUltimoStatusOS(@RequestParam List<StatusOrdemServico> listaStatus, @RequestParam StatusDataOrdemServico statusData) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        PreferenciaUsuario preferenciaUsuario = sessao.getUsuario().getPreferenciaUsuario();
        preferenciaUsuario.setUltimosStatusOrdemServico(listaStatus.stream().map(Enum::name).collect(Collectors.joining(",")));
        preferenciaUsuario.setUltimoStatusDataOrdemServico(statusData);
        PreferenciaUsuarioRN.getInstance().salvaPreferenciasUsuario(sessao, preferenciaUsuario);
    }

    @RequestMapping(value={"/busca-usuario-ativo-inativo"})
    @DBAutoCommit
    public List<Usuario> bustarListaUsuariosAtivosInativos(@RequestParam boolean mostrarInativo) {
        return UsuarioRN.getInstance().buscarUsuarioRelatorioWeb(mostrarInativo);
    }

    @PostMapping(value={"/atualizar-preferencia-dashboard"})
    @DBTransaction
    public void updateDashboard(@RequestBody Usuario user) throws UnicoMensagemUsuarioException {
        Usuario usuario = UsuarioRN.getInstance().buscarPorId(user.getId());
        usuario.setDesativarDashboardLogin(user.isDesativarDashboardLogin());
        UsuarioRN.getInstance().alterar(usuario, SessaoUtil.getSessao());
    }

    @GetMapping(value={"/carregar-lista-biometria-usuario"})
    @DBTransaction
    public List<UsuarioBiometria> carregarListaBiometria() throws UnicoMensagemUsuarioException {
        return UsuarioBiometriaCommonRN.getInstance().buscarLIstaWeb(SessaoUtil.getSessao());
    }

    @GetMapping(value={"/excluir-biometria-usuario"})
    @DBTransaction
    public void deletarBiometria(@RequestParam Long idBiometria) throws UnicoMensagemUsuarioException {
        UsuarioBiometriaCommonRN.getInstance().excluir(UsuarioBiometriaCommonRN.getInstance().buscarPorId(idBiometria), SessaoUtil.getSessao());
    }

    @PostMapping(value={"/verificar-inativo"})
    @DBAutoCommit
    public boolean existeSessaoInativo(@RequestBody Usuario usuario) {
        Usuario usuarioAnterior = UsuarioRN.getInstance().buscarPorId(usuario.getId());
        if (usuarioAnterior.getInativo() == 0 && usuario.getInativo() == 1) {
            return !SessaoWebRN.getInstance().buscarSessoesPorIdUsuario(usuario.getId()).isEmpty();
        }
        return false;
    }

    @RequestMapping(value={"/usuarios-mensagem-mobile"})
    @DBAutoCommit
    public List<Map<String, Object>> usuariosMensagemMobile() {
        return UsuarioRN.getInstance().buscarLista().stream().filter(u -> !NumberUtil.longNullOuZero((Long)u.getIdEntidade())).map(usuario -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("selecionado", false);
            map.put("usuario", usuario.getNome());
            map.put("idUsuario", usuario.getId());
            map.put("dataLeitura", null);
            return map;
        }).collect(Collectors.toList());
    }

    protected void beforeRead(Usuario usuario, int modo, Optional<Long> parentId) {
        String senhaSmtp;
        if (!StringUtil.stringNullOrEmpty((String)usuario.getCaminhoImagemUsuario())) {
            usuario.setCaminhoImagemUsuario(this.imagePublishPath(usuario.getCaminhoImagemUsuario()));
        }
        if (!StringUtil.stringNullOrEmpty((String)usuario.getArquivoImagemEmail())) {
            usuario.setArquivoImagemEmail(this.imagePublishPath(usuario.getArquivoImagemEmail()));
        }
        if (!Util.stringNullOrEmpty((String)(senhaSmtp = usuario.getPreferenciaUsuario().getSenhaServidorSmtp()))) {
            String decrip = UnicoCrypt.decriptIfErroReturnNull((String)senhaSmtp);
            usuario.getPreferenciaUsuario().setSenhaServidorSmtp(decrip == null ? senhaSmtp : decrip);
        }
        usuario.setIdsContaCorrente(ContaCorrenteUsuarioRN.getInstance().buscarIdsContasPorUsuario(usuario.getId()));
        usuario.setBiometrias(UsuarioBiometriaCommonRN.getInstance().buscarListaPorUsuario(usuario.getId()));
    }

    protected void beforeCreate(Usuario usuario, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validaEmailUtilizado(usuario);
        if (ControleRN.getInstance().getNivelPoliticaSeguranca() != NivelPoliticaSeguranca.BAIXA) {
            usuario.setBloqueado(EnumSimNao.SIM.getId().intValue());
            usuario.setObservacaoBloqueio(AccessLogStatus.SENHA_NAO_CONFIRMADA);
        }
    }

    protected void beforeUpdate(Usuario usuario, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        String caminhoOriginalImagem = UsuarioRN.getInstance().getCaminhoImagemWeb(usuario.getId(), "caminhoImagemUsuario");
        String caminhoOriginalEmail = UsuarioRN.getInstance().getCaminhoImagemWeb(usuario.getId(), "arquivoImagemEmail");
        if (!StringUtil.stringNullOrEmpty((String)caminhoOriginalImagem) && this.caminhoValido(caminhoOriginalImagem, usuario.getCaminhoImagemUsuario()) && !StringUtil.stringNullOrEmpty((String)usuario.getCaminhoImagemUsuario())) {
            usuario.setCaminhoImagemUsuario(caminhoOriginalImagem);
        }
        if (!StringUtil.stringNullOrEmpty((String)caminhoOriginalEmail) && this.caminhoValido(caminhoOriginalEmail, usuario.getArquivoImagemEmail())) {
            usuario.setArquivoImagemEmail(caminhoOriginalEmail);
        }
        this.validaEmailUtilizado(usuario);
        PreferenciaUsuario preferenciaUsuario = PreferenciaUsuarioCommonRN.getInstance().buscarPorIdUsuario(null, usuario.getId());
        usuario.getPreferenciaUsuario().setIdVendedorDav(preferenciaUsuario.getIdVendedorDav());
    }

    protected void beforeDelete(Usuario usuario) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)usuario.getCaminhoImagemUsuario())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, usuario.getCaminhoImagemUsuario());
        }
        if (!StringUtil.stringNullOrEmpty((String)usuario.getArquivoImagemEmail())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, usuario.getArquivoImagemEmail());
        }
    }

    protected void beforeSave(Usuario usuario, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        String senhaSmtp = usuario.getPreferenciaUsuario().getSenhaServidorSmtp();
        usuario.getPreferenciaUsuario().setSenhaServidorSmtp(Util.stringNullOrEmpty((String)senhaSmtp) ? null : UnicoCrypt.cript((String)senhaSmtp));
        MarcaLeitorBiometrico marca = (MarcaLeitorBiometrico)EnumUtils.getPorId(MarcaLeitorBiometrico.class, (Object)PropriedadeRN.getInstance().getPropriedadeInt(SessaoUtil.getSessao().getFilial(), 683));
        if (!ListMapUtil.listNullOrEmpty((List)usuario.getBiometrias()) && marca != null) {
            for (UsuarioBiometria ub : usuario.getBiometrias()) {
                ub.setMarcaLeitor(marca);
            }
        }
    }

    protected void afterCreate(Usuario usuario, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        UsuarioReseteSenha usuarioRecuperaSenha = new UsuarioReseteSenha();
        usuarioRecuperaSenha.setIdUsuario(usuario.getId());
        usuarioRecuperaSenha.setEmail(usuario.getEmail());
        usuarioRecuperaSenha.setData(DataHoraFactory.getData());
        String token = UUID.randomUUID().toString();
        usuarioRecuperaSenha.setToken(token);
        usuarioRecuperaSenha.setIpUsuario(BeanUtil.getClientIP((HttpServletRequest)this.httpServletRequest));
        UsuarioReseteSenhaRN.getInstance().incluir((AbstractPojo)usuarioRecuperaSenha, null);
        this.emailService.sendMail(usuarioRecuperaSenha, usuario.getNome(), usuario.getVersion(), usuario.getAmbiente(), usuario.getUrl());
    }

    protected GridBuilder<UsuarioRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("nome", "nomePerfil", "Perfil", 0, true, new String[]{"fk_usuario_perfil"}));
        colunas.add(new ColunaSQL("supervisor", "Supervisor", 100, true, EnumSimNao.class));
        colunas.add(new ColunaSQL("inativo", "Inativo", 100, true, EnumSimNao.class));
        colunas.add(new ColunaSQL("email", "Email", 0, false));
        GridBuilder grid = new GridBuilder(UsuarioRN.getInstance().getTabela(), colunas, "cad_usuario");
        grid.addReferenciaDefault(new Referencia("usuarioremoto", "usuarioremoto"));
        grid.addCodicaoDefault(new Condicao("usuarioremoto", Operador.IGUAL, EnumSimNao.NAO.getId().intValue()));
        grid.addCodicaoDefault(new Condicao("id", Operador.MAIOR_QUE, Long.valueOf(0L)));
        grid.addReferenciaDefault(new Referencia("inativo", "usuarioInativo"));
        return grid;
    }

    protected String getCacheId() {
        return "usuarios";
    }

    private String imagePublishPath(String path) {
        return this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, TipoImagem.Pequena, path);
    }

    private boolean caminhoValido(String caminhoOriginal, String imagePath) {
        boolean caminhoValido = true;
        if (StringUtil.stringNullOrEmpty((String)imagePath) || !imagePath.equals(this.imagePublishPath(caminhoOriginal))) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, caminhoOriginal);
            caminhoValido = false;
        }
        return caminhoValido;
    }

    private void validaEmailUtilizado(Usuario usuario) throws UnicoMensagemUsuarioException {
        Usuario usuarioEmail;
        if (StringUtil.stringNullOrEmpty((String)usuario.getEmail()) || !usuario.getEmail().contains(".")) {
            throw new UnicoMensagemUsuarioException("WWW416", "O e-mail informado \u00e9 inv\u00e1lido");
        }
        if (!usuario.getEmail().equalsIgnoreCase("")) {
            if (usuario.getEmail().contains("@")) {
                String[] partes = usuario.getEmail().split("@");
                if (partes.length < 2 || partes[0].equalsIgnoreCase("")) {
                    throw new UnicoMensagemUsuarioException("WWW417", "O e-mail informado \u00e9 inv\u00e1lido");
                }
                String[] partesDepoisArroba = partes[1].split("\\.");
                if (partesDepoisArroba.length < 2) {
                    throw new UnicoMensagemUsuarioException("WWW418", "O e-mail informado \u00e9 inv\u00e1lido");
                }
            } else {
                throw new UnicoMensagemUsuarioException("WWW419", "O e-mail informado \u00e9 inv\u00e1lido");
            }
        }
        if ((usuarioEmail = UsuarioRN.getInstance().buscarPorEmail(usuario.getEmail(), false)) != null && !usuarioEmail.getId().equals(usuario.getId())) {
            throw new UnicoMensagemUsuarioException("WWW306", "Este e-mail j\u00e1 est\u00e1 sendo utilizado por outro usu\u00e1rio");
        }
    }

    @ResponseBody
    @RequestMapping(value={"/usuario-alterar-imagem"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public String saveProfileImage(@RequestPart(value="file") MultipartFile file) throws UnicoMensagemUsuarioException {
        String caminhoOriginalImagem;
        if (file == null || !Objects.equals(file.getContentType(), "image/jpeg") && !Objects.equals(file.getContentType(), "image/png")) {
            throw new UnicoMensagemUsuarioException("WWW420", "O arquivo informado \u00e9 inv\u00e1lido");
        }
        Usuario usuario = UsuarioRN.getInstance().buscarPorId(SessaoUtil.getSessao().getIdUsuario());
        if (!StringUtil.stringNullOrEmpty((String)file.getOriginalFilename())) {
            usuario.setCaminhoImagemUsuario(this.saveFile.saveImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), file));
        }
        if (this.saveFile.isTabela()) {
            byte[] bFile;
            try {
                bFile = file.getBytes();
            }
            catch (IOException ex) {
                throw new UnicoMensagemUsuarioException("WWW375", "O arquivo especificado n\u00e3o \u00e9 aceito");
            }
            usuario.setImagemUsuario(bFile);
        }
        if (!StringUtil.stringNullOrEmpty((String)(caminhoOriginalImagem = UsuarioRN.getInstance().getCaminhoImagemWeb(usuario.getId(), "caminhoImagemUsuario"))) && this.caminhoValido(caminhoOriginalImagem, usuario.getCaminhoImagemUsuario()) && !StringUtil.stringNullOrEmpty((String)usuario.getCaminhoImagemUsuario())) {
            usuario.setCaminhoImagemUsuario(caminhoOriginalImagem);
        }
        UsuarioRN.getInstance().gravar(1, (AbstractPojo)usuario, true, SessaoUtil.getSessao());
        String caminhoImagem = null;
        if (!StringUtil.stringNullOrEmpty((String)usuario.getCaminhoImagemUsuario())) {
            caminhoImagem = this.imagePublishPath(usuario.getCaminhoImagemUsuario());
        }
        return caminhoImagem;
    }

    @RequestMapping(value={"/usuario-buscar-imagem"})
    @DBAutoCommit
    public String buscaImagemUsuario(@RequestParam Long id) {
        return UsuarioRN.getInstance().getCaminhoImagemWeb(id, "caminhoImagemUsuario");
    }

    @RequestMapping(value={"/usuario-alterar-imagens"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public String loadFiles(@RequestPart(value="files") MultipartFile[] files) throws UnicoMensagemUsuarioException {
        String imageName = "";
        if (!ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            for (MultipartFile file : files) {
                if (StringUtil.stringNullOrEmpty((String)file.getOriginalFilename())) continue;
                imageName = this.saveProfileImage(file);
            }
        }
        return imageName;
    }

    @RequestMapping(value={"/atualizar-preferencia"}, method={RequestMethod.POST})
    @DBTransaction
    public void atualizarPreferencia(@RequestBody PreferenciaUsuario preferenciaUsuario) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        sessao.getUsuario().setPreferenciaUsuario(preferenciaUsuario);
        UsuarioRN.getInstance().gravar(1, sessao.getUsuario(), sessao);
    }

    protected void afterSave(Usuario usuario, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ContaCorrenteUsuarioRN.getInstance().gravarDeletar(SessaoUtil.getSessao(), usuario.getIdsContaCorrente(), usuario.getId());
        String id_caixa = "contas-correntes".concat("_caixa_").concat(SessaoUtil.getSessao().getIdFilial().toString()).concat("_PERFIL_").concat(SessaoUtil.getSessao().getUsuario().getIdPerfil().toString());
        String id_banco = "contas-correntes".concat("_banco_").concat(SessaoUtil.getSessao().getIdFilial().toString()).concat("_PERFIL_").concat(SessaoUtil.getSessao().getUsuario().getIdPerfil().toString());
        this.cacheService.removerCache(id_caixa);
        this.cacheService.removerCache(id_banco);
    }
}

